/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class BanManager {
    private static ServerEssentials plugin;
    private static File banFile;
    private static FileConfiguration banConfig;
    private static File configFile;
    private static FileConfiguration config;

    public BanManager(ServerEssentials pl) {
        plugin = pl;
        BanManager.setupBanFile();
        BanManager.setupConfigFile();
    }

    private static void setupBanFile() {
        banFile = new File(plugin.getDataFolder(), "storage/bans.yml");
        if (!banFile.exists()) {
            banFile.getParentFile().mkdirs();
            try {
                banFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        banConfig = YamlConfiguration.loadConfiguration((File)banFile);
    }

    private static void setupConfigFile() {
        configFile = new File(plugin.getDataFolder(), "config/bans/bans.yml");
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
        boolean changed = false;
        if (!config.contains("server-name")) {
            config.set("server-name", (Object)"MyCoolServer");
            changed = true;
        }
        if (!config.contains("discord-link")) {
            config.set("discord-link", (Object)"https://discord.gg/example");
            changed = true;
        }
        if (changed) {
            BanManager.saveConfig();
        }
    }

    public static void reload() {
        if (!banFile.exists() || !configFile.exists()) {
            BanManager.setupBanFile();
            BanManager.setupConfigFile();
        }
        banConfig = YamlConfiguration.loadConfiguration((File)banFile);
        config = YamlConfiguration.loadConfiguration((File)configFile);
        Bukkit.getLogger().info("[ServerEssentials] BanManager configs reloaded.");
    }

    public void banPlayer(UUID uuid, String name, String reason, String bannedBy, long until) {
        String path = "BannedPlayers." + String.valueOf(uuid);
        banConfig.set(path + ".name", (Object)name);
        banConfig.set(path + ".reason", (Object)reason);
        banConfig.set(path + ".bannedBy", (Object)bannedBy);
        banConfig.set(path + ".server", (Object)config.getString("server-name"));
        banConfig.set(path + ".discord", (Object)config.getString("discord-link"));
        banConfig.set(path + ".bannedUntil", (Object)until);
        BanManager.saveBans();
    }

    public boolean isBanned(UUID uuid) {
        String path = "BannedPlayers." + String.valueOf(uuid);
        if (!banConfig.contains(path)) {
            return false;
        }
        long until = banConfig.getLong(path + ".bannedUntil");
        if (until == -1L) {
            return true;
        }
        if (System.currentTimeMillis() > until) {
            this.unbanPlayer(uuid);
            return false;
        }
        return true;
    }

    public void unbanPlayer(UUID uuid) {
        banConfig.set("BannedPlayers." + String.valueOf(uuid), null);
        BanManager.saveBans();
    }

    public String getBanMessage(UUID uuid) {
        String path = "BannedPlayers." + String.valueOf(uuid);
        if (!banConfig.contains(path)) {
            return "\u00a7cYou are banned from this server.";
        }
        String reason = banConfig.getString(path + ".reason", "No reason specified.");
        String bannedBy = banConfig.getString(path + ".bannedBy", "Unknown");
        String server = config.getString("server-name", "Server");
        String discord = config.getString("discord-link", "N/A");
        long until = banConfig.getLong(path + ".bannedUntil");
        String timeLeft = until == -1L ? "Permanent" : new Date(until).toString();
        return "\u00a7cYou are banned from \u00a74" + server + "\n\u00a77Banned by: \u00a7f" + bannedBy + "\n\u00a77Reason: \u00a7f" + reason + "\n\u00a77Until: \u00a7f" + timeLeft + "\n\n\u00a77Appeal at: \u00a79" + discord;
    }

    public UUID getUUIDFromName(String name) {
        if (banConfig.contains("BannedPlayers")) {
            for (String key : banConfig.getConfigurationSection("BannedPlayers").getKeys(false)) {
                String storedName = banConfig.getString("BannedPlayers." + key + ".name");
                if (storedName == null || !storedName.equalsIgnoreCase(name)) continue;
                try {
                    return UUID.fromString(key);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    public Set<String> getAllBannedUUIDs() {
        if (banConfig.contains("BannedPlayers")) {
            return banConfig.getConfigurationSection("BannedPlayers").getKeys(false);
        }
        return Collections.emptySet();
    }

    public String getNameFromUUID(String uuid) {
        return banConfig.getString("BannedPlayers." + uuid + ".name", "Unknown");
    }

    public String getReason(String uuid) {
        return banConfig.getString("BannedPlayers." + uuid + ".reason", "No reason specified");
    }

    public long getUntil(String uuid) {
        return banConfig.getLong("BannedPlayers." + uuid + ".bannedUntil", -1L);
    }

    private static void saveBans() {
        try {
            banConfig.save(banFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveConfig() {
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

