/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class MessagesManager {
    private static MessagesManager instance;
    private final ServerEssentials plugin;
    private final Map<String, FileConfiguration> loadedFiles = new HashMap<String, FileConfiguration>();
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public MessagesManager(ServerEssentials plugin) {
        this.plugin = plugin;
        instance = this;
        this.loadMessages();
    }

    public static MessagesManager getInstance() {
        return instance;
    }

    private void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages/staff.yml");
        if (!this.messagesFile.getParentFile().exists()) {
            this.messagesFile.getParentFile().mkdirs();
        }
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages/staff.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.loadedFiles.put("staff.yml", this.messagesConfig);
    }

    public void addDefault(String path, String defaultMessage) {
        if (!this.messagesConfig.contains(path)) {
            this.messagesConfig.set(path, (Object)defaultMessage);
        }
    }

    public Component getMessageComponent(String path, String ... placeholders) {
        return this.get("staff.yml", path, placeholders);
    }

    public void save() {
        this.save("staff.yml");
    }

    public FileConfiguration getConfig() {
        return this.messagesConfig;
    }

    public void load(String fileName) {
        File file = new File(this.plugin.getDataFolder(), "messages/" + fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            this.plugin.saveResource("messages/" + fileName, false);
        }
        this.loadedFiles.put(fileName, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
    }

    public void reload(String fileName) {
        this.load(fileName);
        this.plugin.getLogger().info("[MessagesManager] Reloaded messages/" + fileName + " successfully.");
    }

    public void reloadAll() {
        for (String fileName : this.loadedFiles.keySet()) {
            this.load(fileName);
        }
        this.plugin.getLogger().info("[MessagesManager] Reloaded all message files (" + this.loadedFiles.size() + ").");
    }

    public static void fullReload() {
        if (instance != null) {
            instance.reloadAll();
        }
    }

    public Component get(String fileName, String path, String ... placeholders) {
        FileConfiguration config = this.loadedFiles.get(fileName);
        if (config == null) {
            this.load(fileName);
            config = this.loadedFiles.get(fileName);
        }
        String msg = config.getString(path, "<red>Missing message for " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public void save(String fileName) {
        FileConfiguration config = this.loadedFiles.get(fileName);
        if (config == null) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "messages/" + fileName);
        try {
            config.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save messages/" + fileName + "!");
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig(String fileName) {
        return this.loadedFiles.get(fileName);
    }
}

