/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.DailyRewardGUI;
import serveressentials.serveressentials.ShopManager;

public class AdminCommand
implements CommandExecutor {
    private static final String PREFIX = String.valueOf(ChatColor.DARK_RED) + "[" + String.valueOf(ChatColor.RED) + "Admin" + String.valueOf(ChatColor.DARK_RED) + "] " + String.valueOf(ChatColor.RESET);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.admin")) {
            sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + "Available commands: reload, give, set, reset, info");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                DailyRewardGUI.loadBalances();
                ShopManager.loadShopItems();
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "ServerEssentials reloaded successfully!");
                break;
            }
            case "give": {
                if (args.length < 3) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Usage: /admin give <player> <amount>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                double amount = Double.parseDouble(args[2]);
                DailyRewardGUI.addBalance((OfflinePlayer)target, amount);
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Gave $" + amount + " to " + target.getName());
                break;
            }
            case "set": {
                if (args.length < 3) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Usage: /admin set <player> <amount>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                double amount = Double.parseDouble(args[2]);
                DailyRewardGUI.setBalance(target, amount);
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s balance to $" + amount);
                break;
            }
            case "reset": {
                if (args.length < 2) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Usage: /admin reset <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                DailyRewardGUI.setBalance(target, 0.0);
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Reset " + target.getName() + "'s balance.");
                break;
            }
            case "info": {
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.GOLD) + "ServerEssentials v1.6 by _GodlyCow :)");
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Economy system, RTP GUI, Auction House, Home + Warp + TPA system and Shop GUI included.");
                break;
            }
            default: {
                sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Unknown command.");
            }
        }
        return true;
    }
}

