/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;

public class AdminUtilitiesCommand
implements CommandExecutor {
    private static final String PREFIX = String.valueOf(ChatColor.DARK_RED) + "[" + String.valueOf(ChatColor.RED) + "Admin" + String.valueOf(ChatColor.DARK_RED) + "] " + String.valueOf(ChatColor.RESET);
    private final Set<Player> vanished = new HashSet<Player>();
    private final Set<Player> godMode = new HashSet<Player>();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(PREFIX + "Only players can use this.");
            return true;
        }
        Player player = (Player)sender;
        switch (label.toLowerCase()) {
            case "vanish": {
                if (this.vanished.contains(player)) {
                    this.vanished.remove(player);
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.showPlayer((Plugin)ServerEssentials.getInstance(), player);
                    }
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + "You are now visible.");
                    break;
                }
                this.vanished.add(player);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.hidePlayer((Plugin)ServerEssentials.getInstance(), player);
                }
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GRAY) + "You have vanished.");
                break;
            }
            case "god": {
                if (this.godMode.contains(player)) {
                    this.godMode.remove(player);
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "God mode disabled.");
                    break;
                }
                this.godMode.add(player);
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "God mode enabled.");
                break;
            }
            case "invsee": {
                if (args.length < 1) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Usage: /invsee <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                player.openInventory((Inventory)target.getInventory());
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Opening " + target.getName() + "'s inventory.");
                break;
            }
            case "invclear": {
                Player target = player;
                if (args.length >= 1 && (target = Bukkit.getPlayer((String)args[0])) == null) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                target.getInventory().clear();
                target.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Your inventory was cleared.");
                if (target.equals((Object)player)) break;
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Cleared " + target.getName() + "'s inventory.");
                break;
            }
            case "tp": {
                if (args.length < 1) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Usage: /tp <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                player.teleport((Entity)target);
                player.sendMessage(PREFIX + String.valueOf(ChatColor.AQUA) + "Teleported to " + target.getName());
            }
        }
        return true;
    }

    public boolean isGodMode(Player player) {
        return this.godMode.contains(player);
    }
}

