/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.AuctionGUI;
import serveressentials.serveressentials.AuctionItem;
import serveressentials.serveressentials.AuctionManager;
import serveressentials.serveressentials.ServerEssentials;

public class AuctionCommand
implements CommandExecutor {
    private final AuctionManager auctionManager;

    public AuctionCommand(AuctionManager auctionManager) {
        this.auctionManager = auctionManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            new AuctionGUI(this.auctionManager).open(player, 0);
            return true;
        }
        if (args[0].equalsIgnoreCase("sell")) {
            if (args.length != 2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ah sell <price>");
                return true;
            }
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item == null || item.getType().isAir()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Hold the item you want to sell.");
                return true;
            }
            try {
                double price = Double.parseDouble(args[1]);
                int id = AuctionItem.getNextId();
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    NamespacedKey key = new NamespacedKey((Plugin)ServerEssentials.getInstance(), "auction-id");
                    meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)id);
                    item.setItemMeta(meta);
                }
                this.auctionManager.addItem(new AuctionItem(player.getUniqueId(), item.clone(), price, id));
                player.getInventory().setItemInMainHand(null);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Item listed for $" + price);
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number format.");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("remove") && args.length == 2 && args[1].equalsIgnoreCase("all")) {
            this.auctionManager.removeItemsBySeller(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "All your items have been removed from the auction house.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /ah, /ah sell <price>, or /ah remove all.");
        return true;
    }
}

