/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.AuctionItem;
import serveressentials.serveressentials.AuctionManager;
import serveressentials.serveressentials.ServerEssentials;

public class AuctionGUI {
    private final AuctionManager manager;

    public AuctionGUI(AuctionManager manager) {
        this.manager = manager;
    }

    public void open(Player player, int page) {
        List<AuctionItem> items = this.manager.getItems();
        List<Integer> centerSlots = List.of(Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23), Integer.valueOf(24), Integer.valueOf(29), Integer.valueOf(30), Integer.valueOf(31), Integer.valueOf(32), Integer.valueOf(33));
        int itemsPerPage = centerSlots.size();
        int totalPages = (int)Math.ceil((double)items.size() / (double)itemsPerPage);
        page = Math.max(0, Math.min(page, totalPages - 1));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GREEN) + "Auction House | Page " + (page + 1)));
        ItemStack glass = new ItemStack(Material.WHITE_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName(String.valueOf(ChatColor.GRAY) + " ");
        glass.setItemMeta(glassMeta);
        for (int i = 0; i < 54; ++i) {
            if (i >= 9 && i < 45 && i % 9 != 0 && i % 9 != 8) continue;
            gui.setItem(i, glass);
        }
        int start = page * itemsPerPage;
        int end = Math.min(start + itemsPerPage, items.size());
        List<AuctionItem> pageItems = items.subList(start, end);
        for (int i = 0; i < pageItems.size(); ++i) {
            AuctionItem auctionItem = pageItems.get(i);
            ItemStack item = auctionItem.getItem().clone();
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                NamespacedKey sellerKey = new NamespacedKey((Plugin)ServerEssentials.getInstance(), "auction-seller");
                NamespacedKey idKey = new NamespacedKey((Plugin)ServerEssentials.getInstance(), "auction-id");
                meta.getPersistentDataContainer().set(sellerKey, PersistentDataType.STRING, (Object)auctionItem.getSeller().toString());
                meta.getPersistentDataContainer().set(idKey, PersistentDataType.INTEGER, (Object)auctionItem.getId());
                ArrayList<CallSite> lore = meta.hasLore() ? new ArrayList<CallSite>(meta.getLore()) : new ArrayList();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + "Price: $" + auctionItem.getPrice())));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to purchase")));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            gui.setItem(centerSlots.get(i).intValue(), item);
        }
        if (page > 0) {
            gui.setItem(45, this.navItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Previous Page"));
        }
        gui.setItem(49, this.navItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close"));
        if (page < totalPages - 1) {
            gui.setItem(53, this.navItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Next Page"));
        }
        player.openInventory(gui);
    }

    private ItemStack navItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }
}

