/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.AuctionGUI;
import serveressentials.serveressentials.AuctionItem;
import serveressentials.serveressentials.AuctionManager;
import serveressentials.serveressentials.EconomyManager;
import serveressentials.serveressentials.ServerEssentials;

public class AuctionListener
implements Listener {
    private final AuctionManager manager;
    private static final String PREFIX = String.valueOf(ChatColor.GOLD) + "[Auction] " + String.valueOf(ChatColor.RESET);

    public AuctionListener(AuctionManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onAuctionClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = ChatColor.stripColor((String)event.getView().getTitle());
        if (!title.startsWith("Auction House")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = meta.hasDisplayName() ? ChatColor.stripColor((String)meta.getDisplayName()) : "";
        int page = 0;
        if (title.contains("Page")) {
            try {
                page = Integer.parseInt(title.replaceAll("[^0-9]", "")) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase("Previous Page")) {
            new AuctionGUI(this.manager).open(player, page - 1);
            return;
        }
        if (name.equalsIgnoreCase("Next Page")) {
            new AuctionGUI(this.manager).open(player, page + 1);
            return;
        }
        if (name.equalsIgnoreCase("Close")) {
            player.closeInventory();
            return;
        }
        NamespacedKey idKey = new NamespacedKey((Plugin)ServerEssentials.getInstance(), "auction-id");
        Integer auctionId = (Integer)meta.getPersistentDataContainer().get(idKey, PersistentDataType.INTEGER);
        if (auctionId == null) {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Could not identify this item.");
            return;
        }
        AuctionItem auctionItem = this.manager.getItemById(auctionId);
        if (auctionItem == null) {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Item no longer available.");
            return;
        }
        if (auctionItem.getSeller().equals(player.getUniqueId())) {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + "You can't buy your own item.");
            return;
        }
        double price = auctionItem.getPrice();
        double balance = EconomyManager.getBalance(player.getUniqueId());
        if (balance < price) {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "You don't have enough money.");
            return;
        }
        EconomyManager.takeBalance(player.getUniqueId(), price);
        player.getInventory().addItem(new ItemStack[]{auctionItem.getItem()});
        this.manager.removeItem(auctionItem);
        player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "You bought the item for $" + String.format("%.2f", price) + "!");
        int finalPage = page;
        Bukkit.getScheduler().runTaskLater((Plugin)ServerEssentials.getInstance(), () -> new AuctionGUI(this.manager).open(player, finalPage), 2L);
    }
}

