/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import serveressentials.serveressentials.AuctionItem;

public class AuctionManager {
    private final List<AuctionItem> items = new ArrayList<AuctionItem>();

    public void addItem(AuctionItem item) {
        this.items.add(item);
    }

    public List<AuctionItem> getItems() {
        return new ArrayList<AuctionItem>(this.items);
    }

    public AuctionItem getItemById(int id) {
        return this.items.stream().filter(item -> item.getId() == id).findFirst().orElse(null);
    }

    public void removeItemsBySeller(UUID seller) {
        this.items.removeIf(item -> item.getSeller().equals(seller));
    }

    public void removeItem(AuctionItem item) {
        this.items.remove(item);
    }

    public List<AuctionItem> getItemsByPage(int page, int pageSize) {
        int start = page * pageSize;
        int end = Math.min(start + pageSize, this.items.size());
        if (start >= this.items.size()) {
            return new ArrayList<AuctionItem>();
        }
        return this.items.subList(start, end);
    }

    public int getTotalPages(int pageSize) {
        return (int)Math.ceil((double)this.items.size() / (double)pageSize);
    }
}

