/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.BackManager;

public class BackCommand
implements CommandExecutor {
    private static final String PREFIX = ChatColor.translateAlternateColorCodes((char)'&', (String)"&l&2[&aTeleport&l&2] \u27a4 ");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (!BackManager.hasBack(player.getUniqueId())) {
                player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "No previous location saved.");
                return true;
            }
            Location backLocation = BackManager.getLastLocation(player.getUniqueId());
            if (backLocation == null) {
                player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Your last location is invalid.");
                return true;
            }
            player.teleport(backLocation);
            player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Teleported back to your previous location.");
            BackManager.clearBack(player.getUniqueId());
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "lobby": {
                Location lobbyLocation = this.getLobbyLocation();
                if (lobbyLocation == null) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Lobby location not set.");
                    return true;
                }
                player.teleport(lobbyLocation);
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Teleported to the lobby.");
                break;
            }
            case "death": {
                Location deathLocation = player.getLastDeathLocation();
                if (deathLocation == null) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "No death location found.");
                    return true;
                }
                player.teleport(deathLocation);
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Teleported to your last death location.");
                break;
            }
            case "back": {
                if (!BackManager.hasBack(player.getUniqueId())) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "No previous location saved.");
                    return true;
                }
                Location backLocation = BackManager.getLastLocation(player.getUniqueId());
                if (backLocation == null) {
                    player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Your last location is invalid.");
                    return true;
                }
                player.teleport(backLocation);
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Teleported back to your previous location.");
                BackManager.clearBack(player.getUniqueId());
                break;
            }
            default: {
                player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Unknown command. Use: /back, /back lobby, /back death.");
            }
        }
        return true;
    }

    private Location getLobbyLocation() {
        return new Location(Bukkit.getWorld((String)"world"), 0.0, 100.0, 0.0);
    }
}

