/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.BanManager;

public class BanCommand
implements CommandExecutor {
    private final BanManager banManager;

    public BanCommand(BanManager banManager) {
        this.banManager = banManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("ban.use")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ban <player> <time> <reason>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target == null || target.getName() == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "That player has never joined the server.");
            return true;
        }
        UUID uuid = target.getUniqueId();
        String name = target.getName();
        long duration = this.parseTime(args[1]);
        if (duration == -2L) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time format. Use s/m/h/d or 'perm'");
            return true;
        }
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        String bannedBy = sender instanceof Player ? ((Player)sender).getName() : "Console";
        long until = duration == -1L ? -1L : System.currentTimeMillis() + duration;
        this.banManager.banPlayer(uuid, name, reason, bannedBy, until);
        if (target.isOnline()) {
            ((Player)target).kickPlayer(this.banManager.getBanMessage(uuid));
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + name + " has been banned.");
        return true;
    }

    private long parseTime(String time) {
        if (time.equalsIgnoreCase("perm")) {
            return -1L;
        }
        try {
            long num = Long.parseLong(time.substring(0, time.length() - 1));
            char unit = time.charAt(time.length() - 1);
            return switch (unit) {
                case 's' -> num * 1000L;
                case 'm' -> num * 60L * 1000L;
                case 'h' -> num * 60L * 60L * 1000L;
                case 'd' -> num * 24L * 60L * 60L * 1000L;
                default -> -2L;
            };
        }
        catch (Exception e) {
            return -2L;
        }
    }
}

