/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import serveressentials.serveressentials.BanManager;

public class BanListCommand
implements CommandExecutor {
    private final BanManager banManager;

    public BanListCommand(BanManager banManager) {
        this.banManager = banManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("ban.use")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
            return true;
        }
        Set<String> bannedUUIDs = this.banManager.getAllBannedUUIDs();
        if (bannedUUIDs.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "There are no banned players.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "------[ Banned Players ]------");
        for (String uuid : bannedUUIDs) {
            String name = this.banManager.getNameFromUUID(uuid);
            String reason = this.banManager.getReason(uuid);
            long until = this.banManager.getUntil(uuid);
            String time = until == -1L ? "Permanent" : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(until));
            sender.sendMessage(String.valueOf(ChatColor.RED) + name + String.valueOf(ChatColor.GRAY) + " - " + String.valueOf(ChatColor.WHITE) + reason + String.valueOf(ChatColor.GRAY) + " (" + String.valueOf(ChatColor.AQUA) + time + String.valueOf(ChatColor.GRAY) + ")");
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "-----------------------------");
        return true;
    }
}

