/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class CommandSettingUtil {
    private static final String FILE_NAME = "commands.yml";
    private static FileConfiguration config;
    private static File file;
    private static final Set<String> NON_DISABLEABLE_COMMANDS;
    private static final Map<String, Boolean> DEFAULT_COMMANDS;

    public static void setup(ServerEssentials plugin) {
        file = new File(plugin.getDataFolder(), FILE_NAME);
        if (!file.exists()) {
            try {
                plugin.getDataFolder().mkdirs();
                file.createNewFile();
                config = YamlConfiguration.loadConfiguration((File)file);
                for (Map.Entry<String, Boolean> entry : DEFAULT_COMMANDS.entrySet()) {
                    config.set(entry.getKey(), (Object)entry.getValue());
                }
                config.save(file);
                plugin.getLogger().info("Generated default commands.yml");
            }
            catch (IOException e) {
                plugin.getLogger().severe("Failed to create commands.yml");
                e.printStackTrace();
            }
        } else {
            config = YamlConfiguration.loadConfiguration((File)file);
        }
    }

    public static boolean isCommandEnabled(String command) {
        if (NON_DISABLEABLE_COMMANDS.contains(command.toLowerCase())) {
            return true;
        }
        if (config == null) {
            ServerEssentials.getInstance().getLogger().warning("commands.yml not loaded, allowing command: " + command);
            return true;
        }
        return config.getBoolean(command.toLowerCase(), true);
    }

    static {
        NON_DISABLEABLE_COMMANDS = Set.of("serveressentials", "version", "help");
        DEFAULT_COMMANDS = new HashMap<String, Boolean>();
        DEFAULT_COMMANDS.put("balance", true);
        DEFAULT_COMMANDS.put("warp", true);
        DEFAULT_COMMANDS.put("sethome", false);
        DEFAULT_COMMANDS.put("adminchat", true);
        DEFAULT_COMMANDS.put("serveressentials", true);
        DEFAULT_COMMANDS.put("version", true);
    }
}

