/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.EconomyManager;

public class EcoCommand
implements CommandExecutor {
    private static final String PREFIX = "\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 ";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cUsage: /eco <give|take|reset> <player> [amount]");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cPlayer not found.");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "give": {
                if (args.length < 3) {
                    return this.error(sender, "Usage: /eco give <player> <amount>");
                }
                double giveAmount = this.parseAmount(args[2], sender);
                if (giveAmount < 0.0) {
                    return true;
                }
                EconomyManager.addBalance((OfflinePlayer)target, giveAmount);
                sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7aGave \u00a76$" + giveAmount + " \u00a7ato \u00a7e" + target.getName());
                break;
            }
            case "take": {
                if (args.length < 3) {
                    return this.error(sender, "Usage: /eco take <player> <amount>");
                }
                double takeAmount = this.parseAmount(args[2], sender);
                if (takeAmount < 0.0) {
                    return true;
                }
                EconomyManager.takeBalance((OfflinePlayer)target, takeAmount);
                sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7aTook \u00a76$" + takeAmount + " \u00a7afrom \u00a7e" + target.getName());
                break;
            }
            case "reset": {
                EconomyManager.resetBalance(target);
                sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7aReset balance of \u00a7e" + target.getName());
                break;
            }
            default: {
                return this.error(sender, "Unknown subcommand: " + args[0]);
            }
        }
        return true;
    }

    private boolean error(CommandSender sender, String msg) {
        sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7c" + msg);
        return true;
    }

    private double parseAmount(String input, CommandSender sender) {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cInvalid amount.");
            return -1.0;
        }
    }
}

