/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EconomyManager {
    private static final HashMap<UUID, Double> balances = new HashMap();
    private static File file;
    private static FileConfiguration config;

    public static void loadBalances() {
        file = new File(Bukkit.getServer().getPluginManager().getPlugin("ServerEssentials").getDataFolder(), "balances.yml");
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                Bukkit.getLogger().info("Created new balances.yml file.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        for (String key : config.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                double balance = config.getDouble(key);
                balances.put(uuid, balance);
                Bukkit.getLogger().info("Loaded balance for " + String.valueOf(uuid) + ": " + balance);
            }
            catch (IllegalArgumentException ignored) {
                Bukkit.getLogger().warning("Invalid UUID in balances.yml: " + key);
            }
        }
    }

    public static void saveBalances() {
        if (config == null || file == null) {
            return;
        }
        for (Map.Entry<UUID, Double> entry : balances.entrySet()) {
            config.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            config.save(file);
            Bukkit.getLogger().info("Saved balances to balances.yml.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double getBalance(@NotNull OfflinePlayer player) {
        return balances.getOrDefault(player.getUniqueId(), 0.0);
    }

    public static double getBalance(@NotNull UUID uuid) {
        return balances.getOrDefault(uuid, 0.0);
    }

    public static void setBalance(@NotNull UUID uuid, double amount) {
        balances.put(uuid, amount);
        System.out.println("Balance set for " + String.valueOf(uuid) + ": " + amount);
        EconomyManager.saveBalances();
    }

    public static void setBalance(@NotNull Player player, double amount) {
        EconomyManager.setBalance(player.getUniqueId(), amount);
    }

    public static void addBalance(@NotNull UUID uuid, double amount) {
        double current = EconomyManager.getBalance(uuid);
        balances.put(uuid, current + amount);
        EconomyManager.saveBalances();
        Bukkit.getLogger().info("Added " + amount + " to " + String.valueOf(uuid) + "'s balance. New balance: " + EconomyManager.getBalance(uuid));
    }

    public static void addBalance(@NotNull OfflinePlayer player, double amount) {
        EconomyManager.addBalance(player.getUniqueId(), amount);
    }

    public static void takeBalance(@NotNull UUID uuid, double amount) {
        double current = EconomyManager.getBalance(uuid);
        balances.put(uuid, Math.max(0.0, current - amount));
        EconomyManager.saveBalances();
        Bukkit.getLogger().info("Took " + amount + " from " + String.valueOf(uuid) + "'s balance. New balance: " + EconomyManager.getBalance(uuid));
    }

    public static void takeBalance(@NotNull OfflinePlayer player, double amount) {
        EconomyManager.takeBalance(player.getUniqueId(), amount);
    }

    public static boolean withdraw(@NotNull OfflinePlayer player, double amount) {
        double balance = EconomyManager.getBalance(player);
        if (balance < amount) {
            return false;
        }
        EconomyManager.setBalance(player.getUniqueId(), balance - amount);
        Bukkit.getLogger().info("Withdrew " + amount + " from " + player.getName() + "'s account.");
        return true;
    }

    public static void deposit(@NotNull OfflinePlayer player, double amount) {
        EconomyManager.addBalance(player, amount);
        Bukkit.getLogger().info("Deposited " + amount + " to player " + player.getName() + "'s account. New balance: " + EconomyManager.getBalance(player));
    }

    public static void resetBalance(@NotNull Player player) {
        EconomyManager.setBalance(player.getUniqueId(), 0.0);
        Bukkit.getLogger().info("Reset balance for " + player.getName() + " to 0.");
    }

    public static List<Map.Entry<UUID, Double>> getTopBalances(int limit) {
        ArrayList<Map.Entry<UUID, Double>> list = new ArrayList<Map.Entry<UUID, Double>>(balances.entrySet());
        list.sort((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue()));
        return list.subList(0, Math.min(limit, list.size()));
    }

    public static void removeBalance(@NotNull UUID uniqueId, double price) {
    }
}

