/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.HomeManager;

public class HomeCommand
implements CommandExecutor {
    private static final String PREFIX = "\u00a7l\u00a75[\u00a7dHomes\u00a7l\u00a75] \u27a4 ";
    private static final int[] HOME_SLOTS = new int[]{10, 13, 16};

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        HomeCommand.openHomesGUI(player, 0);
        return true;
    }

    public static void openHomesGUI(Player player, int page) {
        int index;
        Map allHomes = new ArrayList<Map.Entry<String, Location>>(HomeManager.getHomes(player.getUniqueId()).entrySet()).stream().sorted(Map.Entry.comparingByKey()).collect(LinkedHashMap::new, (m, e) -> m.put((String)e.getKey(), (Location)e.getValue()), Map::putAll);
        ArrayList homesList = new ArrayList(allHomes.entrySet());
        int totalPages = (int)Math.ceil((double)homesList.size() / 3.0);
        page = Math.max(0, Math.min(page, totalPages - 1));
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.BLUE) + "Your Homes (Page " + (page + 1) + ")"));
        int startIndex = page * 3;
        for (int i = 0; i < 3 && (index = startIndex + i) < homesList.size(); ++i) {
            Map.Entry entry = (Map.Entry)homesList.get(index);
            String name = (String)entry.getKey();
            Location loc = (Location)entry.getValue();
            ItemStack bed = new ItemStack(loc != null ? Material.BLUE_BED : Material.GRAY_BED);
            ItemMeta meta = bed.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + name);
            meta.setLore(Collections.singletonList(loc != null ? String.valueOf(ChatColor.GREEN) + "Click to teleport" : String.valueOf(ChatColor.RED) + "Not set"));
            bed.setItemMeta(meta);
            gui.setItem(HOME_SLOTS[i], bed);
        }
        if (page > 0) {
            ItemStack backArrow = new ItemStack(Material.ARROW);
            ItemMeta meta = backArrow.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
            backArrow.setItemMeta(meta);
            gui.setItem(18, backArrow);
        }
        if (page < totalPages - 1) {
            ItemStack nextArrow = new ItemStack(Material.ARROW);
            ItemMeta meta = nextArrow.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
            nextArrow.setItemMeta(meta);
            gui.setItem(26, nextArrow);
        }
        player.openInventory(gui);
    }
}

