/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.HomeCommand;
import serveressentials.serveressentials.HomeManager;

public class HomeGUIListener
implements Listener {
    private static final String PREFIX = "\u00a7l\u00a75[\u00a7dHomes\u00a7l\u00a75] \u27a4 ";

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = ChatColor.stripColor((String)event.getView().getTitle());
        if (!title.startsWith("Your Homes")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        String displayName = ChatColor.stripColor((String)meta.getDisplayName());
        int currentPage = 0;
        if (title.contains("Page")) {
            try {
                currentPage = Integer.parseInt(title.replaceAll("[^0-9]", "")) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (displayName.equalsIgnoreCase("Next Page")) {
            HomeCommand.openHomesGUI(player, currentPage + 1);
            return;
        }
        if (displayName.equalsIgnoreCase("Previous Page")) {
            HomeCommand.openHomesGUI(player, currentPage - 1);
            return;
        }
        String homeName = displayName.toLowerCase();
        Location home = HomeManager.getHome(player.getUniqueId(), homeName);
        if (home != null) {
            player.closeInventory();
            player.teleport(home);
            player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Teleported to home '" + homeName + "'.");
        } else {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "That home isn't set.");
        }
    }
}

