/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class KillTracker
implements Listener {
    private final File file;
    private final FileConfiguration config;

    public KillTracker(JavaPlugin plugin) {
        this.file = new File(plugin.getDataFolder(), "kills.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerKill(PlayerDeathEvent event) {
        if (!(event.getEntity().getKiller() instanceof Player)) {
            return;
        }
        Player killer = event.getEntity().getKiller();
        UUID uuid = killer.getUniqueId();
        String path = uuid.toString();
        int kills = this.config.getInt(path, 0) + 1;
        this.config.set(path, (Object)kills);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        killer.sendMessage("\u00a7aKill recorded! You now have \u00a7e" + kills + "\u00a7a kills.");
    }

    public int getKills(Player player) {
        return this.config.getInt(player.getUniqueId().toString(), 0);
    }
}

