/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.KitConfigManager;

public class KitCommand
implements CommandExecutor {
    private final Map<UUID, Map<String, Long>> cooldowns = new HashMap<UUID, Map<String, Long>>();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("serveressentials.kit.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to reload kits.");
                return true;
            }
            KitConfigManager.reload();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Kit configuration reloaded.");
            return true;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        FileConfiguration config = KitConfigManager.getConfig();
        ConfigurationSection kits = config.getConfigurationSection("kits");
        if (kits == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No kits found in configuration.");
            return true;
        }
        int size = ((kits.getKeys(false).size() - 1) / 9 + 1) * 9;
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.GREEN) + "Available Kits"));
        for (String kit : kits.getKeys(false)) {
            ItemStack icon;
            boolean hasPermission;
            String perm = config.getString("kits." + kit + ".permission");
            int cooldown = config.getInt("kits." + kit + ".cooldown");
            String name = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("kits." + kit + ".display.name", kit));
            List lore = config.getStringList("kits." + kit + ".display.lore");
            String materialName = config.getString("kits." + kit + ".display.material", "CHEST");
            Material displayMat = Material.matchMaterial((String)materialName.toUpperCase());
            if (displayMat == null) {
                displayMat = Material.CHEST;
            }
            ArrayList<Object> finalLore = new ArrayList<Object>();
            for (String line : lore) {
                finalLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            long now = System.currentTimeMillis();
            long lastUsed = ((Map)this.cooldowns.getOrDefault(player.getUniqueId(), new HashMap())).getOrDefault(kit, 0L);
            long diff = (now - lastUsed) / 1000L;
            boolean bl = hasPermission = perm == null || player.hasPermission(perm);
            if (!hasPermission) {
                icon = new ItemStack(Material.RED_STAINED_GLASS_PANE);
                finalLore.add(String.valueOf(ChatColor.RED) + "You don't have permission.");
            } else if (diff < (long)cooldown && lastUsed > 0L) {
                icon = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                finalLore.add(String.valueOf(ChatColor.GRAY) + "Claimed. Cooldown: " + this.formatTime((long)cooldown - diff));
            } else {
                icon = new ItemStack(displayMat);
                finalLore.add(String.valueOf(ChatColor.GREEN) + "Click to claim!");
            }
            ItemMeta meta = icon.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(name);
                meta.setLore(finalLore);
                icon.setItemMeta(meta);
            }
            gui.addItem(new ItemStack[]{icon});
        }
        player.openInventory(gui);
        return true;
    }

    private String formatTime(long seconds) {
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        return String.format("%02dh %02dm %02ds", h, m, s);
    }

    public Map<UUID, Map<String, Long>> getCooldowns() {
        return this.cooldowns;
    }
}

