/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class KitConfigManager {
    private static FileConfiguration config;
    private static File file;

    public static void setup(JavaPlugin plugin) {
        file = new File(plugin.getDataFolder(), "kits.yml");
        if (!file.exists()) {
            try {
                plugin.getDataFolder().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(config = YamlConfiguration.loadConfiguration((File)file)).contains("kits")) {
            for (int i = 1; i <= 7; ++i) {
                String kitName = "kit" + i;
                config.set("kits." + kitName + ".permission", (Object)("serveressentials." + kitName));
                config.set("kits." + kitName + ".cooldown", (Object)3600);
                config.set("kits." + kitName + ".display.name", (Object)("&a" + kitName.toUpperCase()));
                config.set("kits." + kitName + ".display.lore", Arrays.asList("&7This is kit " + i));
                config.set("kits." + kitName + ".display.material", (Object)"CHEST");
                config.set("kits." + kitName + ".items", Arrays.asList("DIAMOND_SWORD", "GOLDEN_APPLE"));
            }
            KitConfigManager.save();
        }
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

