/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import serveressentials.serveressentials.KitCommand;
import serveressentials.serveressentials.KitConfigManager;

public class KitGUIListener
implements Listener {
    private final KitCommand kitCommand;

    public KitGUIListener(KitCommand command) {
        this.kitCommand = command;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().contains("Available Kits")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        FileConfiguration config = KitConfigManager.getConfig();
        for (String kit : config.getConfigurationSection("kits").getKeys(false)) {
            long lastUsed;
            String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("kits." + kit + ".display.name", kit));
            if (!clicked.getItemMeta().getDisplayName().equalsIgnoreCase(displayName)) continue;
            String permission = config.getString("kits." + kit + ".permission");
            int cooldown = config.getInt("kits." + kit + ".cooldown");
            if (permission != null && !player.hasPermission(permission)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to claim this kit.");
                return;
            }
            long now = System.currentTimeMillis();
            long diff = (now - (lastUsed = ((Map)this.kitCommand.getCooldowns().getOrDefault(player.getUniqueId(), new HashMap())).getOrDefault(kit, 0L).longValue())) / 1000L;
            if (diff < (long)cooldown) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + ((long)cooldown - diff) + " seconds.");
                return;
            }
            List itemList = config.getStringList("kits." + kit + ".items");
            for (String matName : itemList) {
                Material mat = Material.matchMaterial((String)matName);
                if (mat == null) continue;
                player.getInventory().addItem(new ItemStack[]{new ItemStack(mat)});
            }
            this.kitCommand.getCooldowns().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(kit, now);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You claimed kit: " + kit);
            player.closeInventory();
            break;
        }
    }
}

