/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import serveressentials.serveressentials.Kit;

public class KitManager {
    private static final Map<String, Kit> kits = new HashMap<String, Kit>();

    public static void loadKits(FileConfiguration config) {
        kits.clear();
        if (!config.isConfigurationSection("kits")) {
            return;
        }
        for (String kitName : config.getConfigurationSection("kits").getKeys(false)) {
            String path = "kits." + kitName;
            String permission = config.getString(path + ".permission");
            Material display = Material.valueOf((String)config.getString(path + ".display", "STONE"));
            int slot = config.getInt(path + ".slot", 0);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (String itemLine : config.getStringList(path + ".items")) {
                String[] parts = itemLine.split(" ");
                Material material = Material.valueOf((String)parts[0].toUpperCase());
                int amount = Integer.parseInt(parts[1]);
                items.add(new ItemStack(material, amount));
            }
            kits.put(kitName, new Kit(kitName, permission, display, slot, items));
        }
    }

    public static Map<String, Kit> getKits() {
        return kits;
    }

    public static Kit getKit(String name) {
        return kits.get(name);
    }
}

