/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LobbyManager {
    private static File file;
    private static FileConfiguration config;
    private static Location lobby;

    public static void setup() {
        file = new File(Bukkit.getServer().getPluginManager().getPlugin("ServerEssentials").getDataFolder(), "lobby.yml");
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        lobby = config.getLocation("lobby");
    }

    public static void loadLobby() {
        if (file == null || config == null) {
            LobbyManager.setup();
        }
        lobby = config.getLocation("lobby");
    }

    public static void setLobby(Location location) {
        lobby = location;
        config.set("lobby", (Object)location);
        LobbyManager.save();
    }

    public static Location getLobby() {
        return lobby;
    }

    public static void removeLobby() {
        lobby = null;
        config.set("lobby", null);
        LobbyManager.save();
    }

    public static boolean hasLobby() {
        return lobby != null;
    }

    private static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

