/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MotdCommand
implements CommandExecutor {
    private final JavaPlugin plugin;

    public MotdCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.setmotd")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to change the MOTD.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /setmotd <message>");
            return true;
        }
        String motd = String.join((CharSequence)" ", args);
        motd = ChatColor.translateAlternateColorCodes((char)'&', (String)motd);
        try {
            this.updateMotd(motd);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "MOTD has been updated to: " + motd);
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to update the MOTD.");
            e.printStackTrace();
        }
        return true;
    }

    private void updateMotd(String newMotd) throws IOException {
        File serverProperties = new File(this.plugin.getServer().getWorldContainer(), "server.properties");
        String content = new String(Files.readAllBytes(Paths.get(serverProperties.getPath(), new String[0])), "UTF-8");
        content = content.replaceAll("motd=.*", "motd=" + newMotd);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(serverProperties.getPath(), new String[0]), new OpenOption[0]);){
            writer.write(content);
        }
        this.plugin.getServer().reload();
    }
}

