/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.EconomyManager;

public class PayCommand
implements CommandExecutor {
    private static final String PREFIX = "\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 ";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            return false;
        }
        Player senderPlayer = (Player)sender;
        if (args.length != 2) {
            senderPlayer.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cUsage: /pay <player> <amount>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            senderPlayer.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cPlayer not found.");
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            senderPlayer.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cInvalid amount.");
            return true;
        }
        if (amount <= 0.0) {
            senderPlayer.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cAmount must be positive.");
            return true;
        }
        if (EconomyManager.getBalance((OfflinePlayer)senderPlayer) < amount) {
            senderPlayer.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7cYou don't have enough money.");
            return true;
        }
        EconomyManager.takeBalance((OfflinePlayer)senderPlayer, amount);
        EconomyManager.addBalance(target, amount);
        senderPlayer.sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7aPaid \u00a7e" + target.getName() + " \u00a7a$" + amount);
        if (target.isOnline()) {
            ((Player)target).sendMessage("\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 \u00a7aYou received \u00a7e$" + amount + " \u00a7afrom \u00a7e" + senderPlayer.getName());
        }
        return true;
    }
}

