/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.BackManager;
import serveressentials.serveressentials.CooldownManager;
import serveressentials.serveressentials.RTPConfig;
import serveressentials.serveressentials.ServerEssentials;

public class RTPListener
implements Listener {
    private final Random random = new Random();
    private final File rtpLogFile = new File("plugins/ServerEssentials/rtplocations.yml");
    private final YamlConfiguration rtpLog = YamlConfiguration.loadConfiguration((File)this.rtpLogFile);
    private static final String PREFIX = ChatColor.translateAlternateColorCodes((char)'&', (String)"&l&2[&aTeleport&l&2] \u27a4 ");

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int y;
        int z;
        int x;
        World world;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.GREEN) + "Choose a Dimension")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        switch (clicked.getType()) {
            case GRASS_BLOCK: {
                world = Bukkit.getWorld((String)"world");
                break;
            }
            case NETHERRACK: {
                world = Bukkit.getWorld((String)"world_nether");
                break;
            }
            case END_STONE: {
                world = Bukkit.getWorld((String)"world_the_end");
                break;
            }
            default: {
                return;
            }
        }
        if (world == null) {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "That world isn't loaded!");
            return;
        }
        String worldName = world.getName();
        if (!RTPConfig.isEnabled(worldName)) {
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Teleportation to this world is disabled.");
            return;
        }
        if (CooldownManager.isOnCooldown(player.getUniqueId())) {
            long remaining = CooldownManager.getRemaining(player.getUniqueId());
            player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "You're on cooldown! Try again in " + remaining + " seconds.");
            return;
        }
        CooldownManager.setCooldown(player.getUniqueId(), RTPConfig.getCooldown(worldName));
        int min = RTPConfig.getMinRadius(worldName);
        int max = RTPConfig.getMaxRadius(worldName);
        if (world.getEnvironment() == World.Environment.THE_END) {
            int distance = min + this.random.nextInt(max - min + 1);
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            x = (int)(Math.cos(angle) * (double)distance);
            z = (int)(Math.sin(angle) * (double)distance);
        } else {
            x = this.random.nextInt(max - min + 1) + min;
            x *= this.random.nextBoolean() ? 1 : -1;
            z = this.random.nextInt(max - min + 1) + min;
            z *= this.random.nextBoolean() ? 1 : -1;
        }
        if (world.getEnvironment() == World.Environment.NETHER) {
            y = 64;
        } else {
            y = world.getHighestBlockYAt(x, z);
            if (y <= 0) {
                player.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + "Couldn't find a safe teleport spot. Try again.");
                return;
            }
            ++y;
        }
        Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        BackManager.setLastLocation(player.getUniqueId(), player.getLocation());
        player.closeInventory();
        world.spawnParticle(Particle.PORTAL, player.getLocation(), 100, 1.0, 1.0, 1.0);
        world.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        Bukkit.getScheduler().runTaskLater((Plugin)ServerEssentials.getInstance(), () -> {
            player.teleport(loc);
            player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Teleported to a random location in " + world.getName() + "!");
            world.spawnParticle(Particle.PORTAL, loc, 100, 1.0, 1.0, 1.0);
            world.playSound(loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }, 40L);
        this.rtpLog.set(player.getName(), (Object)(world.getName() + ": " + x + " " + y + " " + z));
        try {
            this.rtpLog.save(this.rtpLogFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        BackManager.setLastLocation(player.getUniqueId(), player.getLocation());
    }
}

