/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.Rank;
import serveressentials.serveressentials.RankManager;

public class RankCommand
implements CommandExecutor {
    private final RankManager rankManager;

    public RankCommand(RankManager rankManager) {
        this.rankManager = rankManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("rank.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
            StringBuilder sb = new StringBuilder("\u00a76Available Ranks:\n");
            for (Rank rank : Rank.values()) {
                sb.append(rank.getColor()).append("\u00a7l[").append(rank.name()).append("]\u00a7r ").append("\u00a77- ").append(rank.name()).append("\n");
            }
            sender.sendMessage(sb.toString());
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found.");
                return true;
            }
            this.rankManager.removeRank(target);
            sender.sendMessage("\u00a77Removed rank from " + target.getName() + ".");
            target.sendMessage("\u00a77Your rank has been completely removed.");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("disable") && sender instanceof Player) {
            Player player = (Player)sender;
            this.rankManager.resetRank(player);
            player.sendMessage("\u00a77Your rank has been removed.");
            return true;
        }
        if (args.length != 3 || !args[0].equalsIgnoreCase("set")) {
            sender.sendMessage("\u00a7eUsage: /rank set <player> <rank>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found.");
            return true;
        }
        Rank rank = Rank.fromString(args[2]);
        if (rank == null) {
            sender.sendMessage("\u00a7cInvalid rank.");
            return true;
        }
        this.rankManager.setRank(target, rank);
        sender.sendMessage("\u00a7aSet " + target.getName() + "'s rank to " + rank.getPrefix());
        target.sendMessage("\u00a7aYour rank has been set to " + rank.getPrefix());
        return true;
    }
}

