/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import serveressentials.serveressentials.Rank;

public class RankManager {
    private final Map<UUID, Rank> playerRanks = new HashMap<UUID, Rank>();
    private final File file;
    private final FileConfiguration config;
    private final File tabOrderFile;
    private final FileConfiguration tabOrderConfig;

    public RankManager(JavaPlugin plugin) {
        this.file = new File(plugin.getDataFolder(), "ranks.yml");
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.tabOrderFile = new File(plugin.getDataFolder(), "taborder.yml");
        if (!this.tabOrderFile.exists()) {
            try {
                this.tabOrderFile.createNewFile();
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((File)this.tabOrderFile);
                int i = 1;
                for (Rank rank : Rank.values()) {
                    defaultConfig.set(rank.name(), (Object)i++);
                }
                defaultConfig.save(this.tabOrderFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.tabOrderConfig = YamlConfiguration.loadConfiguration((File)this.tabOrderFile);
        this.loadRanks();
    }

    public Rank getRank(Player player) {
        return this.playerRanks.get(player.getUniqueId());
    }

    public void setRank(Player player, Rank rank) {
        if (rank == null) {
            this.removeRank(player);
            return;
        }
        this.playerRanks.put(player.getUniqueId(), rank);
        this.updateTabName(player, rank);
        this.saveRanks();
        LuckPerms lp = LuckPermsProvider.get();
        User user = lp.getUserManager().getUser(player.getUniqueId());
        if (user != null) {
            for (Rank r : Rank.values()) {
                InheritanceNode node = (InheritanceNode)InheritanceNode.builder((String)r.getGroup()).build();
                user.data().remove((Node)node);
            }
            InheritanceNode newNode = (InheritanceNode)InheritanceNode.builder((String)rank.getGroup()).build();
            user.data().add((Node)newNode);
            lp.getUserManager().saveUser(user);
        }
    }

    public void removeRank(Player player) {
        this.playerRanks.remove(player.getUniqueId());
        player.setPlayerListName(player.getName());
        this.config.set(player.getUniqueId().toString(), null);
        this.saveRanks();
        LuckPerms lp = LuckPermsProvider.get();
        User user = lp.getUserManager().getUser(player.getUniqueId());
        if (user != null) {
            for (Rank r : Rank.values()) {
                InheritanceNode node = (InheritanceNode)InheritanceNode.builder((String)r.getGroup()).build();
                user.data().remove((Node)node);
            }
            lp.getUserManager().saveUser(user);
        }
    }

    public void resetRank(Player player) {
        this.removeRank(player);
    }

    public void updateTabName(Player player, Rank rank) {
        String displayName;
        String name = player.getName();
        Object prefix = "";
        if (rank != null) {
            prefix = rank.getColor() + "\u00a7l[" + rank.name() + "]\u00a7r ";
        }
        player.setPlayerListName((String)((displayName = (String)prefix + name).length() > 32 ? displayName.substring(0, 32) : displayName));
    }

    public int getTabOrder(Rank rank) {
        if (rank == null) {
            return 999;
        }
        return this.tabOrderConfig.getInt(rank.name(), 999);
    }

    private void saveRanks() {
        HashSet keys = new HashSet(this.config.getKeys(false));
        for (String key : keys) {
            try {
                UUID uuid = UUID.fromString(key);
                if (this.playerRanks.containsKey(uuid)) continue;
                this.config.set(key, null);
            }
            catch (IllegalArgumentException e) {
                this.config.set(key, null);
            }
        }
        for (UUID uuid : this.playerRanks.keySet()) {
            this.config.set(uuid.toString(), (Object)this.playerRanks.get(uuid).name());
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadRanks() {
        for (String key : this.config.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                Rank rank = Rank.fromString(this.config.getString(key));
                if (rank == null) continue;
                this.playerRanks.put(uuid, rank);
            }
            catch (IllegalArgumentException uuid) {}
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Rank rank = this.getRank(player);
            this.updateTabName(player, rank);
        }
    }
}

