/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.java.JavaPlugin;

public class ReportCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final File file;
    private final YamlConfiguration config;

    public ReportCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "reports.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used in-game.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /report <player> <reason>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null) {
            player.sendMessage("\u00a7cPlayer not found.");
            return true;
        }
        String reason = String.join((CharSequence)" ", args).substring(args[0].length()).trim();
        String message = "\u00a7c[REPORT] \u00a77" + player.getName() + " reported " + target.getName() + " for: " + reason;
        for (OfflinePlayer op2 : Bukkit.getOperators()) {
            UUID uuid = op2.getUniqueId();
            String path = "reports." + String.valueOf(uuid) + ".messages";
            this.config.set(path, (Object)this.config.getStringList(path));
            this.config.getStringList(path).add(message);
        }
        Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(op -> op.sendMessage(message));
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendMessage("\u00a7aYour report has been submitted.");
        return true;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }
}

