/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class RulesManager {
    private final JavaPlugin plugin;
    private File rulesFile;
    private FileConfiguration rulesConfig;

    public RulesManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadOrCreateRules();
    }

    private void loadOrCreateRules() {
        this.rulesFile = new File(this.plugin.getDataFolder(), "rules.yml");
        if (!this.rulesFile.exists()) {
            try {
                this.plugin.getDataFolder().mkdirs();
                this.rulesFile.createNewFile();
                this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
                List<String> defaultRules = Arrays.asList("&c1. Be respectful to others.", "&e2. No griefing or stealing.", "&b3. Keep chat appropriate.", "&a4. No cheating or using exploits.");
                this.rulesConfig.set("rules", defaultRules);
                this.rulesConfig.save(this.rulesFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create rules.yml: " + e.getMessage());
            }
        } else {
            this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
        }
    }

    public List<String> getRules() {
        return this.rulesConfig.getStringList("rules");
    }

    public void reloadRules() {
        this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
    }

    public void saveRules() {
        try {
            this.rulesConfig.save(this.rulesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save rules.yml: " + e.getMessage());
        }
    }
}

