/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.EconomyManager;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.ShopManager;

public class SellGUIListener
implements Listener {
    private static final String PREFIX = "\u00a76\u00a7l[\u00a7eEconomy\u00a76\u00a7l] \u27a4 ";

    public static void openSellGUI(Player player) {
        Inventory sellInv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(ChatColor.RED) + "Sell Items Here"));
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.setDisplayName(" ");
            glass.setItemMeta(glassMeta);
        }
        for (int i = 0; i < 54; ++i) {
            if (i >= 9 && i < 45 && i % 9 != 0 && i % 9 != 8) continue;
            sellInv.setItem(i, glass);
        }
        ItemStack sellButton = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta sellMeta = sellButton.getItemMeta();
        if (sellMeta != null) {
            sellMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Click to Sell All Items");
            sellButton.setItemMeta(sellMeta);
        }
        sellInv.setItem(48, sellButton);
        ItemStack cancelButton = new ItemStack(Material.BARRIER);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        if (cancelMeta != null) {
            cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
            cancelButton.setItemMeta(cancelMeta);
        }
        sellInv.setItem(49, cancelButton);
        sellInv.setItem(50, SellGUIListener.createTotalDisplay(0.0));
        player.openInventory(sellInv);
        SellGUIListener.updateTotalValue(sellInv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.RED) + "Sell Items Here")) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot >= 54) {
            return;
        }
        if (slot == 48 || slot == 49 || slot == 50 || slot < 9 || slot >= 45 || slot % 9 == 0 || slot % 9 == 8) {
            event.setCancelled(true);
        }
        if (slot == 48) {
            event.setCancelled(true);
            double total = this.sellItems(event.getInventory(), player);
            if (total > 0.0) {
                player.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + "Sold items for $" + String.format("%.2f", total));
            } else {
                player.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + "No sellable items found.");
            }
            player.closeInventory();
            return;
        }
        if (slot == 49) {
            event.setCancelled(true);
            this.returnUnsoldItems(event.getInventory(), player);
            player.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + "Sale cancelled. Items returned.");
            player.closeInventory();
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ServerEssentials.getInstance(), () -> SellGUIListener.updateTotalValue(event.getView().getTopInventory()), 1L);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.RED) + "Sell Items Here")) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot != 48 && slot != 49 && slot != 50 && slot >= 9 && slot < 45 && slot % 9 != 0 && slot % 9 != 8) continue;
            event.setCancelled(true);
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ServerEssentials.getInstance(), () -> SellGUIListener.updateTotalValue(event.getInventory()), 1L);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.RED) + "Sell Items Here")) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.returnUnsoldItems(event.getInventory(), player);
    }

    private double sellItems(Inventory inv, Player player) {
        double total = 0.0;
        for (int i = 0; i < 54; ++i) {
            ItemStack item;
            if (i == 48 || i == 49 || i == 50 || i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8 || (item = inv.getItem(i)) == null || item.getType() == Material.AIR) continue;
            double price = ShopManager.getSellPrice(item.getType());
            if (price > 0.0) {
                total += price * (double)item.getAmount();
            } else {
                player.getInventory().addItem(new ItemStack[]{item.clone()});
            }
            inv.setItem(i, null);
        }
        if (total > 0.0) {
            EconomyManager.addBalance(player.getUniqueId(), total);
        }
        return total;
    }

    private void returnUnsoldItems(Inventory inv, Player player) {
        for (int i = 0; i < 54; ++i) {
            ItemStack item;
            if (i == 48 || i == 49 || i == 50 || i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8 || (item = inv.getItem(i)) == null || item.getType() == Material.AIR) continue;
            player.getInventory().addItem(new ItemStack[]{item.clone()});
            inv.setItem(i, null);
        }
    }

    private static void updateTotalValue(Inventory inv) {
        double total = 0.0;
        for (int i = 0; i < 54; ++i) {
            double price;
            ItemStack item;
            if (i == 48 || i == 49 || i == 50 || i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8 || (item = inv.getItem(i)) == null || item.getType() == Material.AIR || !((price = ShopManager.getSellPrice(item.getType())) > 0.0)) continue;
            total += price * (double)item.getAmount();
        }
        inv.setItem(50, SellGUIListener.createTotalDisplay(total));
    }

    private static ItemStack createTotalDisplay(double value) {
        ItemStack totalDisplay = new ItemStack(Material.REDSTONE_LAMP);
        ItemMeta meta = totalDisplay.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Total Value: $" + String.format("%.2f", value));
            totalDisplay.setItemMeta(meta);
        }
        return totalDisplay;
    }
}

