/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import serveressentials.serveressentials.AdminChatCommand;
import serveressentials.serveressentials.AdminChatListener;
import serveressentials.serveressentials.AdminCommand;
import serveressentials.serveressentials.AdminUtilitiesCommand;
import serveressentials.serveressentials.AdminUtilitiesListener;
import serveressentials.serveressentials.AuctionCommand;
import serveressentials.serveressentials.AuctionListener;
import serveressentials.serveressentials.AuctionManager;
import serveressentials.serveressentials.BackCommand;
import serveressentials.serveressentials.BalanceCommand;
import serveressentials.serveressentials.BalanceTopCommand;
import serveressentials.serveressentials.BanCommand;
import serveressentials.serveressentials.BanListener;
import serveressentials.serveressentials.BanManager;
import serveressentials.serveressentials.BottomCommand;
import serveressentials.serveressentials.BreakCommand;
import serveressentials.serveressentials.BroadcastCommand;
import serveressentials.serveressentials.BurnCommand;
import serveressentials.serveressentials.CelebrateCommand;
import serveressentials.serveressentials.ChatListener;
import serveressentials.serveressentials.CloseWarpCommand;
import serveressentials.serveressentials.CoinFlipCommand;
import serveressentials.serveressentials.CompassCommand;
import serveressentials.serveressentials.DailyRewardGUI;
import serveressentials.serveressentials.DayCommand;
import serveressentials.serveressentials.DeathCommand;
import serveressentials.serveressentials.DeleteHomeCommand;
import serveressentials.serveressentials.DeleteWarpCommand;
import serveressentials.serveressentials.DisposalCommand;
import serveressentials.serveressentials.EcoCommand;
import serveressentials.serveressentials.EconomyManager;
import serveressentials.serveressentials.EnderChestCommand;
import serveressentials.serveressentials.EnderSeeCommand;
import serveressentials.serveressentials.FeedCommand;
import serveressentials.serveressentials.FreezeCommand;
import serveressentials.serveressentials.FreezeListener;
import serveressentials.serveressentials.GravityCommand;
import serveressentials.serveressentials.HatCommand;
import serveressentials.serveressentials.HealCommand;
import serveressentials.serveressentials.HomeCommand;
import serveressentials.serveressentials.HomeGUIListener;
import serveressentials.serveressentials.HomeManager;
import serveressentials.serveressentials.InventoryClickListener;
import serveressentials.serveressentials.JoinLeaveListener;
import serveressentials.serveressentials.JoinLeaveManager;
import serveressentials.serveressentials.JoinListener;
import serveressentials.serveressentials.KickAllCommand;
import serveressentials.serveressentials.KillCommand;
import serveressentials.serveressentials.KillTracker;
import serveressentials.serveressentials.KitCommand;
import serveressentials.serveressentials.KitConfigManager;
import serveressentials.serveressentials.KitGUIListener;
import serveressentials.serveressentials.LaunchCommand;
import serveressentials.serveressentials.LobbyCommand;
import serveressentials.serveressentials.LobbyManager;
import serveressentials.serveressentials.MailCommand;
import serveressentials.serveressentials.MotdCommand;
import serveressentials.serveressentials.MuteCommand;
import serveressentials.serveressentials.NickCommand;
import serveressentials.serveressentials.NightCommand;
import serveressentials.serveressentials.PTimeCommand;
import serveressentials.serveressentials.PayCommand;
import serveressentials.serveressentials.PingCommand;
import serveressentials.serveressentials.PlayTimeCommand;
import serveressentials.serveressentials.PlayerInfoCommand;
import serveressentials.serveressentials.RTPCommand;
import serveressentials.serveressentials.RTPConfig;
import serveressentials.serveressentials.RTPListener;
import serveressentials.serveressentials.RankCommand;
import serveressentials.serveressentials.RankListener;
import serveressentials.serveressentials.RankManager;
import serveressentials.serveressentials.ReOpenWarpCommand;
import serveressentials.serveressentials.RealNameCommand;
import serveressentials.serveressentials.RemoveLobbyCommand;
import serveressentials.serveressentials.RenameHomeCommand;
import serveressentials.serveressentials.RenameItemCommand;
import serveressentials.serveressentials.RenameWarpCommand;
import serveressentials.serveressentials.RepairCommand;
import serveressentials.serveressentials.ReportCommand;
import serveressentials.serveressentials.ReportNotifierListener;
import serveressentials.serveressentials.RulesCommand;
import serveressentials.serveressentials.RulesManager;
import serveressentials.serveressentials.ScoreboardCommand;
import serveressentials.serveressentials.SellGUICommand;
import serveressentials.serveressentials.SellGUIListener;
import serveressentials.serveressentials.ServerEssentialsPlaceholder;
import serveressentials.serveressentials.SetHomeCommand;
import serveressentials.serveressentials.SetLobbyCommand;
import serveressentials.serveressentials.SetLoreLineCommand;
import serveressentials.serveressentials.SetWarpCommand;
import serveressentials.serveressentials.ShopCommand;
import serveressentials.serveressentials.ShopConfigManager;
import serveressentials.serveressentials.ShopGUIListener;
import serveressentials.serveressentials.ShopManager;
import serveressentials.serveressentials.SimpleScoreboard;
import serveressentials.serveressentials.StaffListCommand;
import serveressentials.serveressentials.SuicideCommand;
import serveressentials.serveressentials.TPOfflineCommand;
import serveressentials.serveressentials.TopCommand;
import serveressentials.serveressentials.TpAcceptCommand;
import serveressentials.serveressentials.TpAllCommand;
import serveressentials.serveressentials.TpDenyCommand;
import serveressentials.serveressentials.TpHereCommand;
import serveressentials.serveressentials.TpaCommand;
import serveressentials.serveressentials.TrackCommand;
import serveressentials.serveressentials.UnbanCommand;
import serveressentials.serveressentials.UnfreezeCommand;
import serveressentials.serveressentials.UnmuteCommand;
import serveressentials.serveressentials.VaultCommand;
import serveressentials.serveressentials.VaultManager;
import serveressentials.serveressentials.VersionChecker;
import serveressentials.serveressentials.VersionCommand;
import serveressentials.serveressentials.WarpCommand;
import serveressentials.serveressentials.WarpManager;
import serveressentials.serveressentials.WarpsCommand;
import serveressentials.serveressentials.WeatherCommand;
import serveressentials.serveressentials.WorkbenchCommand;
import serveressentials.serveressentials.WorldCommand;

public class ServerEssentials
extends JavaPlugin
implements Listener {
    private static ServerEssentials instance;
    private final AuctionManager auctionManager = new AuctionManager();
    private static final Map<UUID, Double> balances;
    private Listener DailyRewardGUI;
    private RankManager rankManager;
    private RulesManager rulesManager;
    BanManager banManager = new BanManager(this);
    private SimpleScoreboard simpleScoreboard;
    private SellGUIListener sellGUIListener;

    public void onEnable() {
        instance = this;
        ShopManager.loadShopItems();
        HomeManager.loadHomes();
        LobbyManager.setup();
        LobbyManager.loadLobby();
        WarpManager.setup();
        ShopManager.clearItems();
        ShopConfigManager.loadShopItems();
        ReportCommand reportCommand = new ReportCommand(this);
        JoinLeaveManager.load();
        RTPConfig.load();
        EconomyManager.loadBalances();
        this.simpleScoreboard = new SimpleScoreboard(this);
        KitConfigManager.setup(this);
        KitCommand kitCommand = new KitCommand();
        this.rankManager = new RankManager(this);
        VaultManager vaultManager = new VaultManager(this);
        KillTracker killTracker = new KillTracker(this);
        VersionChecker.checkLatestVersion((Plugin)this);
        Bukkit.getPluginManager().registerEvents(new Listener(this){

            @EventHandler
            public void onJoin(PlayerJoinEvent event) {
                VersionChecker.notifyIfOutdated(event.getPlayer());
            }
        }, (Plugin)this);
        Bukkit.getOnlinePlayers().forEach(SimpleScoreboard::setScoreboard);
        this.sellGUIListener = new SellGUIListener();
        this.getServer().getPluginManager().registerEvents((Listener)this.sellGUIListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RTPListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AdminChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FreezeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new KitGUIListener(kitCommand), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ReportNotifierListener(reportCommand), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RankListener(this.rankManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BanListener(this.banManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinLeaveListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HomeGUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ShopGUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SellGUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AuctionListener(this.auctionManager), (Plugin)this);
        AdminUtilitiesCommand adminUtils = new AdminUtilitiesCommand();
        this.getServer().getPluginManager().registerEvents((Listener)new AdminUtilitiesListener(adminUtils), (Plugin)this);
        DailyRewardGUI dailyRewardCommand = new DailyRewardGUI();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new ServerEssentialsPlaceholder(this).register();
        } else {
            this.getLogger().warning("PlaceholderAPI not found! Placeholders won't work.");
        }
        this.getCommand("serveressentials").setExecutor((CommandExecutor)new VersionCommand());
        this.getCommand("sellgui").setExecutor((CommandExecutor)new SellGUICommand());
        this.getCommand("rtp").setExecutor((CommandExecutor)new RTPCommand());
        this.getCommand("se").setExecutor((CommandExecutor)new AdminCommand());
        this.getCommand("eco").setExecutor((CommandExecutor)new EcoCommand());
        this.getCommand("ban").setExecutor((CommandExecutor)new BanCommand(this.getBanManager()));
        this.getCommand("unban").setExecutor((CommandExecutor)new UnbanCommand(this.getBanManager()));
        this.getCommand("rank").setExecutor((CommandExecutor)new RankCommand(this.rankManager));
        this.getCommand("pv").setExecutor((CommandExecutor)new VaultCommand(vaultManager));
        this.getCommand("kit").setExecutor((CommandExecutor)kitCommand);
        this.getCommand("report").setExecutor((CommandExecutor)reportCommand);
        this.getCommand("kills").setExecutor((CommandExecutor)new KillCommand(killTracker));
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand());
        this.getCommand("balancetop").setExecutor((CommandExecutor)new BalanceTopCommand());
        this.getCommand("shop").setExecutor((CommandExecutor)new ShopCommand());
        this.getCommand("playtime").setExecutor((CommandExecutor)new PlayTimeCommand());
        this.getCommand("vanish").setExecutor((CommandExecutor)adminUtils);
        this.getCommand("god").setExecutor((CommandExecutor)adminUtils);
        this.getCommand("invsee").setExecutor((CommandExecutor)adminUtils);
        this.getCommand("rules").setExecutor((CommandExecutor)new RulesCommand(this.rulesManager));
        this.getCommand("invclear").setExecutor((CommandExecutor)adminUtils);
        this.getCommand("tp").setExecutor((CommandExecutor)adminUtils);
        this.getCommand("tpa").setExecutor((CommandExecutor)new TpaCommand());
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpAcceptCommand());
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TpDenyCommand());
        this.getCommand("tpall").setExecutor((CommandExecutor)new TpAllCommand());
        this.getCommand("tphere").setExecutor((CommandExecutor)new TpHereCommand());
        this.getCommand("ah").setExecutor((CommandExecutor)new AuctionCommand(this.auctionManager));
        this.getCommand("adminchat").setExecutor((CommandExecutor)new AdminChatCommand());
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand());
        this.getCommand("deletehome").setExecutor((CommandExecutor)new DeleteHomeCommand());
        this.getCommand("renamehome").setExecutor((CommandExecutor)new RenameHomeCommand());
        this.getCommand("broadcast").setExecutor((CommandExecutor)new BroadcastCommand());
        this.getCommand("homes").setExecutor((CommandExecutor)new HomeCommand());
        this.getCommand("nick").setExecutor((CommandExecutor)new NickCommand());
        this.getCommand("rename").setExecutor((CommandExecutor)new RenameItemCommand());
        this.getCommand("daily").setExecutor((CommandExecutor)dailyRewardCommand);
        this.getCommand("setloreline").setExecutor((CommandExecutor)new SetLoreLineCommand());
        this.getCommand("ping").setExecutor((CommandExecutor)new PingCommand());
        this.getCommand("setlobby").setExecutor((CommandExecutor)new SetLobbyCommand());
        this.getCommand("lobby").setExecutor((CommandExecutor)new LobbyCommand());
        this.getCommand("removelobby").setExecutor((CommandExecutor)new RemoveLobbyCommand());
        this.getCommand("back").setExecutor((CommandExecutor)new BackCommand());
        this.getCommand("death").setExecutor((CommandExecutor)new DeathCommand());
        this.getCommand("setmotd").setExecutor((CommandExecutor)new MotdCommand(this));
        this.getCommand("heal").setExecutor((CommandExecutor)new HealCommand());
        this.getCommand("feed").setExecutor((CommandExecutor)new FeedCommand());
        this.getCommand("ptime").setExecutor((CommandExecutor)new PTimeCommand());
        this.getCommand("playerinfo").setExecutor((CommandExecutor)new PlayerInfoCommand());
        this.getCommand("launch").setExecutor((CommandExecutor)new LaunchCommand());
        this.getCommand("gravity").setExecutor((CommandExecutor)new GravityCommand());
        this.getCommand("repair").setExecutor((CommandExecutor)new RepairCommand());
        this.getCommand("workbench").setExecutor((CommandExecutor)new WorkbenchCommand());
        this.getCommand("enderchest").setExecutor((CommandExecutor)new EnderChestCommand());
        this.getCommand("endersee").setExecutor((CommandExecutor)new EnderSeeCommand());
        this.getCommand("mute").setExecutor((CommandExecutor)new MuteCommand());
        this.getCommand("unmute").setExecutor((CommandExecutor)new UnmuteCommand());
        this.getCommand("night").setExecutor((CommandExecutor)new NightCommand());
        this.getCommand("day").setExecutor((CommandExecutor)new DayCommand());
        this.getCommand("weather").setExecutor((CommandExecutor)new WeatherCommand());
        this.getCommand("mail").setExecutor((CommandExecutor)new MailCommand());
        this.getCommand("kickall").setExecutor((CommandExecutor)new KickAllCommand());
        this.getCommand("suicide").setExecutor((CommandExecutor)new SuicideCommand());
        this.getCommand("setwarp").setExecutor((CommandExecutor)new SetWarpCommand());
        this.getCommand("warp").setExecutor((CommandExecutor)new WarpCommand());
        this.getCommand("warps").setExecutor((CommandExecutor)new WarpsCommand());
        this.getCommand("renamewarp").setExecutor((CommandExecutor)new RenameWarpCommand());
        this.getCommand("closewarp").setExecutor((CommandExecutor)new CloseWarpCommand());
        this.getCommand("reopenwarp").setExecutor((CommandExecutor)new ReOpenWarpCommand());
        this.getCommand("deletewarp").setExecutor((CommandExecutor)new DeleteWarpCommand());
        this.getCommand("disposal").setExecutor((CommandExecutor)new DisposalCommand());
        this.getCommand("top").setExecutor((CommandExecutor)new TopCommand());
        this.getCommand("bottom").setExecutor((CommandExecutor)new BottomCommand());
        this.getCommand("tpoffline").setExecutor((CommandExecutor)new TPOfflineCommand());
        this.getCommand("hat").setExecutor((CommandExecutor)new HatCommand());
        this.getCommand("realname").setExecutor((CommandExecutor)new RealNameCommand());
        this.getCommand("freeze").setExecutor((CommandExecutor)new FreezeCommand());
        this.getCommand("Unfreeze").setExecutor((CommandExecutor)new UnfreezeCommand());
        this.getCommand("World").setExecutor((CommandExecutor)new WorldCommand());
        this.getCommand("Break").setExecutor((CommandExecutor)new BreakCommand());
        this.getCommand("Compass").setExecutor((CommandExecutor)new CompassCommand());
        this.getCommand("Pay").setExecutor((CommandExecutor)new PayCommand());
        this.getCommand("coinflip").setExecutor((CommandExecutor)new CoinFlipCommand());
        this.getCommand("scoreboard").setExecutor((CommandExecutor)new ScoreboardCommand(this.simpleScoreboard));
        this.getCommand("stafflist").setExecutor((CommandExecutor)new StaffListCommand());
        this.getCommand("track").setExecutor((CommandExecutor)new TrackCommand());
        this.getCommand("burn").setExecutor((CommandExecutor)new BurnCommand());
        this.getCommand("celebrate").setExecutor((CommandExecutor)new CelebrateCommand());
        for (Player online : Bukkit.getOnlinePlayers()) {
            SimpleScoreboard.setScoreboard(online);
        }
        this.getLogger().info("ServerEssentials enabled with full features.");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        SimpleScoreboard.setScoreboard(event.getPlayer());
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (MuteCommand.mutedPlayers.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cYou are muted.");
        }
    }

    public static ServerEssentials getInstance() {
        return instance;
    }

    public SellGUIListener getSellGUIListener() {
        return this.sellGUIListener;
    }

    public BanManager getBanManager() {
        return this.banManager;
    }

    public RankManager getRankManager() {
        return this.rankManager;
    }

    public SimpleScoreboard getScoreboard() {
        return this.simpleScoreboard;
    }

    public void addBalance(UUID uuid, double amount) {
        EconomyManager.addBalance(uuid, amount);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            SimpleScoreboard.setScoreboard(player);
        }
    }

    static {
        balances = new HashMap<UUID, Double>();
    }
}

