/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import serveressentials.serveressentials.EconomyManager;
import serveressentials.serveressentials.Rank;
import serveressentials.serveressentials.RankManager;
import serveressentials.serveressentials.ServerEssentials;

public class ServerEssentialsPlaceholder
extends PlaceholderExpansion {
    private final ServerEssentials plugin;

    public ServerEssentialsPlaceholder(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "serveressentials";
    }

    @NotNull
    public String getAuthor() {
        return ":_GodlyCow";
    }

    @NotNull
    public String getVersion() {
        return "1.6";
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        switch (identifier.toLowerCase()) {
            case "playtime": {
                long ticksPlayed = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
                long secondsPlayed = ticksPlayed / 20L;
                return this.formatTime(secondsPlayed);
            }
            case "isop": {
                return player.isOp() ? "Yes" : "No";
            }
            case "death": {
                return String.valueOf(player.getStatistic(Statistic.DEATHS));
            }
            case "blocks_broken": {
                int broken = 0;
                for (Material material : Material.values()) {
                    try {
                        broken += player.getStatistic(Statistic.MINE_BLOCK, material);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return String.valueOf(broken);
            }
            case "blocks_placed": {
                int placed = 0;
                for (Material material : Material.values()) {
                    try {
                        placed += player.getStatistic(Statistic.USE_ITEM, material);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return String.valueOf(placed);
            }
            case "kills": {
                return String.valueOf(player.getStatistic(Statistic.PLAYER_KILLS));
            }
            case "rank": {
                return this.getPlayerRank(player);
            }
            case "money": {
                double balance = EconomyManager.getBalance((OfflinePlayer)player);
                return String.format("%.2f", balance);
            }
        }
        return "Unknown Placeholder: " + identifier;
    }

    private String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString().trim();
    }

    private String getPlayerRank(Player player) {
        RankManager rankManager = this.plugin.getRankManager();
        Rank rank = rankManager.getRank(player);
        return rank != null ? rank.getPrefix() : "\u00a77Member";
    }
}

