/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import serveressentials.serveressentials.ShopItem;
import serveressentials.serveressentials.ShopManager;

public class ShopConfigManager {
    private static File shopFile;
    private static FileConfiguration shopConfig;

    public static void loadShopItems() {
        shopFile = new File(Bukkit.getServer().getPluginManager().getPlugin("ServerEssentials").getDataFolder(), "shopitems.yml");
        if (!shopFile.exists()) {
            shopFile.getParentFile().mkdirs();
            ShopConfigManager.saveDefaultShopConfig();
        }
        if ((shopConfig = YamlConfiguration.loadConfiguration((File)shopFile)).getConfigurationSection("items") == null) {
            Bukkit.getLogger().warning("[ServerEssentials] No items section found in shopitems.yml!");
            return;
        }
        ShopManager.clearItems();
        for (String key : shopConfig.getConfigurationSection("items").getKeys(false)) {
            String path = "items." + key;
            try {
                Material material = Material.matchMaterial((String)shopConfig.getString(path + ".material"));
                if (material == null) {
                    Bukkit.getLogger().warning("[ServerEssentials] Invalid material for item '" + key + "'!");
                    continue;
                }
                double buyPrice = shopConfig.getDouble(path + ".price");
                double sellPrice = shopConfig.getDouble(path + ".sellPrice");
                int amount = shopConfig.getInt(path + ".amount", 1);
                int slot = shopConfig.getInt(path + ".slot", 0);
                int page = shopConfig.getInt(path + ".page", 1);
                String category = shopConfig.getString(path + ".category", "Misc");
                ItemStack item = new ItemStack(material, amount);
                ShopItem shopItem = new ShopItem(item, buyPrice, sellPrice, slot, category, page);
                ShopManager.addItem(shopItem);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[ServerEssentials] Failed to load shop item '" + key + "': " + e.getMessage());
            }
        }
    }

    /*
     * Opcode count of 19126 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void saveDefaultShopConfig() {
        shopConfig = new YamlConfiguration();
        shopConfig.set("items.book.material", (Object)"BOOK");
        shopConfig.set("items.book.price", (Object)50);
        shopConfig.set("items.book.sellPrice", (Object)10);
        shopConfig.set("items.book.amount", (Object)1);
        shopConfig.set("items.book.slot", (Object)10);
        shopConfig.set("items.book.page", (Object)1);
        shopConfig.set("items.book.category", (Object)"Misc");
        shopConfig.set("items.clock.material", (Object)"CLOCK");
        shopConfig.set("items.clock.price", (Object)45);
        shopConfig.set("items.clock.sellPrice", (Object)22);
        shopConfig.set("items.clock.amount", (Object)1);
        shopConfig.set("items.clock.slot", (Object)12);
        shopConfig.set("items.clock.page", (Object)1);
        shopConfig.set("items.clock.category", (Object)"Misc");
        shopConfig.set("items.nametag.material", (Object)"NAME_TAG");
        shopConfig.set("items.nametag.price", (Object)60);
        shopConfig.set("items.nametag.sellPrice", (Object)30);
        shopConfig.set("items.nametag.amount", (Object)1);
        shopConfig.set("items.nametag.slot", (Object)14);
        shopConfig.set("items.nametag.page", (Object)1);
        shopConfig.set("items.nametag.category", (Object)"Misc");
        shopConfig.set("items.lead.material", (Object)"LEAD");
        shopConfig.set("items.lead.price", (Object)50);
        shopConfig.set("items.lead.sellPrice", (Object)25);
        shopConfig.set("items.lead.amount", (Object)1);
        shopConfig.set("items.lead.slot", (Object)14);
        shopConfig.set("items.lead.page", (Object)1);
        shopConfig.set("items.lead.category", (Object)"Misc");
        shopConfig.set("items.saddle.material", (Object)"SADDLE");
        shopConfig.set("items.saddle.price", (Object)55);
        shopConfig.set("items.saddle.sellPrice", (Object)28);
        shopConfig.set("items.saddle.amount", (Object)1);
        shopConfig.set("items.saddle.slot", (Object)16);
        shopConfig.set("items.saddle.page", (Object)1);
        shopConfig.set("items.saddle.category", (Object)"Misc");
        shopConfig.set("items.bookandquill.material", (Object)"WRITABLE_BOOK");
        shopConfig.set("items.bookandquill.price", (Object)25);
        shopConfig.set("items.bookandquill.sellPrice", (Object)12);
        shopConfig.set("items.bookandquill.amount", (Object)1);
        shopConfig.set("items.bookandquill.slot", (Object)19);
        shopConfig.set("items.bookandquill.page", (Object)1);
        shopConfig.set("items.bookandquill.category", (Object)"Misc");
        shopConfig.set("items.map.material", (Object)"MAP");
        shopConfig.set("items.map.price", (Object)30);
        shopConfig.set("items.map.sellPrice", (Object)15);
        shopConfig.set("items.map.amount", (Object)1);
        shopConfig.set("items.map.slot", (Object)21);
        shopConfig.set("items.map.page", (Object)1);
        shopConfig.set("items.map.category", (Object)"Misc");
        shopConfig.set("items.bundle.material", (Object)"BUNDLE");
        shopConfig.set("items.bundle.price", (Object)35);
        shopConfig.set("items.bundle.sellPrice", (Object)17);
        shopConfig.set("items.bundle.amount", (Object)1);
        shopConfig.set("items.bundle.slot", (Object)23);
        shopConfig.set("items.bundle.page", (Object)1);
        shopConfig.set("items.bundle.category", (Object)"Misc");
        shopConfig.set("items.spyglass.material", (Object)"SPYGLASS");
        shopConfig.set("items.spyglass.price", (Object)60);
        shopConfig.set("items.spyglass.sellPrice", (Object)30);
        shopConfig.set("items.spyglass.amount", (Object)1);
        shopConfig.set("items.spyglass.slot", (Object)25);
        shopConfig.set("items.spyglass.page", (Object)1);
        shopConfig.set("items.spyglass.category", (Object)"Misc");
        shopConfig.set("items.goathorn.material", (Object)"GOAT_HORN");
        shopConfig.set("items.goathorn.price", (Object)100);
        shopConfig.set("items.goathorn.sellPrice", (Object)50);
        shopConfig.set("items.goathorn.amount", (Object)1);
        shopConfig.set("items.goathorn.slot", (Object)28);
        shopConfig.set("items.goathorn.page", (Object)1);
        shopConfig.set("items.goathorn.category", (Object)"Misc");
        shopConfig.set("items.dragonbreath.material", (Object)"DRAGON_BREATH");
        shopConfig.set("items.dragonbreath.price", (Object)80);
        shopConfig.set("items.dragonbreath.sellPrice", (Object)40);
        shopConfig.set("items.dragonbreath.amount", (Object)1);
        shopConfig.set("items.dragonbreath.slot", (Object)30);
        shopConfig.set("items.dragonbreath.page", (Object)1);
        shopConfig.set("items.dragonbreath.category", (Object)"Misc");
        shopConfig.set("items.heartofthesea.material", (Object)"HEART_OF_THE_SEA");
        shopConfig.set("items.heartofthesea.price", (Object)200);
        shopConfig.set("items.heartofthesea.sellPrice", (Object)100);
        shopConfig.set("items.heartofthesea.amount", (Object)1);
        shopConfig.set("items.heartofthesea.slot", (Object)32);
        shopConfig.set("items.heartofthesea.page", (Object)1);
        shopConfig.set("items.heartofthesea.category", (Object)"Misc");
        shopConfig.set("items.nautilushell.material", (Object)"NAUTILUS_SHELL");
        shopConfig.set("items.nautilushell.price", (Object)90);
        shopConfig.set("items.nautilushell.sellPrice", (Object)45);
        shopConfig.set("items.nautilushell.amount", (Object)1);
        shopConfig.set("items.nautilushell.slot", (Object)34);
        shopConfig.set("items.nautilushell.page", (Object)1);
        shopConfig.set("items.nautilushell.category", (Object)"Misc");
        shopConfig.set("items.glassbottle.material", (Object)"GLASS_BOTTLE");
        shopConfig.set("items.glassbottle.price", (Object)5);
        shopConfig.set("items.glassbottle.sellPrice", (Object)2);
        shopConfig.set("items.glassbottle.amount", (Object)1);
        shopConfig.set("items.glassbottle.slot", (Object)10);
        shopConfig.set("items.glassbottle.page", (Object)2);
        shopConfig.set("items.glassbottle.category", (Object)"Misc");
        shopConfig.set("items.honeybottle.material", (Object)"HONEY_BOTTLE");
        shopConfig.set("items.honeybottle.price", (Object)15);
        shopConfig.set("items.honeybottle.sellPrice", (Object)7);
        shopConfig.set("items.honeybottle.amount", (Object)1);
        shopConfig.set("items.honeybottle.slot", (Object)12);
        shopConfig.set("items.honeybottle.page", (Object)2);
        shopConfig.set("items.honeybottle.category", (Object)"Misc");
        shopConfig.set("items.glowinksac.material", (Object)"GLOW_INK_SAC");
        shopConfig.set("items.glowinksac.price", (Object)20);
        shopConfig.set("items.glowinksac.sellPrice", (Object)10);
        shopConfig.set("items.glowinksac.amount", (Object)1);
        shopConfig.set("items.glowinksac.slot", (Object)12);
        shopConfig.set("items.glowinksac.page", (Object)2);
        shopConfig.set("items.glowinksac.category", (Object)"Misc");
        shopConfig.set("items.inksac.material", (Object)"INK_SAC");
        shopConfig.set("items.inksac.price", (Object)10);
        shopConfig.set("items.inksac.sellPrice", (Object)5);
        shopConfig.set("items.inksac.amount", (Object)1);
        shopConfig.set("items.inksac.slot", (Object)14);
        shopConfig.set("items.inksac.page", (Object)2);
        shopConfig.set("items.inksac.category", (Object)"Misc");
        shopConfig.set("items.snowball.material", (Object)"SNOWBALL");
        shopConfig.set("items.snowball.price", (Object)5);
        shopConfig.set("items.snowball.sellPrice", (Object)2);
        shopConfig.set("items.snowball.amount", (Object)1);
        shopConfig.set("items.snowball.slot", (Object)16);
        shopConfig.set("items.snowball.page", (Object)2);
        shopConfig.set("items.snowball.category", (Object)"Misc");
        shopConfig.set("items.egg1.material", (Object)"EGG");
        shopConfig.set("items.egg1.price", (Object)5);
        shopConfig.set("items.egg1.sellPrice", (Object)2);
        shopConfig.set("items.egg1.amount", (Object)1);
        shopConfig.set("items.egg1.slot", (Object)19);
        shopConfig.set("items.egg1.page", (Object)2);
        shopConfig.set("items.egg1.category", (Object)"Misc");
        shopConfig.set("items.slimeball.material", (Object)"SLIME_BALL");
        shopConfig.set("items.slimeball.price", (Object)15);
        shopConfig.set("items.slimeball.sellPrice", (Object)7);
        shopConfig.set("items.slimeball.amount", (Object)1);
        shopConfig.set("items.slimeball.slot", (Object)21);
        shopConfig.set("items.slimeball.page", (Object)2);
        shopConfig.set("items.slimeball.category", (Object)"Misc");
        shopConfig.set("items.rabbitfoot.material", (Object)"RABBIT_FOOT");
        shopConfig.set("items.rabbitfoot.price", (Object)25);
        shopConfig.set("items.rabbitfoot.sellPrice", (Object)12);
        shopConfig.set("items.rabbitfoot.amount", (Object)1);
        shopConfig.set("items.rabbitfoot.slot", (Object)23);
        shopConfig.set("items.rabbitfoot.page", (Object)2);
        shopConfig.set("items.rabbitfoot.category", (Object)"Misc");
        shopConfig.set("items.stonepickaxe.material", (Object)"STONE_PICKAXE");
        shopConfig.set("items.stonepickaxe.price", (Object)50);
        shopConfig.set("items.stonepickaxe.sellPrice", (Object)12);
        shopConfig.set("items.stonepickaxe.amount", (Object)1);
        shopConfig.set("items.stonepickaxe.slot", (Object)10);
        shopConfig.set("items.stonepickaxe.page", (Object)1);
        shopConfig.set("items.stonepickaxe.category", (Object)"Tools");
        shopConfig.set("items.ironpickaxe.material", (Object)"IRON_PICKAXE");
        shopConfig.set("items.ironpickaxe.price", (Object)150);
        shopConfig.set("items.ironpickaxe.sellPrice", (Object)40);
        shopConfig.set("items.ironpickaxe.amount", (Object)1);
        shopConfig.set("items.ironpickaxe.slot", (Object)12);
        shopConfig.set("items.ironpickaxe.page", (Object)1);
        shopConfig.set("items.ironpickaxe.category", (Object)"Tools");
        shopConfig.set("items.diamondpickaxe.material", (Object)"DIAMOND_PICKAXE");
        shopConfig.set("items.diamondpickaxe.price", (Object)800);
        shopConfig.set("items.diamondpickaxe.sellPrice", (Object)250);
        shopConfig.set("items.diamondpickaxe.amount", (Object)1);
        shopConfig.set("items.diamondpickaxe.slot", (Object)14);
        shopConfig.set("items.diamondpickaxe.page", (Object)1);
        shopConfig.set("items.diamondpickaxe.category", (Object)"Tools");
        shopConfig.set("items.netheritepickaxe.material", (Object)"NETHERITE_PICKAXE");
        shopConfig.set("items.netheritepickaxe.price", (Object)3000);
        shopConfig.set("items.netheritepickaxe.sellPrice", (Object)900);
        shopConfig.set("items.netheritepickaxe.amount", (Object)1);
        shopConfig.set("items.netheritepickaxe.slot", (Object)16);
        shopConfig.set("items.netheritepickaxe.page", (Object)1);
        shopConfig.set("items.netheritepickaxe.category", (Object)"Tools");
        shopConfig.set("items.stoneaxe.material", (Object)"STONE_AXE");
        shopConfig.set("items.stoneaxe.price", (Object)50);
        shopConfig.set("items.stoneaxe.sellPrice", (Object)12);
        shopConfig.set("items.stoneaxe.amount", (Object)1);
        shopConfig.set("items.stoneaxe.slot", (Object)19);
        shopConfig.set("items.stoneaxe.page", (Object)1);
        shopConfig.set("items.stoneaxe.category", (Object)"Tools");
        shopConfig.set("items.ironaxe.material", (Object)"IRON_AXE");
        shopConfig.set("items.ironaxe.price", (Object)150);
        shopConfig.set("items.ironaxe.sellPrice", (Object)40);
        shopConfig.set("items.ironaxe.amount", (Object)1);
        shopConfig.set("items.ironaxe.slot", (Object)21);
        shopConfig.set("items.ironaxe.page", (Object)1);
        shopConfig.set("items.ironaxe.category", (Object)"Tools");
        shopConfig.set("items.diamondaxe.material", (Object)"DIAMOND_AXE");
        shopConfig.set("items.diamondaxe.price", (Object)800);
        shopConfig.set("items.diamondaxe.sellPrice", (Object)250);
        shopConfig.set("items.diamondaxe.amount", (Object)1);
        shopConfig.set("items.diamondaxe.slot", (Object)23);
        shopConfig.set("items.diamondaxe.page", (Object)1);
        shopConfig.set("items.diamondaxe.category", (Object)"Tools");
        shopConfig.set("items.netheriteaxe.material", (Object)"NETHERITE_AXE");
        shopConfig.set("items.netheriteaxe.price", (Object)3000);
        shopConfig.set("items.netheriteaxe.sellPrice", (Object)900);
        shopConfig.set("items.netheriteaxe.amount", (Object)1);
        shopConfig.set("items.netheriteaxe.slot", (Object)25);
        shopConfig.set("items.netheriteaxe.page", (Object)1);
        shopConfig.set("items.netheriteaxe.category", (Object)"Tools");
        shopConfig.set("items.stoneshovel.material", (Object)"STONE_SHOVEL");
        shopConfig.set("items.stoneshovel.price", (Object)50);
        shopConfig.set("items.stoneshovel.sellPrice", (Object)8);
        shopConfig.set("items.stoneshovel.amount", (Object)1);
        shopConfig.set("items.stoneshovel.slot", (Object)28);
        shopConfig.set("items.stoneshovel.page", (Object)1);
        shopConfig.set("items.stoneshovel.category", (Object)"Tools");
        shopConfig.set("items.ironshovel.material", (Object)"IRON_SHOVEL");
        shopConfig.set("items.ironshovel.price", (Object)80);
        shopConfig.set("items.ironshovel.sellPrice", (Object)20);
        shopConfig.set("items.ironshovel.amount", (Object)1);
        shopConfig.set("items.ironshovel.slot", (Object)30);
        shopConfig.set("items.ironshovel.page", (Object)1);
        shopConfig.set("items.ironshovel.category", (Object)"Tools");
        shopConfig.set("items.diamondshovel.material", (Object)"DIAMOND_SHOVEL");
        shopConfig.set("items.diamondshovel.price", (Object)400);
        shopConfig.set("items.diamondshovel.sellPrice", (Object)100);
        shopConfig.set("items.diamondshovel.amount", (Object)1);
        shopConfig.set("items.diamondshovel.slot", (Object)32);
        shopConfig.set("items.diamondshovel.page", (Object)1);
        shopConfig.set("items.diamondshovel.category", (Object)"Tools");
        shopConfig.set("items.netheriteshovel.material", (Object)"NETHERITE_SHOVEL");
        shopConfig.set("items.netheriteshovel.price", (Object)3000);
        shopConfig.set("items.netheriteshovel.sellPrice", (Object)400);
        shopConfig.set("items.netheriteshovel.amount", (Object)1);
        shopConfig.set("items.netheriteshovel.slot", (Object)34);
        shopConfig.set("items.netheriteshovel.page", (Object)1);
        shopConfig.set("items.netheriteshovel.category", (Object)"Tools");
        shopConfig.set("items.shears.material", (Object)"SHEARS");
        shopConfig.set("items.shears.price", (Object)60);
        shopConfig.set("items.shears.sellPrice", (Object)15);
        shopConfig.set("items.shears.amount", (Object)1);
        shopConfig.set("items.shears.slot", (Object)10);
        shopConfig.set("items.shears.page", (Object)2);
        shopConfig.set("items.shears.category", (Object)"Tools");
        shopConfig.set("items.flintandsteal.material", (Object)"FLINT_AND_STEEL");
        shopConfig.set("items.flintandsteal.price", (Object)50);
        shopConfig.set("items.flintandsteal.sellPrice", (Object)10);
        shopConfig.set("items.flintandsteal.amount", (Object)1);
        shopConfig.set("items.flintandsteal.slot", (Object)12);
        shopConfig.set("items.flintandsteal.page", (Object)2);
        shopConfig.set("items.flintandsteal.category", (Object)"Tools");
        shopConfig.set("items.fishingrod.material", (Object)"FISHING_ROD");
        shopConfig.set("items.fishingrod.price", (Object)70);
        shopConfig.set("items.fishingrod.sellPrice", (Object)15);
        shopConfig.set("items.fishingrod.amount", (Object)1);
        shopConfig.set("items.fishingrod.slot", (Object)14);
        shopConfig.set("items.fishingrod.page", (Object)2);
        shopConfig.set("items.fishingrod.category", (Object)"Tools");
        shopConfig.set("items.compass.material", (Object)"COMPASS");
        shopConfig.set("items.compass.price", (Object)100);
        shopConfig.set("items.compass.sellPrice", (Object)25);
        shopConfig.set("items.compass.amount", (Object)1);
        shopConfig.set("items.compass.slot", (Object)16);
        shopConfig.set("items.compass.page", (Object)2);
        shopConfig.set("items.compass.category", (Object)"Tools");
        shopConfig.set("items.waterbucket.material", (Object)"WATER_BUCKET");
        shopConfig.set("items.waterbucket.price", (Object)70);
        shopConfig.set("items.waterbucket.sellPrice", (Object)15);
        shopConfig.set("items.waterbucket.amount", (Object)1);
        shopConfig.set("items.waterbucket.slot", (Object)19);
        shopConfig.set("items.waterbucket.page", (Object)2);
        shopConfig.set("items.waterbucket.category", (Object)"Tools");
        shopConfig.set("items.endstone.material", (Object)"END_STONE");
        shopConfig.set("items.endstone.price", (Object)12);
        shopConfig.set("items.endstone.sellPrice", (Object)4);
        shopConfig.set("items.endstone.amount", (Object)1);
        shopConfig.set("items.endstone.slot", (Object)10);
        shopConfig.set("items.endstone.page", (Object)1);
        shopConfig.set("items.endstone.category", (Object)"End");
        shopConfig.set("items.endstonebricks.material", (Object)"END_STONE_BRICKS");
        shopConfig.set("items.endstonebricks.price", (Object)16);
        shopConfig.set("items.endstonebricks.sellPrice", (Object)6);
        shopConfig.set("items.endstonebricks.amount", (Object)1);
        shopConfig.set("items.endstonebricks.slot", (Object)12);
        shopConfig.set("items.endstonebricks.page", (Object)1);
        shopConfig.set("items.endstonebricks.category", (Object)"End");
        shopConfig.set("items.purpurblock.material", (Object)"PURPUR_BLOCK");
        shopConfig.set("items.purpurblock.price", (Object)20);
        shopConfig.set("items.purpurblock.sellPrice", (Object)7);
        shopConfig.set("items.purpurblock.amount", (Object)1);
        shopConfig.set("items.purpurblock.slot", (Object)14);
        shopConfig.set("items.purpurblock.page", (Object)1);
        shopConfig.set("items.purpurblock.category", (Object)"End");
        shopConfig.set("items.purpurpillar.material", (Object)"PURPUR_PILLAR");
        shopConfig.set("items.purpurpillar.price", (Object)24);
        shopConfig.set("items.purpurpillar.sellPrice", (Object)8);
        shopConfig.set("items.purpurpillar.amount", (Object)1);
        shopConfig.set("items.purpurpillar.slot", (Object)16);
        shopConfig.set("items.purpurpillar.page", (Object)1);
        shopConfig.set("items.purpurpillar.category", (Object)"End");
        shopConfig.set("items.purpurslab.material", (Object)"PURPUR_SLAB");
        shopConfig.set("items.purpurslab.price", (Object)6);
        shopConfig.set("items.purpurslab.sellPrice", (Object)2);
        shopConfig.set("items.purpurslab.amount", (Object)1);
        shopConfig.set("items.purpurslab.slot", (Object)19);
        shopConfig.set("items.purpurslab.page", (Object)1);
        shopConfig.set("items.purpurslab.category", (Object)"End");
        shopConfig.set("items.purourstairs.material", (Object)"PURPUR_STAIRS");
        shopConfig.set("items.purourstairs.price", (Object)10);
        shopConfig.set("items.purourstairs.sellPrice", (Object)3);
        shopConfig.set("items.purourstairs.amount", (Object)1);
        shopConfig.set("items.purourstairs.slot", (Object)21);
        shopConfig.set("items.purourstairs.page", (Object)1);
        shopConfig.set("items.purourstairs.category", (Object)"End");
        shopConfig.set("items.chorusflower.material", (Object)"CHORUS_FLOWER");
        shopConfig.set("items.chorusflower.price", (Object)30);
        shopConfig.set("items.chorusflower.sellPrice", (Object)10);
        shopConfig.set("items.chorusflower.amount", (Object)1);
        shopConfig.set("items.chorusflower.slot", (Object)23);
        shopConfig.set("items.chorusflower.page", (Object)1);
        shopConfig.set("items.chorusflower.category", (Object)"End");
        shopConfig.set("items.chorusfruit.material", (Object)"CHORUS_FRUIT");
        shopConfig.set("items.chorusfruit.price", (Object)12);
        shopConfig.set("items.chorusfruit.sellPrice", (Object)4);
        shopConfig.set("items.chorusfruit.amount", (Object)1);
        shopConfig.set("items.chorusfruit.slot", (Object)25);
        shopConfig.set("items.chorusfruit.page", (Object)1);
        shopConfig.set("items.chorusfruit.category", (Object)"End");
        shopConfig.set("items.poppedchorusfruit.material", (Object)"POPPED_CHORUS_FRUIT");
        shopConfig.set("items.poppedchorusfruit.price", (Object)16);
        shopConfig.set("items.poppedchorusfruit.sellPrice", (Object)5);
        shopConfig.set("items.poppedchorusfruit.amount", (Object)1);
        shopConfig.set("items.poppedchorusfruit.slot", (Object)28);
        shopConfig.set("items.poppedchorusfruit.page", (Object)1);
        shopConfig.set("items.poppedchorusfruit.category", (Object)"End");
        shopConfig.set("items.dragonhead.material", (Object)"DRAGON_HEAD");
        shopConfig.set("items.dragonhead.price", (Object)5000);
        shopConfig.set("items.dragonhead.sellPrice", (Object)1500);
        shopConfig.set("items.dragonhead.amount", (Object)1);
        shopConfig.set("items.dragonhead.slot", (Object)30);
        shopConfig.set("items.dragonhead.page", (Object)1);
        shopConfig.set("items.dragonhead.category", (Object)"End");
        shopConfig.set("items.endrod.material", (Object)"END_ROD");
        shopConfig.set("items.endrod.price", (Object)18);
        shopConfig.set("items.endrod.sellPrice", (Object)6);
        shopConfig.set("items.endrod.amount", (Object)1);
        shopConfig.set("items.endrod.slot", (Object)32);
        shopConfig.set("items.endrod.page", (Object)1);
        shopConfig.set("items.endrod.category", (Object)"End");
        shopConfig.set("items.elytra.material", (Object)"ELYTRA");
        shopConfig.set("items.elytra.price", (Object)15000);
        shopConfig.set("items.elytra.sellPrice", (Object)3200);
        shopConfig.set("items.elytra.amount", (Object)1);
        shopConfig.set("items.elytra.slot", (Object)34);
        shopConfig.set("items.elytra.page", (Object)1);
        shopConfig.set("items.elytra.category", (Object)"End");
        shopConfig.set("items.enderpearl.material", (Object)"ENDER_PEARL");
        shopConfig.set("items.enderpearl.price", (Object)8);
        shopConfig.set("items.enderpearl.sellPrice", (Object)2);
        shopConfig.set("items.enderpearl.amount", (Object)1);
        shopConfig.set("items.enderpearl.slot", (Object)10);
        shopConfig.set("items.enderpearl.page", (Object)2);
        shopConfig.set("items.enderpearl.category", (Object)"End");
        shopConfig.set("items.endcrystal.material", (Object)"END_CRYSTAL");
        shopConfig.set("items.endcrystal.price", (Object)1500);
        shopConfig.set("items.endcrystal.sellPrice", (Object)400);
        shopConfig.set("items.endcrystal.amount", (Object)1);
        shopConfig.set("items.endcrystal.slot", (Object)12);
        shopConfig.set("items.endcrystal.page", (Object)2);
        shopConfig.set("items.endcrystal.category", (Object)"End");
        shopConfig.set("items.shulkershell.material", (Object)"SHULKER_SHELL");
        shopConfig.set("items.shulkershell.price", (Object)600);
        shopConfig.set("items.shulkershell.sellPrice", (Object)180);
        shopConfig.set("items.shulkershell.amount", (Object)1);
        shopConfig.set("items.shulkershell.slot", (Object)14);
        shopConfig.set("items.shulkershell.page", (Object)2);
        shopConfig.set("items.shulkershell.category", (Object)"End");
        shopConfig.set("items.shulkerbox.material", (Object)"SHULKER_BOX");
        shopConfig.set("items.shulkerbox.price", (Object)1000);
        shopConfig.set("items.shulkerbox.sellPrice", (Object)250);
        shopConfig.set("items.shulkerbox.amount", (Object)1);
        shopConfig.set("items.shulkerbox.slot", (Object)16);
        shopConfig.set("items.shulkerbox.page", (Object)2);
        shopConfig.set("items.shulkerbox.category", (Object)"End");
        shopConfig.set("items.Coal.material", (Object)"COAL");
        shopConfig.set("items.Coal.price", (Object)8);
        shopConfig.set("items.Coal.sellPrice", (Object)2);
        shopConfig.set("items.Coal.amount", (Object)1);
        shopConfig.set("items.Coal.slot", (Object)10);
        shopConfig.set("items.Coal.page", (Object)1);
        shopConfig.set("items.Coal.category", (Object)"Ores");
        shopConfig.set("items.charcoal.material", (Object)"CHARCOAL");
        shopConfig.set("items.charcoal.price", (Object)8);
        shopConfig.set("items.charcoal.sellPrice", (Object)2);
        shopConfig.set("items.charcoal.amount", (Object)1);
        shopConfig.set("items.charcoal.slot", (Object)12);
        shopConfig.set("items.charcoal.page", (Object)1);
        shopConfig.set("items.charcoal.category", (Object)"Ores");
        shopConfig.set("items.ironingot.material", (Object)"IRON_INGOT");
        shopConfig.set("items.ironingot.price", (Object)20);
        shopConfig.set("items.ironingot.sellPrice", (Object)6);
        shopConfig.set("items.ironingot.amount", (Object)1);
        shopConfig.set("items.ironingot.slot", (Object)14);
        shopConfig.set("items.ironingot.page", (Object)1);
        shopConfig.set("items.ironingot.category", (Object)"Ores");
        shopConfig.set("items.goldingot.material", (Object)"GOLD_INGOT");
        shopConfig.set("items.goldingot.price", (Object)30);
        shopConfig.set("items.goldingot.sellPrice", (Object)10);
        shopConfig.set("items.goldingot.amount", (Object)1);
        shopConfig.set("items.goldingot.slot", (Object)16);
        shopConfig.set("items.goldingot.page", (Object)1);
        shopConfig.set("items.goldingot.category", (Object)"Ores");
        shopConfig.set("items.copperingot.material", (Object)"COPPER_INGOT");
        shopConfig.set("items.copperingot.price", (Object)15);
        shopConfig.set("items.copperingot.sellPrice", (Object)5);
        shopConfig.set("items.copperingot.amount", (Object)1);
        shopConfig.set("items.copperingot.slot", (Object)19);
        shopConfig.set("items.copperingot.page", (Object)1);
        shopConfig.set("items.copperingot.category", (Object)"Ores");
        shopConfig.set("items.scrap.material", (Object)"NETHERITE_SCRAP");
        shopConfig.set("items.scrap.price", (Object)500);
        shopConfig.set("items.scrap.sellPrice", (Object)120);
        shopConfig.set("items.scrap.amount", (Object)1);
        shopConfig.set("items.scrap.slot", (Object)21);
        shopConfig.set("items.scrap.page", (Object)1);
        shopConfig.set("items.scrap.category", (Object)"Ores");
        shopConfig.set("items.Lapislazuli.material", (Object)"LAPIS_LAZULI");
        shopConfig.set("items.Lapislazuli.price", (Object)10);
        shopConfig.set("items.Lapislazuli.sellPrice", (Object)3);
        shopConfig.set("items.Lapislazuli.amount", (Object)1);
        shopConfig.set("items.Lapislazuli.slot", (Object)23);
        shopConfig.set("items.Lapislazuli.page", (Object)1);
        shopConfig.set("items.Lapislazuli.category", (Object)"Ores");
        shopConfig.set("items.emerald.material", (Object)"EMERALD");
        shopConfig.set("items.emerald.price", (Object)60);
        shopConfig.set("items.emerald.sellPrice", (Object)20);
        shopConfig.set("items.emerald.amount", (Object)1);
        shopConfig.set("items.emerald.slot", (Object)25);
        shopConfig.set("items.emerald.page", (Object)1);
        shopConfig.set("items.emerald.category", (Object)"Ores");
        shopConfig.set("items.diamond.material", (Object)"DIAMOND");
        shopConfig.set("items.diamond.price", (Object)150);
        shopConfig.set("items.diamond.sellPrice", (Object)50);
        shopConfig.set("items.diamond.amount", (Object)1);
        shopConfig.set("items.diamond.slot", (Object)28);
        shopConfig.set("items.diamond.page", (Object)1);
        shopConfig.set("items.diamond.category", (Object)"Ores");
        shopConfig.set("items.quartz1.material", (Object)"QUARTZ");
        shopConfig.set("items.quartz1.price", (Object)12);
        shopConfig.set("items.quartz1.sellPrice", (Object)4);
        shopConfig.set("items.quartz1.amount", (Object)1);
        shopConfig.set("items.quartz1.slot", (Object)30);
        shopConfig.set("items.quartz1.page", (Object)1);
        shopConfig.set("items.quartz1.category", (Object)"Ores");
        shopConfig.set("items.amethystshard.material", (Object)"AMETHYST_SHARD");
        shopConfig.set("items.amethystshard.price", (Object)25);
        shopConfig.set("items.amethystshard.sellPrice", (Object)8);
        shopConfig.set("items.amethystshard.amount", (Object)1);
        shopConfig.set("items.amethystshard.slot", (Object)32);
        shopConfig.set("items.amethystshard.page", (Object)1);
        shopConfig.set("items.amethystshard.category", (Object)"Ores");
        shopConfig.set("items.redstone1.material", (Object)"REDSTONE");
        shopConfig.set("items.redstone1.price", (Object)30);
        shopConfig.set("items.redstone1.sellPrice", (Object)9);
        shopConfig.set("items.redstone1.amount", (Object)1);
        shopConfig.set("items.redstone1.slot", (Object)34);
        shopConfig.set("items.redstone1.page", (Object)1);
        shopConfig.set("items.redstone1.category", (Object)"Ores");
        shopConfig.set("items.rottenflesh.material", (Object)"ROTTEN_FLESH");
        shopConfig.set("items.rottenflesh.price", (Object)2);
        shopConfig.set("items.rottenflesh.sellPrice", (Object)0.5);
        shopConfig.set("items.rottenflesh.amount", (Object)1);
        shopConfig.set("items.rottenflesh.slot", (Object)10);
        shopConfig.set("items.rottenflesh.page", (Object)1);
        shopConfig.set("items.rottenflesh.category", (Object)"Mob Drops");
        shopConfig.set("items.bone.material", (Object)"BONE");
        shopConfig.set("items.bone.price", (Object)5);
        shopConfig.set("items.bone.sellPrice", (Object)1.5);
        shopConfig.set("items.bone.amount", (Object)1);
        shopConfig.set("items.bone.slot", (Object)12);
        shopConfig.set("items.bone.page", (Object)1);
        shopConfig.set("items.bone.category", (Object)"Mob Drops");
        shopConfig.set("items.arrow.material", (Object)"ARROW");
        shopConfig.set("items.arrow.price", (Object)4);
        shopConfig.set("items.arrow.sellPrice", (Object)1);
        shopConfig.set("items.arrow.amount", (Object)1);
        shopConfig.set("items.arrow.slot", (Object)14);
        shopConfig.set("items.arrow.page", (Object)1);
        shopConfig.set("items.arrow.category", (Object)"Mob Drops");
        shopConfig.set("items.string.material", (Object)"STRING");
        shopConfig.set("items.string.price", (Object)6);
        shopConfig.set("items.string.sellPrice", (Object)2);
        shopConfig.set("items.string.amount", (Object)1);
        shopConfig.set("items.string.slot", (Object)16);
        shopConfig.set("items.string.page", (Object)1);
        shopConfig.set("items.string.category", (Object)"Mob Drops");
        shopConfig.set("items.spidereye.material", (Object)"SPIDER_EYE");
        shopConfig.set("items.spidereye.price", (Object)8);
        shopConfig.set("items.spidereye.sellPrice", (Object)3);
        shopConfig.set("items.spidereye.amount", (Object)1);
        shopConfig.set("items.spidereye.slot", (Object)19);
        shopConfig.set("items.spidereye.page", (Object)1);
        shopConfig.set("items.spidereye.category", (Object)"Mob Drops");
        shopConfig.set("items.gunpowder.material", (Object)"GUNPOWDER");
        shopConfig.set("items.gunpowder.price", (Object)15);
        shopConfig.set("items.gunpowder.sellPrice", (Object)5);
        shopConfig.set("items.gunpowder.amount", (Object)1);
        shopConfig.set("items.gunpowder.slot", (Object)21);
        shopConfig.set("items.gunpowder.page", (Object)1);
        shopConfig.set("items.gunpowder.category", (Object)"Mob Drops");
        shopConfig.set("items.enderperal1.material", (Object)"ENDER_PEARL");
        shopConfig.set("items.enderperal1.price", (Object)8);
        shopConfig.set("items.enderperal1.sellPrice", (Object)2);
        shopConfig.set("items.enderperal1.amount", (Object)1);
        shopConfig.set("items.enderperal1.slot", (Object)23);
        shopConfig.set("items.enderperal1.page", (Object)1);
        shopConfig.set("items.enderperal1.category", (Object)"Mob Drops");
        shopConfig.set("items.slimeball.material", (Object)"SLIME_BALL");
        shopConfig.set("items.slimeball.price", (Object)25);
        shopConfig.set("items.slimeball.sellPrice", (Object)8);
        shopConfig.set("items.slimeball.amount", (Object)1);
        shopConfig.set("items.slimeball.slot", (Object)23);
        shopConfig.set("items.slimeball.page", (Object)1);
        shopConfig.set("items.slimeball.category", (Object)"Mob Drops");
        shopConfig.set("items.phantommembrane.material", (Object)"PHANTOM_MEMBRANE");
        shopConfig.set("items.phantommembrane.price", (Object)80);
        shopConfig.set("items.phantommembrane.sellPrice", (Object)25);
        shopConfig.set("items.phantommembrane.amount", (Object)1);
        shopConfig.set("items.phantommembrane.slot", (Object)25);
        shopConfig.set("items.phantommembrane.page", (Object)1);
        shopConfig.set("items.phantommembrane.category", (Object)"Mob Drops");
        shopConfig.set("items.blazerod.material", (Object)"BLAZE_ROD");
        shopConfig.set("items.blazerod.price", (Object)50);
        shopConfig.set("items.blazerod.sellPrice", (Object)15);
        shopConfig.set("items.blazerod.amount", (Object)1);
        shopConfig.set("items.blazerod.slot", (Object)28);
        shopConfig.set("items.blazerod.page", (Object)1);
        shopConfig.set("items.blazerod.category", (Object)"Mob Drops");
        shopConfig.set("items.ghasttear.material", (Object)"GHAST_TEAR");
        shopConfig.set("items.ghasttear.price", (Object)150);
        shopConfig.set("items.ghasttear.sellPrice", (Object)50);
        shopConfig.set("items.ghasttear.amount", (Object)1);
        shopConfig.set("items.ghasttear.slot", (Object)30);
        shopConfig.set("items.ghasttear.page", (Object)1);
        shopConfig.set("items.ghasttear.category", (Object)"Mob Drops");
        shopConfig.set("items.magmacream.material", (Object)"MAGMA_CREAM");
        shopConfig.set("items.magmacream.price", (Object)30);
        shopConfig.set("items.magmacream.sellPrice", (Object)9);
        shopConfig.set("items.magmacream.amount", (Object)1);
        shopConfig.set("items.magmacream.slot", (Object)32);
        shopConfig.set("items.magmacream.page", (Object)1);
        shopConfig.set("items.magmacream.category", (Object)"Mob Drops");
        shopConfig.set("items.whiterskeletonskull.material", (Object)"WITHER_SKELETON_SKULL");
        shopConfig.set("items.whiterskeletonskull.price", (Object)1000);
        shopConfig.set("items.whiterskeletonskull.sellPrice", (Object)300);
        shopConfig.set("items.whiterskeletonskull.amount", (Object)1);
        shopConfig.set("items.whiterskeletonskull.slot", (Object)34);
        shopConfig.set("items.whiterskeletonskull.page", (Object)1);
        shopConfig.set("items.whiterskeletonskull.category", (Object)"Mob Drops");
        shopConfig.set("items.shulkershell1.material", (Object)"SHULKER_SHELL");
        shopConfig.set("items.shulkershell1.price", (Object)600);
        shopConfig.set("items.shulkershell1.sellPrice", (Object)180);
        shopConfig.set("items.shulkershell1.amount", (Object)1);
        shopConfig.set("items.shulkershell1.slot", (Object)10);
        shopConfig.set("items.shulkershell1.page", (Object)2);
        shopConfig.set("items.shulkershell1.category", (Object)"Mob Drops");
        shopConfig.set("items.rabbitfoot1.material", (Object)"RABBIT_FOOT");
        shopConfig.set("items.rabbitfoot1.price", (Object)60);
        shopConfig.set("items.rabbitfoot1.sellPrice", (Object)20);
        shopConfig.set("items.rabbitfoot1.amount", (Object)1);
        shopConfig.set("items.rabbitfoot1.slot", (Object)12);
        shopConfig.set("items.rabbitfoot1.page", (Object)2);
        shopConfig.set("items.rabbitfoot1.category", (Object)"Mob Drops");
        shopConfig.set("items.leather.material", (Object)"LEATHER");
        shopConfig.set("items.leather.price", (Object)10);
        shopConfig.set("items.leather.sellPrice", (Object)3);
        shopConfig.set("items.leather.amount", (Object)1);
        shopConfig.set("items.leather.slot", (Object)14);
        shopConfig.set("items.leather.page", (Object)2);
        shopConfig.set("items.leather.category", (Object)"Mob Drops");
        shopConfig.set("items.feather.material", (Object)"FEATHER");
        shopConfig.set("items.feather.price", (Object)5);
        shopConfig.set("items.feather.sellPrice", (Object)1.5);
        shopConfig.set("items.feather.amount", (Object)1);
        shopConfig.set("items.feather.slot", (Object)16);
        shopConfig.set("items.feather.page", (Object)2);
        shopConfig.set("items.feather.category", (Object)"Mob Drops");
        shopConfig.set("items.inksac1.material", (Object)"INK_SAC");
        shopConfig.set("items.inksac1.price", (Object)10);
        shopConfig.set("items.inksac1.sellPrice", (Object)5);
        shopConfig.set("items.inksac1.amount", (Object)1);
        shopConfig.set("items.inksac1.slot", (Object)19);
        shopConfig.set("items.inksac1.page", (Object)2);
        shopConfig.set("items.inksac1.category", (Object)"Mob Drops");
        shopConfig.set("items.glowinksac1.material", (Object)"GLOW_INK_SAC");
        shopConfig.set("items.glowinksac1.price", (Object)20);
        shopConfig.set("items.glowinksac1.sellPrice", (Object)10);
        shopConfig.set("items.glowinksac1.amount", (Object)1);
        shopConfig.set("items.glowinksac1.slot", (Object)21);
        shopConfig.set("items.glowinksac1.page", (Object)2);
        shopConfig.set("items.glowinksac1.category", (Object)"Mob Drops");
        shopConfig.set("items.scute.material", (Object)"TURTLE_SCUTE");
        shopConfig.set("items.scute.price", (Object)200);
        shopConfig.set("items.scute.sellPrice", (Object)60);
        shopConfig.set("items.scute.amount", (Object)1);
        shopConfig.set("items.scute.slot", (Object)23);
        shopConfig.set("items.scute.page", (Object)2);
        shopConfig.set("items.scute.category", (Object)"Mob Drops");
        shopConfig.set("items.honeycomb.material", (Object)"HONEYCOMB");
        shopConfig.set("items.honeycomb.price", (Object)25);
        shopConfig.set("items.honeycomb.sellPrice", (Object)10);
        shopConfig.set("items.honeycomb.amount", (Object)1);
        shopConfig.set("items.honeycomb.slot", (Object)25);
        shopConfig.set("items.honeycomb.page", (Object)2);
        shopConfig.set("items.honeycomb.category", (Object)"Mob Drops");
        shopConfig.set("items.stonesword.material", (Object)"STONE_SWORD");
        shopConfig.set("items.stonesword.price", (Object)15);
        shopConfig.set("items.stonesword.sellPrice", (Object)5);
        shopConfig.set("items.stonesword.amount", (Object)1);
        shopConfig.set("items.stonesword.slot", (Object)10);
        shopConfig.set("items.stonesword.page", (Object)1);
        shopConfig.set("items.stonesword.category", (Object)"Combat");
        shopConfig.set("items.ironsword.material", (Object)"IRON_SWORD");
        shopConfig.set("items.ironsword.price", (Object)140);
        shopConfig.set("items.ironsword.sellPrice", (Object)45);
        shopConfig.set("items.ironsword.amount", (Object)1);
        shopConfig.set("items.ironsword.slot", (Object)12);
        shopConfig.set("items.ironsword.page", (Object)1);
        shopConfig.set("items.ironsword.category", (Object)"Combat");
        shopConfig.set("items.diamondsword.material", (Object)"DIAMOND_SWORD");
        shopConfig.set("items.diamondsword.price", (Object)400);
        shopConfig.set("items.diamondsword.sellPrice", (Object)180);
        shopConfig.set("items.diamondsword.amount", (Object)1);
        shopConfig.set("items.diamondsword.slot", (Object)14);
        shopConfig.set("items.diamondsword.page", (Object)1);
        shopConfig.set("items.diamondsword.category", (Object)"Combat");
        shopConfig.set("items.netheritesword.material", (Object)"NETHERITE_SWORD");
        shopConfig.set("items.netheritesword.price", (Object)2500);
        shopConfig.set("items.netheritesword.sellPrice", (Object)340);
        shopConfig.set("items.netheritesword.amount", (Object)1);
        shopConfig.set("items.netheritesword.slot", (Object)16);
        shopConfig.set("items.netheritesword.page", (Object)1);
        shopConfig.set("items.netheritesword.category", (Object)"Combat");
        shopConfig.set("items.bow.material", (Object)"BOW");
        shopConfig.set("items.bow.price", (Object)150);
        shopConfig.set("items.bow.sellPrice", (Object)30);
        shopConfig.set("items.bow.amount", (Object)1);
        shopConfig.set("items.bow.slot", (Object)19);
        shopConfig.set("items.bow.page", (Object)1);
        shopConfig.set("items.bow.category", (Object)"Combat");
        shopConfig.set("items.crossbow.material", (Object)"CROSSBOW");
        shopConfig.set("items.crossbow.price", (Object)160);
        shopConfig.set("items.crossbow.sellPrice", (Object)40);
        shopConfig.set("items.crossbow.amount", (Object)1);
        shopConfig.set("items.crossbow.slot", (Object)21);
        shopConfig.set("items.crossbow.page", (Object)1);
        shopConfig.set("items.crossbow.category", (Object)"Combat");
        shopConfig.set("items.trident.material", (Object)"TRIDENT");
        shopConfig.set("items.trident.price", (Object)500);
        shopConfig.set("items.trident.sellPrice", (Object)150);
        shopConfig.set("items.trident.amount", (Object)1);
        shopConfig.set("items.trident.slot", (Object)23);
        shopConfig.set("items.trident.page", (Object)1);
        shopConfig.set("items.trident.category", (Object)"Combat");
        shopConfig.set("items.shield.material", (Object)"SHIELD");
        shopConfig.set("items.shield.price", (Object)230);
        shopConfig.set("items.shield.sellPrice", (Object)70);
        shopConfig.set("items.shield.amount", (Object)1);
        shopConfig.set("items.shield.slot", (Object)25);
        shopConfig.set("items.shield.page", (Object)1);
        shopConfig.set("items.shield.category", (Object)"Combat");
        shopConfig.set("items.chainmailboots.material", (Object)"CHAINMAIL_BOOTS");
        shopConfig.set("items.chainmailboots.price", (Object)180);
        shopConfig.set("items.chainmailboots.sellPrice", (Object)45);
        shopConfig.set("items.chainmailboots.amount", (Object)1);
        shopConfig.set("items.chainmailboots.slot", (Object)28);
        shopConfig.set("items.chainmailboots.page", (Object)1);
        shopConfig.set("items.chainmailboots.category", (Object)"Combat");
        shopConfig.set("items.chainmailleggings.material", (Object)"CHAINMAIL_LEGGINGS");
        shopConfig.set("items.chainmailleggings.price", (Object)180);
        shopConfig.set("items.chainmailleggings.sellPrice", (Object)45);
        shopConfig.set("items.chainmailleggings.amount", (Object)1);
        shopConfig.set("items.chainmailleggings.slot", (Object)30);
        shopConfig.set("items.chainmailleggings.page", (Object)1);
        shopConfig.set("items.chainmailleggings.category", (Object)"Combat");
        shopConfig.set("items.chaianmailchestplate.material", (Object)"CHAINMAIL_CHESTPLATE");
        shopConfig.set("items.chaianmailchestplate.price", (Object)180);
        shopConfig.set("items.chaianmailchestplate.sellPrice", (Object)45);
        shopConfig.set("items.chaianmailchestplate.amount", (Object)1);
        shopConfig.set("items.chaianmailchestplate.slot", (Object)32);
        shopConfig.set("items.chaianmailchestplate.page", (Object)1);
        shopConfig.set("items.chaianmailchestplate.category", (Object)"Combat");
        shopConfig.set("items.chainmailhelmet.material", (Object)"CHAINMAIL_HELMET");
        shopConfig.set("items.chainmailhelmet.price", (Object)180);
        shopConfig.set("items.chainmailhelmet.sellPrice", (Object)45);
        shopConfig.set("items.chainmailhelmet.amount", (Object)1);
        shopConfig.set("items.chainmailhelmet.slot", (Object)34);
        shopConfig.set("items.chainmailhelmet.page", (Object)1);
        shopConfig.set("items.chainmailhelmet.category", (Object)"Combat");
        shopConfig.set("items.ironboots.material", (Object)"IRON_BOOTS");
        shopConfig.set("items.ironboots.price", (Object)230);
        shopConfig.set("items.ironboots.sellPrice", (Object)55);
        shopConfig.set("items.ironboots.amount", (Object)1);
        shopConfig.set("items.ironboots.slot", (Object)10);
        shopConfig.set("items.ironboots.page", (Object)2);
        shopConfig.set("items.ironboots.category", (Object)"Combat");
        shopConfig.set("items.ironleggings.material", (Object)"IRON_LEGGINGS");
        shopConfig.set("items.ironleggings.price", (Object)230);
        shopConfig.set("items.ironleggings.sellPrice", (Object)55);
        shopConfig.set("items.ironleggings.amount", (Object)1);
        shopConfig.set("items.ironleggings.slot", (Object)12);
        shopConfig.set("items.ironleggings.page", (Object)2);
        shopConfig.set("items.ironleggings.category", (Object)"Combat");
        shopConfig.set("items.ironchestplate.material", (Object)"IRON_CHESTPLATE");
        shopConfig.set("items.ironchestplate.price", (Object)230);
        shopConfig.set("items.ironchestplate.sellPrice", (Object)55);
        shopConfig.set("items.ironchestplate.amount", (Object)1);
        shopConfig.set("items.ironchestplate.slot", (Object)14);
        shopConfig.set("items.ironchestplate.page", (Object)2);
        shopConfig.set("items.ironchestplate.category", (Object)"Combat");
        shopConfig.set("items.ironhelmet.material", (Object)"IRON_HELMET");
        shopConfig.set("items.ironhelmet.price", (Object)230);
        shopConfig.set("items.ironhelmet.sellPrice", (Object)55);
        shopConfig.set("items.ironhelmet.amount", (Object)1);
        shopConfig.set("items.ironhelmet.slot", (Object)16);
        shopConfig.set("items.ironhelmet.page", (Object)2);
        shopConfig.set("items.ironhelmet.category", (Object)"Combat");
        shopConfig.set("items.diamondboots.material", (Object)"DIAMOND_BOOTS");
        shopConfig.set("items.diamondboots.price", (Object)1750);
        shopConfig.set("items.diamondboots.sellPrice", (Object)460);
        shopConfig.set("items.diamondboots.amount", (Object)1);
        shopConfig.set("items.diamondboots.slot", (Object)19);
        shopConfig.set("items.diamondboots.page", (Object)2);
        shopConfig.set("items.diamondboots.category", (Object)"Combat");
        shopConfig.set("items.diamondleggings.material", (Object)"DIAMOND_LEGGINGS");
        shopConfig.set("items.diamondleggings.price", (Object)1750);
        shopConfig.set("items.diamondleggings.sellPrice", (Object)460);
        shopConfig.set("items.diamondleggings.amount", (Object)1);
        shopConfig.set("items.diamondleggings.slot", (Object)21);
        shopConfig.set("items.diamondleggings.page", (Object)2);
        shopConfig.set("items.diamondleggings.category", (Object)"Combat");
        shopConfig.set("items.diamondchestplate.material", (Object)"DIAMOND_CHESTPLATE");
        shopConfig.set("items.diamondchestplate.price", (Object)1750);
        shopConfig.set("items.diamondchestplate.sellPrice", (Object)460);
        shopConfig.set("items.diamondchestplate.amount", (Object)1);
        shopConfig.set("items.diamondchestplate.slot", (Object)23);
        shopConfig.set("items.diamondchestplate.page", (Object)2);
        shopConfig.set("items.diamondchestplate.category", (Object)"Combat");
        shopConfig.set("items.diamondhelmet.material", (Object)"DIAMOND_HELMET");
        shopConfig.set("items.diamondhelmet.price", (Object)1750);
        shopConfig.set("items.diamondhelmet.sellPrice", (Object)460);
        shopConfig.set("items.diamondhelmet.amount", (Object)1);
        shopConfig.set("items.diamondhelmet.slot", (Object)25);
        shopConfig.set("items.diamondhelmet.page", (Object)2);
        shopConfig.set("items.diamondhelmet.category", (Object)"Combat");
        shopConfig.set("items.netheriteboots.material", (Object)"NETHERITE_BOOTS");
        shopConfig.set("items.netheriteboots.price", (Object)3400);
        shopConfig.set("items.netheriteboots.sellPrice", (Object)1240);
        shopConfig.set("items.netheriteboots.amount", (Object)1);
        shopConfig.set("items.netheriteboots.slot", (Object)28);
        shopConfig.set("items.netheriteboots.page", (Object)2);
        shopConfig.set("items.netheriteboots.category", (Object)"Combat");
        shopConfig.set("items.netheriteleggings.material", (Object)"NETHERITE_LEGGINGS");
        shopConfig.set("items.netheriteleggings.price", (Object)3400);
        shopConfig.set("items.netheriteleggings.sellPrice", (Object)1240);
        shopConfig.set("items.netheriteleggings.amount", (Object)1);
        shopConfig.set("items.netheriteleggings.slot", (Object)30);
        shopConfig.set("items.netheriteleggings.page", (Object)2);
        shopConfig.set("items.netheriteleggings.category", (Object)"Combat");
        shopConfig.set("items.netheritechestplate.material", (Object)"NETHERITE_CHESTPLATE");
        shopConfig.set("items.netheritechestplate.price", (Object)3400);
        shopConfig.set("items.netheritechestplate.sellPrice", (Object)1240);
        shopConfig.set("items.netheritechestplate.amount", (Object)1);
        shopConfig.set("items.netheritechestplate.slot", (Object)32);
        shopConfig.set("items.netheritechestplate.page", (Object)2);
        shopConfig.set("items.netheritechestplate.category", (Object)"Combat");
        shopConfig.set("items.netheritehelmet.material", (Object)"NETHERITE_HELMET");
        shopConfig.set("items.netheritehelmet.price", (Object)3400);
        shopConfig.set("items.netheritehelmet.sellPrice", (Object)1240);
        shopConfig.set("items.netheritehelmet.amount", (Object)1);
        shopConfig.set("items.netheritehelmet.slot", (Object)34);
        shopConfig.set("items.netheritehelmet.page", (Object)2);
        shopConfig.set("items.netheritehelmet.category", (Object)"Combat");
        shopConfig.set("items.arrow1.material", (Object)"ARROW");
        shopConfig.set("items.arrow1.price", (Object)8);
        shopConfig.set("items.arrow1.sellPrice", (Object)2);
        shopConfig.set("items.arrow1.amount", (Object)1);
        shopConfig.set("items.arrow1.slot", (Object)10);
        shopConfig.set("items.arrow1.page", (Object)3);
        shopConfig.set("items.arrow1.category", (Object)"Combat");
        shopConfig.set("items.spectralarrow.material", (Object)"SPECTRAL_ARROW");
        shopConfig.set("items.spectralarrow.price", (Object)15);
        shopConfig.set("items.spectralarrow.sellPrice", (Object)4);
        shopConfig.set("items.spectralarrow.amount", (Object)1);
        shopConfig.set("items.spectralarrow.slot", (Object)12);
        shopConfig.set("items.spectralarrow.page", (Object)3);
        shopConfig.set("items.spectralarrow.category", (Object)"Combat");
        shopConfig.set("items.tnt.material", (Object)"TNT");
        shopConfig.set("items.tnt.price", (Object)40);
        shopConfig.set("items.tnt.sellPrice", (Object)10);
        shopConfig.set("items.tnt.amount", (Object)1);
        shopConfig.set("items.tnt.slot", (Object)14);
        shopConfig.set("items.tnt.page", (Object)3);
        shopConfig.set("items.tnt.category", (Object)"Combat");
        shopConfig.set("items.firecharge1.material", (Object)"FIRE_CHARGE");
        shopConfig.set("items.firecharge1.price", (Object)40);
        shopConfig.set("items.firecharge1.sellPrice", (Object)8);
        shopConfig.set("items.firecharge1.amount", (Object)1);
        shopConfig.set("items.firecharge1.slot", (Object)16);
        shopConfig.set("items.firecharge1.page", (Object)3);
        shopConfig.set("items.firecharge1.category", (Object)"Combat");
        shopConfig.set("items.endcrystal1.material", (Object)"END_CRYSTAL");
        shopConfig.set("items.endcrystal1.price", (Object)130);
        shopConfig.set("items.endcrystal1.sellPrice", (Object)35);
        shopConfig.set("items.endcrystal1.amount", (Object)1);
        shopConfig.set("items.endcrystal1.slot", (Object)19);
        shopConfig.set("items.endcrystal1.page", (Object)3);
        shopConfig.set("items.endcrystal1.category", (Object)"Combat");
        shopConfig.set("items.obsidian.material", (Object)"OBSIDIAN");
        shopConfig.set("items.obsidian.price", (Object)110);
        shopConfig.set("items.obsidian.sellPrice", (Object)25);
        shopConfig.set("items.obsidian.amount", (Object)1);
        shopConfig.set("items.obsidian.slot", (Object)21);
        shopConfig.set("items.obsidian.page", (Object)3);
        shopConfig.set("items.obsidian.category", (Object)"Combat");
        shopConfig.set("items.respawnanchor.material", (Object)"RESPAWN_ANCHOR");
        shopConfig.set("items.respawnanchor.price", (Object)230);
        shopConfig.set("items.respawnanchor.sellPrice", (Object)60);
        shopConfig.set("items.respawnanchor.amount", (Object)1);
        shopConfig.set("items.respawnanchor.slot", (Object)23);
        shopConfig.set("items.respawnanchor.page", (Object)3);
        shopConfig.set("items.respawnanchor.category", (Object)"Combat");
        shopConfig.set("items.glowstone.material", (Object)"GLOWSTONE");
        shopConfig.set("items.glowstone.price", (Object)140);
        shopConfig.set("items.glowstone.sellPrice", (Object)40);
        shopConfig.set("items.glowstone.amount", (Object)1);
        shopConfig.set("items.glowstone.slot", (Object)25);
        shopConfig.set("items.glowstone.page", (Object)3);
        shopConfig.set("items.glowstone.category", (Object)"Combat");
        shopConfig.set("items.whitewool.material", (Object)"WHITE_WOOL");
        shopConfig.set("items.whitewool.price", (Object)20);
        shopConfig.set("items.whitewool.sellPrice", (Object)4);
        shopConfig.set("items.whitewool.amount", (Object)1);
        shopConfig.set("items.whitewool.slot", (Object)10);
        shopConfig.set("items.whitewool.page", (Object)1);
        shopConfig.set("items.whitewool.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraywool.material", (Object)"LIGHT_GRAY_WOOL");
        shopConfig.set("items.lightgraywool.price", (Object)20);
        shopConfig.set("items.lightgraywool.sellPrice", (Object)4);
        shopConfig.set("items.lightgraywool.amount", (Object)1);
        shopConfig.set("items.lightgraywool.slot", (Object)12);
        shopConfig.set("items.lightgraywool.page", (Object)1);
        shopConfig.set("items.lightgraywool.category", (Object)"Colored Blocks");
        shopConfig.set("items.graywool.material", (Object)"GRAY_WOOL");
        shopConfig.set("items.graywool.price", (Object)20);
        shopConfig.set("items.graywool.sellPrice", (Object)4);
        shopConfig.set("items.graywool.amount", (Object)1);
        shopConfig.set("items.graywool.slot", (Object)14);
        shopConfig.set("items.graywool.page", (Object)1);
        shopConfig.set("items.graywool.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackwool.material", (Object)"BLACK_WOOL");
        shopConfig.set("items.blackwool.price", (Object)20);
        shopConfig.set("items.blackwool.sellPrice", (Object)4);
        shopConfig.set("items.blackwool.amount", (Object)1);
        shopConfig.set("items.blackwool.slot", (Object)16);
        shopConfig.set("items.blackwool.page", (Object)1);
        shopConfig.set("items.blackwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownwool.material", (Object)"BROWN_WOOL");
        shopConfig.set("items.brownwool.price", (Object)20);
        shopConfig.set("items.brownwool.sellPrice", (Object)4);
        shopConfig.set("items.brownwool.amount", (Object)1);
        shopConfig.set("items.brownwool.slot", (Object)19);
        shopConfig.set("items.brownwool.page", (Object)1);
        shopConfig.set("items.brownwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.redwool.material", (Object)"RED_WOOL");
        shopConfig.set("items.redwool.price", (Object)20);
        shopConfig.set("items.redwool.sellPrice", (Object)4);
        shopConfig.set("items.redwool.amount", (Object)1);
        shopConfig.set("items.redwool.slot", (Object)21);
        shopConfig.set("items.redwool.page", (Object)1);
        shopConfig.set("items.redwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangewool.material", (Object)"ORANGE_WOOL");
        shopConfig.set("items.orangewool.price", (Object)20);
        shopConfig.set("items.orangewool.sellPrice", (Object)4);
        shopConfig.set("items.orangewool.amount", (Object)1);
        shopConfig.set("items.orangewool.slot", (Object)23);
        shopConfig.set("items.orangewool.page", (Object)1);
        shopConfig.set("items.orangewool.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowwool.material", (Object)"YELLOW_WOOL");
        shopConfig.set("items.yellowwool.price", (Object)20);
        shopConfig.set("items.yellowwool.sellPrice", (Object)4);
        shopConfig.set("items.yellowwool.amount", (Object)1);
        shopConfig.set("items.yellowwool.slot", (Object)25);
        shopConfig.set("items.yellowwool.page", (Object)1);
        shopConfig.set("items.yellowwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.limewool.material", (Object)"LIME_WOOL");
        shopConfig.set("items.limewool.price", (Object)20);
        shopConfig.set("items.limewool.sellPrice", (Object)4);
        shopConfig.set("items.limewool.amount", (Object)1);
        shopConfig.set("items.limewool.slot", (Object)28);
        shopConfig.set("items.limewool.page", (Object)1);
        shopConfig.set("items.limewool.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenwool.material", (Object)"GREEN_WOOL");
        shopConfig.set("items.greenwool.price", (Object)20);
        shopConfig.set("items.greenwool.sellPrice", (Object)4);
        shopConfig.set("items.greenwool.amount", (Object)1);
        shopConfig.set("items.greenwool.slot", (Object)30);
        shopConfig.set("items.greenwool.page", (Object)1);
        shopConfig.set("items.greenwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanwool.material", (Object)"CYAN_WOOL");
        shopConfig.set("items.cyanwool.price", (Object)20);
        shopConfig.set("items.cyanwool.sellPrice", (Object)4);
        shopConfig.set("items.cyanwool.amount", (Object)1);
        shopConfig.set("items.cyanwool.slot", (Object)32);
        shopConfig.set("items.cyanwool.page", (Object)1);
        shopConfig.set("items.cyanwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluewool.material", (Object)"LIGHT_BLUE_WOOL");
        shopConfig.set("items.lightbluewool.price", (Object)20);
        shopConfig.set("items.lightbluewool.sellPrice", (Object)4);
        shopConfig.set("items.lightbluewool.amount", (Object)1);
        shopConfig.set("items.lightbluewool.slot", (Object)34);
        shopConfig.set("items.lightbluewool.page", (Object)1);
        shopConfig.set("items.lightbluewool.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluewool.material", (Object)"BLUE_WOOL");
        shopConfig.set("items.bluewool.price", (Object)20);
        shopConfig.set("items.bluewool.sellPrice", (Object)4);
        shopConfig.set("items.bluewool.amount", (Object)1);
        shopConfig.set("items.bluewool.slot", (Object)10);
        shopConfig.set("items.bluewool.page", (Object)2);
        shopConfig.set("items.bluewool.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplewool.material", (Object)"PURPLE_WOOL");
        shopConfig.set("items.purplewool.price", (Object)20);
        shopConfig.set("items.purplewool.sellPrice", (Object)4);
        shopConfig.set("items.purplewool.amount", (Object)1);
        shopConfig.set("items.purplewool.slot", (Object)12);
        shopConfig.set("items.purplewool.page", (Object)2);
        shopConfig.set("items.purplewool.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentawool.material", (Object)"MAGENTA_WOOL");
        shopConfig.set("items.magentawool.price", (Object)20);
        shopConfig.set("items.magentawool.sellPrice", (Object)4);
        shopConfig.set("items.magentawool.amount", (Object)1);
        shopConfig.set("items.magentawool.slot", (Object)14);
        shopConfig.set("items.magentawool.page", (Object)2);
        shopConfig.set("items.magentawool.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkwool.material", (Object)"PINK_WOOL");
        shopConfig.set("items.pinkwool.price", (Object)20);
        shopConfig.set("items.pinkwool.sellPrice", (Object)4);
        shopConfig.set("items.pinkwool.amount", (Object)1);
        shopConfig.set("items.pinkwool.slot", (Object)16);
        shopConfig.set("items.pinkwool.page", (Object)2);
        shopConfig.set("items.pinkwool.category", (Object)"Colored Blocks");
        shopConfig.set("items.whitecarpet.material", (Object)"WHITE_CARPET");
        shopConfig.set("items.whitecarpet.price", (Object)10);
        shopConfig.set("items.whitecarpet.sellPrice", (Object)2);
        shopConfig.set("items.whitecarpet.amount", (Object)1);
        shopConfig.set("items.whitecarpet.slot", (Object)19);
        shopConfig.set("items.whitecarpet.page", (Object)2);
        shopConfig.set("items.whitecarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraycarpet.material", (Object)"LIGHT_GRAY_CARPET");
        shopConfig.set("items.lightgraycarpet.price", (Object)10);
        shopConfig.set("items.lightgraycarpet.sellPrice", (Object)2);
        shopConfig.set("items.lightgraycarpet.amount", (Object)1);
        shopConfig.set("items.lightgraycarpet.slot", (Object)21);
        shopConfig.set("items.lightgraycarpet.page", (Object)2);
        shopConfig.set("items.lightgraycarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.graycarpet.material", (Object)"GRAY_CARPET");
        shopConfig.set("items.graycarpet.price", (Object)10);
        shopConfig.set("items.graycarpet.sellPrice", (Object)2);
        shopConfig.set("items.graycarpet.amount", (Object)1);
        shopConfig.set("items.graycarpet.slot", (Object)23);
        shopConfig.set("items.graycarpet.page", (Object)2);
        shopConfig.set("items.graycarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackcarpet.material", (Object)"BLACK_CARPET");
        shopConfig.set("items.blackcarpet.price", (Object)10);
        shopConfig.set("items.blackcarpet.sellPrice", (Object)2);
        shopConfig.set("items.blackcarpet.amount", (Object)1);
        shopConfig.set("items.blackcarpet.slot", (Object)25);
        shopConfig.set("items.blackcarpet.page", (Object)2);
        shopConfig.set("items.blackcarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.browncarpet.material", (Object)"BROWN_CARPET");
        shopConfig.set("items.browncarpet.price", (Object)10);
        shopConfig.set("items.browncarpet.sellPrice", (Object)2);
        shopConfig.set("items.browncarpet.amount", (Object)1);
        shopConfig.set("items.browncarpet.slot", (Object)28);
        shopConfig.set("items.browncarpet.page", (Object)2);
        shopConfig.set("items.browncarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.redcarpet.material", (Object)"RED_CARPET");
        shopConfig.set("items.redcarpet.price", (Object)10);
        shopConfig.set("items.redcarpet.sellPrice", (Object)2);
        shopConfig.set("items.redcarpet.amount", (Object)1);
        shopConfig.set("items.redcarpet.slot", (Object)30);
        shopConfig.set("items.redcarpet.page", (Object)2);
        shopConfig.set("items.redcarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangecarpet.material", (Object)"ORANGE_CARPET");
        shopConfig.set("items.orangecarpet.price", (Object)10);
        shopConfig.set("items.orangecarpet.sellPrice", (Object)2);
        shopConfig.set("items.orangecarpet.amount", (Object)1);
        shopConfig.set("items.orangecarpet.slot", (Object)32);
        shopConfig.set("items.orangecarpet.page", (Object)2);
        shopConfig.set("items.orangecarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.limecarpet.material", (Object)"LIME_CARPET");
        shopConfig.set("items.limecarpet.price", (Object)10);
        shopConfig.set("items.limecarpet.sellPrice", (Object)2);
        shopConfig.set("items.limecarpet.amount", (Object)1);
        shopConfig.set("items.limecarpet.slot", (Object)10);
        shopConfig.set("items.limecarpet.page", (Object)3);
        shopConfig.set("items.limecarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.greencarpet.material", (Object)"GREEN_CARPET");
        shopConfig.set("items.greencarpet.price", (Object)10);
        shopConfig.set("items.greencarpet.sellPrice", (Object)2);
        shopConfig.set("items.greencarpet.amount", (Object)1);
        shopConfig.set("items.greencarpet.slot", (Object)12);
        shopConfig.set("items.greencarpet.page", (Object)3);
        shopConfig.set("items.greencarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyancarpet.material", (Object)"CYAN_CARPET");
        shopConfig.set("items.cyancarpet.price", (Object)10);
        shopConfig.set("items.cyancarpet.sellPrice", (Object)2);
        shopConfig.set("items.cyancarpet.amount", (Object)1);
        shopConfig.set("items.cyancarpet.slot", (Object)14);
        shopConfig.set("items.cyancarpet.page", (Object)3);
        shopConfig.set("items.cyancarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluecarpet.material", (Object)"LIGHT_BLUE_CARPET");
        shopConfig.set("items.lightbluecarpet.price", (Object)10);
        shopConfig.set("items.lightbluecarpet.sellPrice", (Object)2);
        shopConfig.set("items.lightbluecarpet.amount", (Object)1);
        shopConfig.set("items.lightbluecarpet.slot", (Object)16);
        shopConfig.set("items.lightbluecarpet.page", (Object)3);
        shopConfig.set("items.lightbluecarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluecarpet.material", (Object)"BLUE_CARPET");
        shopConfig.set("items.bluecarpet.price", (Object)10);
        shopConfig.set("items.bluecarpet.sellPrice", (Object)2);
        shopConfig.set("items.bluecarpet.amount", (Object)1);
        shopConfig.set("items.bluecarpet.slot", (Object)19);
        shopConfig.set("items.bluecarpet.page", (Object)3);
        shopConfig.set("items.bluecarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplecarpet.material", (Object)"PURPLE_CARPET");
        shopConfig.set("items.purplecarpet.price", (Object)10);
        shopConfig.set("items.purplecarpet.sellPrice", (Object)2);
        shopConfig.set("items.purplecarpet.amount", (Object)1);
        shopConfig.set("items.purplecarpet.slot", (Object)21);
        shopConfig.set("items.purplecarpet.page", (Object)3);
        shopConfig.set("items.purplecarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentacarpet.material", (Object)"MAGENTA_CARPET");
        shopConfig.set("items.magentacarpet.price", (Object)10);
        shopConfig.set("items.magentacarpet.sellPrice", (Object)2);
        shopConfig.set("items.magentacarpet.amount", (Object)1);
        shopConfig.set("items.magentacarpet.slot", (Object)23);
        shopConfig.set("items.magentacarpet.page", (Object)3);
        shopConfig.set("items.magentacarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkcarpet.material", (Object)"PINK_CARPET");
        shopConfig.set("items.pinkcarpet.price", (Object)10);
        shopConfig.set("items.pinkcarpet.sellPrice", (Object)2);
        shopConfig.set("items.pinkcarpet.amount", (Object)1);
        shopConfig.set("items.pinkcarpet.slot", (Object)25);
        shopConfig.set("items.pinkcarpet.page", (Object)3);
        shopConfig.set("items.pinkcarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.terracotta.material", (Object)"TERRACOTTA");
        shopConfig.set("items.terracotta.price", (Object)70);
        shopConfig.set("items.terracotta.sellPrice", (Object)15);
        shopConfig.set("items.terracotta.amount", (Object)1);
        shopConfig.set("items.terracotta.slot", (Object)28);
        shopConfig.set("items.terracotta.page", (Object)3);
        shopConfig.set("items.terracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.whiteterracotta.material", (Object)"WHITE_TERRACOTTA");
        shopConfig.set("items.whiteterracotta.price", (Object)70);
        shopConfig.set("items.whiteterracotta.sellPrice", (Object)15);
        shopConfig.set("items.whiteterracotta.amount", (Object)1);
        shopConfig.set("items.whiteterracotta.slot", (Object)30);
        shopConfig.set("items.whiteterracotta.page", (Object)3);
        shopConfig.set("items.whiteterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgrayterracotta.material", (Object)"LIGHT_GRAY_TERRACOTTA");
        shopConfig.set("items.lightgrayterracotta.price", (Object)70);
        shopConfig.set("items.lightgrayterracotta.sellPrice", (Object)15);
        shopConfig.set("items.lightgrayterracotta.amount", (Object)1);
        shopConfig.set("items.lightgrayterracotta.slot", (Object)32);
        shopConfig.set("items.lightgrayterracotta.page", (Object)3);
        shopConfig.set("items.lightgrayterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.grayterracotta.material", (Object)"GRAY_TERRACOTTA");
        shopConfig.set("items.grayterracotta.price", (Object)70);
        shopConfig.set("items.grayterracotta.sellPrice", (Object)15);
        shopConfig.set("items.grayterracotta.amount", (Object)1);
        shopConfig.set("items.grayterracotta.slot", (Object)34);
        shopConfig.set("items.grayterracotta.page", (Object)3);
        shopConfig.set("items.grayterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackterracotta.material", (Object)"BLACK_TERRACOTTA");
        shopConfig.set("items.blackterracotta.price", (Object)70);
        shopConfig.set("items.blackterracotta.sellPrice", (Object)15);
        shopConfig.set("items.blackterracotta.amount", (Object)1);
        shopConfig.set("items.blackterracotta.slot", (Object)10);
        shopConfig.set("items.blackterracotta.page", (Object)4);
        shopConfig.set("items.blackterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownterracotta.material", (Object)"BROWN_TERRACOTTA");
        shopConfig.set("items.brownterracotta.price", (Object)70);
        shopConfig.set("items.brownterracotta.sellPrice", (Object)15);
        shopConfig.set("items.brownterracotta.amount", (Object)1);
        shopConfig.set("items.brownterracotta.slot", (Object)12);
        shopConfig.set("items.brownterracotta.page", (Object)4);
        shopConfig.set("items.brownterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.redterracotta.material", (Object)"RED_TERRACOTTA");
        shopConfig.set("items.redterracotta.price", (Object)70);
        shopConfig.set("items.redterracotta.sellPrice", (Object)15);
        shopConfig.set("items.redterracotta.amount", (Object)1);
        shopConfig.set("items.redterracotta.slot", (Object)14);
        shopConfig.set("items.redterracotta.page", (Object)4);
        shopConfig.set("items.redterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangeterracotta.material", (Object)"ORANGE_TERRACOTTA");
        shopConfig.set("items.orangeterracotta.price", (Object)70);
        shopConfig.set("items.orangeterracotta.sellPrice", (Object)15);
        shopConfig.set("items.orangeterracotta.amount", (Object)1);
        shopConfig.set("items.orangeterracotta.slot", (Object)16);
        shopConfig.set("items.orangeterracotta.page", (Object)4);
        shopConfig.set("items.orangeterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowterracotta.material", (Object)"YELLOW_TERRACOTTA");
        shopConfig.set("items.yellowterracotta.price", (Object)70);
        shopConfig.set("items.yellowterracotta.sellPrice", (Object)15);
        shopConfig.set("items.yellowterracotta.amount", (Object)1);
        shopConfig.set("items.yellowterracotta.slot", (Object)19);
        shopConfig.set("items.yellowterracotta.page", (Object)4);
        shopConfig.set("items.yellowterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.limeterracotta.material", (Object)"LIME_TERRACOTTA");
        shopConfig.set("items.limeterracotta.price", (Object)70);
        shopConfig.set("items.limeterracotta.sellPrice", (Object)15);
        shopConfig.set("items.limeterracotta.amount", (Object)1);
        shopConfig.set("items.limeterracotta.slot", (Object)21);
        shopConfig.set("items.limeterracotta.page", (Object)4);
        shopConfig.set("items.limeterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenterracotta.material", (Object)"GREEN_TERRACOTTA");
        shopConfig.set("items.greenterracotta.price", (Object)70);
        shopConfig.set("items.greenterracotta.sellPrice", (Object)15);
        shopConfig.set("items.greenterracotta.amount", (Object)1);
        shopConfig.set("items.greenterracotta.slot", (Object)23);
        shopConfig.set("items.greenterracotta.page", (Object)4);
        shopConfig.set("items.greenterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanterracotta.material", (Object)"CYAN_TERRACOTTA");
        shopConfig.set("items.cyanterracotta.price", (Object)70);
        shopConfig.set("items.cyanterracotta.sellPrice", (Object)15);
        shopConfig.set("items.cyanterracotta.amount", (Object)1);
        shopConfig.set("items.cyanterracotta.slot", (Object)25);
        shopConfig.set("items.cyanterracotta.page", (Object)4);
        shopConfig.set("items.cyanterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightblueterracotta.material", (Object)"LIGHT_BLUE_TERRACOTTA");
        shopConfig.set("items.lightblueterracotta.price", (Object)70);
        shopConfig.set("items.lightblueterracotta.sellPrice", (Object)15);
        shopConfig.set("items.lightblueterracotta.amount", (Object)1);
        shopConfig.set("items.lightblueterracotta.slot", (Object)28);
        shopConfig.set("items.lightblueterracotta.page", (Object)4);
        shopConfig.set("items.lightblueterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.blueterracotta.material", (Object)"BLUE_TERRACOTTA");
        shopConfig.set("items.blueterracotta.price", (Object)70);
        shopConfig.set("items.blueterracotta.sellPrice", (Object)15);
        shopConfig.set("items.blueterracotta.amount", (Object)1);
        shopConfig.set("items.blueterracotta.slot", (Object)28);
        shopConfig.set("items.blueterracotta.page", (Object)4);
        shopConfig.set("items.blueterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.purpleterracotta.material", (Object)"PURPLE_TERRACOTTA");
        shopConfig.set("items.purpleterracotta.price", (Object)70);
        shopConfig.set("items.purpleterracotta.sellPrice", (Object)15);
        shopConfig.set("items.purpleterracotta.amount", (Object)1);
        shopConfig.set("items.purpleterracotta.slot", (Object)30);
        shopConfig.set("items.purpleterracotta.page", (Object)4);
        shopConfig.set("items.purpleterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentaterracotta.material", (Object)"MAGENTA_TERRACOTTA");
        shopConfig.set("items.magentaterracotta.price", (Object)70);
        shopConfig.set("items.magentaterracotta.sellPrice", (Object)15);
        shopConfig.set("items.magentaterracotta.amount", (Object)1);
        shopConfig.set("items.magentaterracotta.slot", (Object)32);
        shopConfig.set("items.magentaterracotta.page", (Object)4);
        shopConfig.set("items.magentaterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkterracotta.material", (Object)"MAGENTA_TERRACOTTA");
        shopConfig.set("items.pinkterracotta.price", (Object)70);
        shopConfig.set("items.pinkterracotta.sellPrice", (Object)15);
        shopConfig.set("items.pinkterracotta.amount", (Object)1);
        shopConfig.set("items.pinkterracotta.slot", (Object)34);
        shopConfig.set("items.pinkterracotta.page", (Object)4);
        shopConfig.set("items.pinkterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.whiteconcrete.material", (Object)"WHITE_CONCRETE");
        shopConfig.set("items.whiteconcrete.price", (Object)80);
        shopConfig.set("items.whiteconcrete.sellPrice", (Object)25);
        shopConfig.set("items.whiteconcrete.amount", (Object)1);
        shopConfig.set("items.whiteconcrete.slot", (Object)10);
        shopConfig.set("items.whiteconcrete.page", (Object)4);
        shopConfig.set("items.whiteconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgrayconcrete.material", (Object)"LIGHT_GRAY_CONCRETE");
        shopConfig.set("items.lightgrayconcrete.price", (Object)80);
        shopConfig.set("items.lightgrayconcrete.sellPrice", (Object)25);
        shopConfig.set("items.lightgrayconcrete.amount", (Object)1);
        shopConfig.set("items.lightgrayconcrete.slot", (Object)12);
        shopConfig.set("items.lightgrayconcrete.page", (Object)4);
        shopConfig.set("items.lightgrayconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.grayconcrete.material", (Object)"GRAY_CONCRETE");
        shopConfig.set("items.grayconcrete.price", (Object)80);
        shopConfig.set("items.grayconcrete.sellPrice", (Object)25);
        shopConfig.set("items.grayconcrete.amount", (Object)1);
        shopConfig.set("items.grayconcrete.slot", (Object)14);
        shopConfig.set("items.grayconcrete.page", (Object)4);
        shopConfig.set("items.grayconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackconcrete.material", (Object)"BLACK_CONCRETE");
        shopConfig.set("items.blackconcrete.price", (Object)80);
        shopConfig.set("items.blackconcrete.sellPrice", (Object)25);
        shopConfig.set("items.blackconcrete.amount", (Object)1);
        shopConfig.set("items.blackconcrete.slot", (Object)16);
        shopConfig.set("items.blackconcrete.page", (Object)4);
        shopConfig.set("items.blackconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.bronwconcrete.material", (Object)"BROWN_CONCRETE");
        shopConfig.set("items.bronwconcrete.price", (Object)80);
        shopConfig.set("items.bronwconcrete.sellPrice", (Object)25);
        shopConfig.set("items.bronwconcrete.amount", (Object)1);
        shopConfig.set("items.bronwconcrete.slot", (Object)19);
        shopConfig.set("items.bronwconcrete.page", (Object)4);
        shopConfig.set("items.bronwconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.redconcrete.material", (Object)"RED_CONCRETE");
        shopConfig.set("items.redconcrete.price", (Object)80);
        shopConfig.set("items.redconcrete.sellPrice", (Object)25);
        shopConfig.set("items.redconcrete.amount", (Object)1);
        shopConfig.set("items.redconcrete.slot", (Object)21);
        shopConfig.set("items.redconcrete.page", (Object)4);
        shopConfig.set("items.redconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangeconcrete.material", (Object)"ORANGE_CONCRETE");
        shopConfig.set("items.orangeconcrete.price", (Object)80);
        shopConfig.set("items.orangeconcrete.sellPrice", (Object)25);
        shopConfig.set("items.orangeconcrete.amount", (Object)1);
        shopConfig.set("items.orangeconcrete.slot", (Object)23);
        shopConfig.set("items.orangeconcrete.page", (Object)4);
        shopConfig.set("items.orangeconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowcarpet.material", (Object)"YELLOW_CONCRETE");
        shopConfig.set("items.yellowcarpet.price", (Object)80);
        shopConfig.set("items.yellowcarpet.sellPrice", (Object)25);
        shopConfig.set("items.yellowcarpet.amount", (Object)1);
        shopConfig.set("items.yellowcarpet.slot", (Object)25);
        shopConfig.set("items.yellowcarpet.page", (Object)4);
        shopConfig.set("items.yellowcarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.limeconcrete.material", (Object)"LIME_CONCRETE");
        shopConfig.set("items.limeconcrete.price", (Object)80);
        shopConfig.set("items.limeconcrete.sellPrice", (Object)25);
        shopConfig.set("items.limeconcrete.amount", (Object)1);
        shopConfig.set("items.limeconcrete.slot", (Object)28);
        shopConfig.set("items.limeconcrete.page", (Object)4);
        shopConfig.set("items.limeconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenconcrete.material", (Object)"GREEN_CONCRETE");
        shopConfig.set("items.greenconcrete.price", (Object)80);
        shopConfig.set("items.greenconcrete.sellPrice", (Object)25);
        shopConfig.set("items.greenconcrete.amount", (Object)1);
        shopConfig.set("items.greenconcrete.slot", (Object)30);
        shopConfig.set("items.greenconcrete.page", (Object)4);
        shopConfig.set("items.greenconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanconcrete.material", (Object)"CYAN_CONCRETE");
        shopConfig.set("items.cyanconcrete.price", (Object)80);
        shopConfig.set("items.cyanconcrete.sellPrice", (Object)25);
        shopConfig.set("items.cyanconcrete.amount", (Object)1);
        shopConfig.set("items.cyanconcrete.slot", (Object)32);
        shopConfig.set("items.cyanconcrete.page", (Object)4);
        shopConfig.set("items.cyanconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightblueconcrete.material", (Object)"LIGHT_BLUE_CONCRETE");
        shopConfig.set("items.lightblueconcrete.price", (Object)80);
        shopConfig.set("items.lightblueconcrete.sellPrice", (Object)25);
        shopConfig.set("items.lightblueconcrete.amount", (Object)1);
        shopConfig.set("items.lightblueconcrete.slot", (Object)34);
        shopConfig.set("items.lightblueconcrete.page", (Object)4);
        shopConfig.set("items.lightblueconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.blueconcrete.material", (Object)"BLUE_CONCRETE");
        shopConfig.set("items.blueconcrete.price", (Object)80);
        shopConfig.set("items.blueconcrete.sellPrice", (Object)25);
        shopConfig.set("items.blueconcrete.amount", (Object)1);
        shopConfig.set("items.blueconcrete.slot", (Object)10);
        shopConfig.set("items.blueconcrete.page", (Object)5);
        shopConfig.set("items.blueconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.purpleconcrete.material", (Object)"PURPLE_CONCRETE");
        shopConfig.set("items.purpleconcrete.price", (Object)80);
        shopConfig.set("items.purpleconcrete.sellPrice", (Object)25);
        shopConfig.set("items.purpleconcrete.amount", (Object)1);
        shopConfig.set("items.purpleconcrete.slot", (Object)12);
        shopConfig.set("items.purpleconcrete.page", (Object)5);
        shopConfig.set("items.purpleconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentaconcrete.material", (Object)"MAGENTA_CONCRETE");
        shopConfig.set("items.magentaconcrete.price", (Object)80);
        shopConfig.set("items.magentaconcrete.sellPrice", (Object)25);
        shopConfig.set("items.magentaconcrete.amount", (Object)1);
        shopConfig.set("items.magentaconcrete.slot", (Object)14);
        shopConfig.set("items.magentaconcrete.page", (Object)5);
        shopConfig.set("items.magentaconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkconcrete.material", (Object)"PINK_CONCRETE");
        shopConfig.set("items.pinkconcrete.price", (Object)80);
        shopConfig.set("items.pinkconcrete.sellPrice", (Object)25);
        shopConfig.set("items.pinkconcrete.amount", (Object)1);
        shopConfig.set("items.pinkconcrete.slot", (Object)16);
        shopConfig.set("items.pinkconcrete.page", (Object)5);
        shopConfig.set("items.pinkconcrete.category", (Object)"Colored Blocks");
        shopConfig.set("items.whiteconcretepowder.material", (Object)"WHITE_CONCRETE_POWDER");
        shopConfig.set("items.whiteconcretepowder.price", (Object)75);
        shopConfig.set("items.whiteconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.whiteconcretepowder.amount", (Object)1);
        shopConfig.set("items.whiteconcretepowder.slot", (Object)19);
        shopConfig.set("items.whiteconcretepowder.page", (Object)5);
        shopConfig.set("items.whiteconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgrayconcretepowder.material", (Object)"LIGHT_GRAY_CONCRETE_POWDER");
        shopConfig.set("items.lightgrayconcretepowder.price", (Object)75);
        shopConfig.set("items.lightgrayconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.lightgrayconcretepowder.amount", (Object)1);
        shopConfig.set("items.lightgrayconcretepowder.slot", (Object)21);
        shopConfig.set("items.lightgrayconcretepowder.page", (Object)5);
        shopConfig.set("items.lightgrayconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.grayconcretepowder.material", (Object)"GRAY_CONCRETE_POWDER");
        shopConfig.set("items.grayconcretepowder.price", (Object)75);
        shopConfig.set("items.grayconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.grayconcretepowder.amount", (Object)1);
        shopConfig.set("items.grayconcretepowder.slot", (Object)23);
        shopConfig.set("items.grayconcretepowder.page", (Object)5);
        shopConfig.set("items.grayconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackconcretepowder.material", (Object)"BLACK_CONCRETE_POWDER");
        shopConfig.set("items.blackconcretepowder.price", (Object)75);
        shopConfig.set("items.blackconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.blackconcretepowder.amount", (Object)1);
        shopConfig.set("items.blackconcretepowder.slot", (Object)25);
        shopConfig.set("items.blackconcretepowder.page", (Object)5);
        shopConfig.set("items.blackconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownconcretepowder.material", (Object)"BROWN_CONCRETE_POWDER");
        shopConfig.set("items.brownconcretepowder.price", (Object)75);
        shopConfig.set("items.brownconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.brownconcretepowder.amount", (Object)1);
        shopConfig.set("items.brownconcretepowder.slot", (Object)28);
        shopConfig.set("items.brownconcretepowder.page", (Object)5);
        shopConfig.set("items.brownconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.redconcretepowder.material", (Object)"RED_CONCRETE_POWDER");
        shopConfig.set("items.redconcretepowder.price", (Object)75);
        shopConfig.set("items.redconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.redconcretepowder.amount", (Object)1);
        shopConfig.set("items.redconcretepowder.slot", (Object)30);
        shopConfig.set("items.redconcretepowder.page", (Object)5);
        shopConfig.set("items.redconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangeconcretepowder.material", (Object)"ORANGE_CONCRETE_POWDER");
        shopConfig.set("items.orangeconcretepowder.price", (Object)75);
        shopConfig.set("items.orangeconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.orangeconcretepowder.amount", (Object)1);
        shopConfig.set("items.orangeconcretepowder.slot", (Object)32);
        shopConfig.set("items.orangeconcretepowder.page", (Object)5);
        shopConfig.set("items.orangeconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowconcretepowder.material", (Object)"YELLOW_CONCRETE_POWDER");
        shopConfig.set("items.yellowconcretepowder.price", (Object)75);
        shopConfig.set("items.yellowconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.yellowconcretepowder.amount", (Object)1);
        shopConfig.set("items.yellowconcretepowder.slot", (Object)34);
        shopConfig.set("items.yellowconcretepowder.page", (Object)5);
        shopConfig.set("items.yellowconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.limeconcretepowder.material", (Object)"LIME_CONCRETE_POWDER");
        shopConfig.set("items.limeconcretepowder.price", (Object)75);
        shopConfig.set("items.limeconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.limeconcretepowder.amount", (Object)1);
        shopConfig.set("items.limeconcretepowder.slot", (Object)10);
        shopConfig.set("items.limeconcretepowder.page", (Object)6);
        shopConfig.set("items.limeconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenconcretepowder.material", (Object)"GREEN_CONCRETE_POWDER");
        shopConfig.set("items.greenconcretepowder.price", (Object)75);
        shopConfig.set("items.greenconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.greenconcretepowder.amount", (Object)1);
        shopConfig.set("items.greenconcretepowder.slot", (Object)12);
        shopConfig.set("items.greenconcretepowder.page", (Object)6);
        shopConfig.set("items.greenconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanconcretepowder.material", (Object)"CYAN_CONCRETE_POWDER");
        shopConfig.set("items.cyanconcretepowder.price", (Object)75);
        shopConfig.set("items.cyanconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.cyanconcretepowder.amount", (Object)1);
        shopConfig.set("items.cyanconcretepowder.slot", (Object)14);
        shopConfig.set("items.cyanconcretepowder.page", (Object)6);
        shopConfig.set("items.cyanconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightblueconcretepowder.material", (Object)"LIGHT_BLUE_CONCRETE_POWDER");
        shopConfig.set("items.lightblueconcretepowder.price", (Object)75);
        shopConfig.set("items.lightblueconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.lightblueconcretepowder.amount", (Object)1);
        shopConfig.set("items.lightblueconcretepowder.slot", (Object)16);
        shopConfig.set("items.lightblueconcretepowder.page", (Object)6);
        shopConfig.set("items.lightblueconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.blueconcretepowder.material", (Object)"BLUE_CONCRETE_POWDER");
        shopConfig.set("items.blueconcretepowder.price", (Object)75);
        shopConfig.set("items.blueconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.blueconcretepowder.amount", (Object)1);
        shopConfig.set("items.blueconcretepowder.slot", (Object)19);
        shopConfig.set("items.blueconcretepowder.page", (Object)6);
        shopConfig.set("items.blueconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.purpleconcretepowder.material", (Object)"PURPLE_CONCRETE_POWDER");
        shopConfig.set("items.purpleconcretepowder.price", (Object)75);
        shopConfig.set("items.purpleconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.purpleconcretepowder.amount", (Object)1);
        shopConfig.set("items.purpleconcretepowder.slot", (Object)21);
        shopConfig.set("items.purpleconcretepowder.page", (Object)6);
        shopConfig.set("items.purpleconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.maagentaconcretepowder.material", (Object)"MAGENTA_CONCRETE_POWDER");
        shopConfig.set("items.maagentaconcretepowder.price", (Object)75);
        shopConfig.set("items.maagentaconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.maagentaconcretepowder.amount", (Object)1);
        shopConfig.set("items.maagentaconcretepowder.slot", (Object)23);
        shopConfig.set("items.maagentaconcretepowder.page", (Object)6);
        shopConfig.set("items.maagentaconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkconcretepowder.material", (Object)"PINK_CONCRETE_POWDER");
        shopConfig.set("items.pinkconcretepowder.price", (Object)75);
        shopConfig.set("items.pinkconcretepowder.sellPrice", (Object)20);
        shopConfig.set("items.pinkconcretepowder.amount", (Object)1);
        shopConfig.set("items.pinkconcretepowder.slot", (Object)25);
        shopConfig.set("items.pinkconcretepowder.page", (Object)6);
        shopConfig.set("items.pinkconcretepowder.category", (Object)"Colored Blocks");
        shopConfig.set("items.whiteglazedterracotta.material", (Object)"WHITE_GLAZED_TERRACOTTA");
        shopConfig.set("items.whiteglazedterracotta.price", (Object)60);
        shopConfig.set("items.whiteglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.whiteglazedterracotta.amount", (Object)1);
        shopConfig.set("items.whiteglazedterracotta.slot", (Object)28);
        shopConfig.set("items.whiteglazedterracotta.page", (Object)6);
        shopConfig.set("items.whiteglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgrayglazesterracotta.material", (Object)"LIGHT_GRAY_GLAZED_TERRACOTTA");
        shopConfig.set("items.lightgrayglazesterracotta.price", (Object)60);
        shopConfig.set("items.lightgrayglazesterracotta.sellPrice", (Object)15);
        shopConfig.set("items.lightgrayglazesterracotta.amount", (Object)1);
        shopConfig.set("items.lightgrayglazesterracotta.slot", (Object)30);
        shopConfig.set("items.lightgrayglazesterracotta.page", (Object)6);
        shopConfig.set("items.lightgrayglazesterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.grayglazedterracotta.material", (Object)"GRAY_GLAZED_TERRACOTTA");
        shopConfig.set("items.grayglazedterracotta.price", (Object)60);
        shopConfig.set("items.grayglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.grayglazedterracotta.amount", (Object)1);
        shopConfig.set("items.grayglazedterracotta.slot", (Object)32);
        shopConfig.set("items.grayglazedterracotta.page", (Object)6);
        shopConfig.set("items.grayglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackglazzedterracotta.material", (Object)"BLACK_GLAZED_TERRACOTTA");
        shopConfig.set("items.blackglazzedterracotta.price", (Object)60);
        shopConfig.set("items.blackglazzedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.blackglazzedterracotta.amount", (Object)1);
        shopConfig.set("items.blackglazzedterracotta.slot", (Object)34);
        shopConfig.set("items.blackglazzedterracotta.page", (Object)6);
        shopConfig.set("items.blackglazzedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownglazedterracotta.material", (Object)"BROWN_GLAZED_TERRACOTTA");
        shopConfig.set("items.brownglazedterracotta.price", (Object)60);
        shopConfig.set("items.brownglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.brownglazedterracotta.amount", (Object)1);
        shopConfig.set("items.brownglazedterracotta.slot", (Object)10);
        shopConfig.set("items.brownglazedterracotta.page", (Object)7);
        shopConfig.set("items.brownglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.redglazedterracotta.material", (Object)"RED_GLAZED_TERRACOTTA");
        shopConfig.set("items.redglazedterracotta.price", (Object)60);
        shopConfig.set("items.redglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.redglazedterracotta.amount", (Object)1);
        shopConfig.set("items.redglazedterracotta.slot", (Object)12);
        shopConfig.set("items.redglazedterracotta.page", (Object)7);
        shopConfig.set("items.redglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangeglazedterracotta.material", (Object)"ORANGE_GLAZED_TERRACOTTA");
        shopConfig.set("items.orangeglazedterracotta.price", (Object)60);
        shopConfig.set("items.orangeglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.orangeglazedterracotta.amount", (Object)1);
        shopConfig.set("items.orangeglazedterracotta.slot", (Object)14);
        shopConfig.set("items.orangeglazedterracotta.page", (Object)7);
        shopConfig.set("items.orangeglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowglazedterracotta.material", (Object)"YELLOW_GLAZED_TERRACOTTA");
        shopConfig.set("items.yellowglazedterracotta.price", (Object)60);
        shopConfig.set("items.yellowglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.yellowglazedterracotta.amount", (Object)1);
        shopConfig.set("items.yellowglazedterracotta.slot", (Object)16);
        shopConfig.set("items.yellowglazedterracotta.page", (Object)7);
        shopConfig.set("items.yellowglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.limeglazedterracotta.material", (Object)"LIME_GLAZED_TERRACOTTA");
        shopConfig.set("items.limeglazedterracotta.price", (Object)60);
        shopConfig.set("items.limeglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.limeglazedterracotta.amount", (Object)1);
        shopConfig.set("items.limeglazedterracotta.slot", (Object)19);
        shopConfig.set("items.limeglazedterracotta.page", (Object)7);
        shopConfig.set("items.limeglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenglazedterracotta.material", (Object)"GREEN_GLAZED_TERRACOTTA");
        shopConfig.set("items.greenglazedterracotta.price", (Object)60);
        shopConfig.set("items.greenglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.greenglazedterracotta.amount", (Object)1);
        shopConfig.set("items.greenglazedterracotta.slot", (Object)21);
        shopConfig.set("items.greenglazedterracotta.page", (Object)7);
        shopConfig.set("items.greenglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanglazedterracotta.material", (Object)"CYAN_GLAZED_TERRACOTTA");
        shopConfig.set("items.cyanglazedterracotta.price", (Object)60);
        shopConfig.set("items.cyanglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.cyanglazedterracotta.amount", (Object)1);
        shopConfig.set("items.cyanglazedterracotta.slot", (Object)23);
        shopConfig.set("items.cyanglazedterracotta.page", (Object)7);
        shopConfig.set("items.cyanglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightblueglazedterracotta.material", (Object)"LIGHT_BLUE_GLAZED_TERRACOTTA");
        shopConfig.set("items.lightblueglazedterracotta.price", (Object)60);
        shopConfig.set("items.lightblueglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.lightblueglazedterracotta.amount", (Object)1);
        shopConfig.set("items.lightblueglazedterracotta.slot", (Object)25);
        shopConfig.set("items.lightblueglazedterracotta.page", (Object)7);
        shopConfig.set("items.lightblueglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.blueglazedterracotta.material", (Object)"BLUE_GLAZED_TERRACOTTA");
        shopConfig.set("items.blueglazedterracotta.price", (Object)60);
        shopConfig.set("items.blueglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.blueglazedterracotta.amount", (Object)1);
        shopConfig.set("items.blueglazedterracotta.slot", (Object)28);
        shopConfig.set("items.blueglazedterracotta.page", (Object)7);
        shopConfig.set("items.blueglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.purpleglazedterracotta.material", (Object)"PURPLE_GLAZED_TERRACOTTA");
        shopConfig.set("items.purpleglazedterracotta.price", (Object)60);
        shopConfig.set("items.purpleglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.purpleglazedterracotta.amount", (Object)1);
        shopConfig.set("items.purpleglazedterracotta.slot", (Object)30);
        shopConfig.set("items.purpleglazedterracotta.page", (Object)7);
        shopConfig.set("items.purpleglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.megentaglazedterracotta.material", (Object)"MAGENTA_GLAZED_TERRACOTTA");
        shopConfig.set("items.megentaglazedterracotta.price", (Object)60);
        shopConfig.set("items.megentaglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.megentaglazedterracotta.amount", (Object)1);
        shopConfig.set("items.megentaglazedterracotta.slot", (Object)32);
        shopConfig.set("items.megentaglazedterracotta.page", (Object)7);
        shopConfig.set("items.megentaglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkglazedterracotta.material", (Object)"PINK_GLAZED_TERRACOTTA");
        shopConfig.set("items.pinkglazedterracotta.price", (Object)60);
        shopConfig.set("items.pinkglazedterracotta.sellPrice", (Object)15);
        shopConfig.set("items.pinkglazedterracotta.amount", (Object)1);
        shopConfig.set("items.pinkglazedterracotta.slot", (Object)34);
        shopConfig.set("items.pinkglazedterracotta.page", (Object)7);
        shopConfig.set("items.pinkglazedterracotta.category", (Object)"Colored Blocks");
        shopConfig.set("items.whitestainedglass.material", (Object)"WHITE_STAINED_GLASS");
        shopConfig.set("items.whitestainedglass.price", (Object)30);
        shopConfig.set("items.whitestainedglass.sellPrice", (Object)10);
        shopConfig.set("items.whitestainedglass.amount", (Object)1);
        shopConfig.set("items.whitestainedglass.slot", (Object)10);
        shopConfig.set("items.whitestainedglass.page", (Object)8);
        shopConfig.set("items.whitestainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraystainedglass.material", (Object)"LIGHT_GRAY_STAINED_GLASS");
        shopConfig.set("items.lightgraystainedglass.price", (Object)30);
        shopConfig.set("items.lightgraystainedglass.sellPrice", (Object)10);
        shopConfig.set("items.lightgraystainedglass.amount", (Object)1);
        shopConfig.set("items.lightgraystainedglass.slot", (Object)12);
        shopConfig.set("items.lightgraystainedglass.page", (Object)8);
        shopConfig.set("items.lightgraystainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.graystainedglass.material", (Object)"GRAY_STAINED_GLASS");
        shopConfig.set("items.graystainedglass.price", (Object)30);
        shopConfig.set("items.graystainedglass.sellPrice", (Object)10);
        shopConfig.set("items.graystainedglass.amount", (Object)1);
        shopConfig.set("items.graystainedglass.slot", (Object)14);
        shopConfig.set("items.graystainedglass.page", (Object)8);
        shopConfig.set("items.graystainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackstainedglass.material", (Object)"BLACK_STAINED_GLASS");
        shopConfig.set("items.blackstainedglass.price", (Object)30);
        shopConfig.set("items.blackstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.blackstainedglass.amount", (Object)1);
        shopConfig.set("items.blackstainedglass.slot", (Object)16);
        shopConfig.set("items.blackstainedglass.page", (Object)8);
        shopConfig.set("items.blackstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownstainedglass.material", (Object)"BROWN_STAINED_GLASS");
        shopConfig.set("items.brownstainedglass.price", (Object)30);
        shopConfig.set("items.brownstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.brownstainedglass.amount", (Object)1);
        shopConfig.set("items.brownstainedglass.slot", (Object)19);
        shopConfig.set("items.brownstainedglass.page", (Object)8);
        shopConfig.set("items.brownstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.redstainedglass.material", (Object)"RED_STAINED_GLASS");
        shopConfig.set("items.redstainedglass.price", (Object)30);
        shopConfig.set("items.redstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.redstainedglass.amount", (Object)1);
        shopConfig.set("items.redstainedglass.slot", (Object)21);
        shopConfig.set("items.redstainedglass.page", (Object)8);
        shopConfig.set("items.redstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangestainedglass.material", (Object)"ORANGE_STAINED_GLASS");
        shopConfig.set("items.orangestainedglass.price", (Object)30);
        shopConfig.set("items.orangestainedglass.sellPrice", (Object)10);
        shopConfig.set("items.orangestainedglass.amount", (Object)1);
        shopConfig.set("items.orangestainedglass.slot", (Object)23);
        shopConfig.set("items.orangestainedglass.page", (Object)8);
        shopConfig.set("items.orangestainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowstainedglass.material", (Object)"YELLOW_STAINED_GLASS");
        shopConfig.set("items.yellowstainedglass.price", (Object)30);
        shopConfig.set("items.yellowstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.yellowstainedglass.amount", (Object)1);
        shopConfig.set("items.yellowstainedglass.slot", (Object)25);
        shopConfig.set("items.yellowstainedglass.page", (Object)8);
        shopConfig.set("items.yellowstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.limestainedglass.material", (Object)"LIME_STAINED_GLASS");
        shopConfig.set("items.limestainedglass.price", (Object)30);
        shopConfig.set("items.limestainedglass.sellPrice", (Object)10);
        shopConfig.set("items.limestainedglass.amount", (Object)1);
        shopConfig.set("items.limestainedglass.slot", (Object)28);
        shopConfig.set("items.limestainedglass.page", (Object)8);
        shopConfig.set("items.limestainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenstainedglass.material", (Object)"GREEN_STAINED_GLASS");
        shopConfig.set("items.greenstainedglass.price", (Object)30);
        shopConfig.set("items.greenstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.greenstainedglass.amount", (Object)1);
        shopConfig.set("items.greenstainedglass.slot", (Object)30);
        shopConfig.set("items.greenstainedglass.page", (Object)8);
        shopConfig.set("items.greenstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanstainedglass.material", (Object)"CYAN_STAINED_GLASS");
        shopConfig.set("items.cyanstainedglass.price", (Object)30);
        shopConfig.set("items.cyanstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.cyanstainedglass.amount", (Object)1);
        shopConfig.set("items.cyanstainedglass.slot", (Object)32);
        shopConfig.set("items.cyanstainedglass.page", (Object)8);
        shopConfig.set("items.cyanstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluestainedglass.material", (Object)"LIGHT_BLUE_STAINED_GLASS");
        shopConfig.set("items.lightbluestainedglass.price", (Object)30);
        shopConfig.set("items.lightbluestainedglass.sellPrice", (Object)10);
        shopConfig.set("items.lightbluestainedglass.amount", (Object)1);
        shopConfig.set("items.lightbluestainedglass.slot", (Object)34);
        shopConfig.set("items.lightbluestainedglass.page", (Object)8);
        shopConfig.set("items.lightbluestainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluestainedglass.material", (Object)"BLUE_STAINED_GLASS");
        shopConfig.set("items.bluestainedglass.price", (Object)30);
        shopConfig.set("items.bluestainedglass.sellPrice", (Object)10);
        shopConfig.set("items.bluestainedglass.amount", (Object)1);
        shopConfig.set("items.bluestainedglass.slot", (Object)10);
        shopConfig.set("items.bluestainedglass.page", (Object)9);
        shopConfig.set("items.bluestainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplestainedglass.material", (Object)"PURPLE_STAINED_GLASS");
        shopConfig.set("items.purplestainedglass.price", (Object)30);
        shopConfig.set("items.purplestainedglass.sellPrice", (Object)10);
        shopConfig.set("items.purplestainedglass.amount", (Object)1);
        shopConfig.set("items.purplestainedglass.slot", (Object)12);
        shopConfig.set("items.purplestainedglass.page", (Object)9);
        shopConfig.set("items.purplestainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentastainedglass.material", (Object)"MAGENTA_STAINED_GLASS");
        shopConfig.set("items.magentastainedglass.price", (Object)30);
        shopConfig.set("items.magentastainedglass.sellPrice", (Object)10);
        shopConfig.set("items.magentastainedglass.amount", (Object)1);
        shopConfig.set("items.magentastainedglass.slot", (Object)14);
        shopConfig.set("items.magentastainedglass.page", (Object)9);
        shopConfig.set("items.magentastainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkstainedglass.material", (Object)"PINK_STAINED_GLASS");
        shopConfig.set("items.pinkstainedglass.price", (Object)30);
        shopConfig.set("items.pinkstainedglass.sellPrice", (Object)10);
        shopConfig.set("items.pinkstainedglass.amount", (Object)1);
        shopConfig.set("items.pinkstainedglass.slot", (Object)16);
        shopConfig.set("items.pinkstainedglass.page", (Object)9);
        shopConfig.set("items.pinkstainedglass.category", (Object)"Colored Blocks");
        shopConfig.set("items.whitestainedglasspane.material", (Object)"WHITE_STAINED_GLASS_PANE");
        shopConfig.set("items.whitestainedglasspane.price", (Object)20);
        shopConfig.set("items.whitestainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.whitestainedglasspane.amount", (Object)1);
        shopConfig.set("items.whitestainedglasspane.slot", (Object)19);
        shopConfig.set("items.whitestainedglasspane.page", (Object)9);
        shopConfig.set("items.whitestainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraystainedglasspane.material", (Object)"LIGHT_GRAY_STAINED_GLASS_PANE");
        shopConfig.set("items.lightgraystainedglasspane.price", (Object)20);
        shopConfig.set("items.lightgraystainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.lightgraystainedglasspane.amount", (Object)1);
        shopConfig.set("items.lightgraystainedglasspane.slot", (Object)21);
        shopConfig.set("items.lightgraystainedglasspane.page", (Object)9);
        shopConfig.set("items.lightgraystainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.graystainedglasspane.material", (Object)"GRAY_STAINED_GLASS_PANE");
        shopConfig.set("items.graystainedglasspane.price", (Object)20);
        shopConfig.set("items.graystainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.graystainedglasspane.amount", (Object)1);
        shopConfig.set("items.graystainedglasspane.slot", (Object)23);
        shopConfig.set("items.graystainedglasspane.page", (Object)9);
        shopConfig.set("items.graystainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackstainedglasspane.material", (Object)"BLACK_STAINED_GLASS_PANE");
        shopConfig.set("items.blackstainedglasspane.price", (Object)20);
        shopConfig.set("items.blackstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.blackstainedglasspane.amount", (Object)1);
        shopConfig.set("items.blackstainedglasspane.slot", (Object)25);
        shopConfig.set("items.blackstainedglasspane.page", (Object)9);
        shopConfig.set("items.blackstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownstainedglasspane.material", (Object)"BROWN_STAINED_GLASS_PANE");
        shopConfig.set("items.brownstainedglasspane.price", (Object)20);
        shopConfig.set("items.brownstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.brownstainedglasspane.amount", (Object)1);
        shopConfig.set("items.brownstainedglasspane.slot", (Object)28);
        shopConfig.set("items.brownstainedglasspane.page", (Object)9);
        shopConfig.set("items.brownstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.redstainedglasspane.material", (Object)"RED_STAINED_GLASS_PANE");
        shopConfig.set("items.redstainedglasspane.price", (Object)20);
        shopConfig.set("items.redstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.redstainedglasspane.amount", (Object)1);
        shopConfig.set("items.redstainedglasspane.slot", (Object)30);
        shopConfig.set("items.redstainedglasspane.page", (Object)9);
        shopConfig.set("items.redstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangestainedglasspane.material", (Object)"ORANGE_STAINED_GLASS_PANE");
        shopConfig.set("items.orangestainedglasspane.price", (Object)20);
        shopConfig.set("items.orangestainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.orangestainedglasspane.amount", (Object)1);
        shopConfig.set("items.orangestainedglasspane.slot", (Object)32);
        shopConfig.set("items.orangestainedglasspane.page", (Object)9);
        shopConfig.set("items.orangestainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowstainedglasspane.material", (Object)"YELLOW_STAINED_GLASS_PANE");
        shopConfig.set("items.yellowstainedglasspane.price", (Object)20);
        shopConfig.set("items.yellowstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.yellowstainedglasspane.amount", (Object)1);
        shopConfig.set("items.yellowstainedglasspane.slot", (Object)34);
        shopConfig.set("items.yellowstainedglasspane.page", (Object)9);
        shopConfig.set("items.yellowstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.limestainedglasspane.material", (Object)"LIME_STAINED_GLASS_PANE");
        shopConfig.set("items.limestainedglasspane.price", (Object)20);
        shopConfig.set("items.limestainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.limestainedglasspane.amount", (Object)1);
        shopConfig.set("items.limestainedglasspane.slot", (Object)10);
        shopConfig.set("items.limestainedglasspane.page", (Object)10);
        shopConfig.set("items.limestainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenstainedglasspane.material", (Object)"GREEN_STAINED_GLASS_PANE");
        shopConfig.set("items.greenstainedglasspane.price", (Object)20);
        shopConfig.set("items.greenstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.greenstainedglasspane.amount", (Object)1);
        shopConfig.set("items.greenstainedglasspane.slot", (Object)12);
        shopConfig.set("items.greenstainedglasspane.page", (Object)10);
        shopConfig.set("items.greenstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanstainedglasspane.material", (Object)"CYAN_STAINED_GLASS_PANE");
        shopConfig.set("items.cyanstainedglasspane.price", (Object)20);
        shopConfig.set("items.cyanstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.cyanstainedglasspane.amount", (Object)1);
        shopConfig.set("items.cyanstainedglasspane.slot", (Object)14);
        shopConfig.set("items.cyanstainedglasspane.page", (Object)10);
        shopConfig.set("items.cyanstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluestainedglasspane.material", (Object)"LIGHT_BLUE_STAINED_GLASS_PANE");
        shopConfig.set("items.lightbluestainedglasspane.price", (Object)20);
        shopConfig.set("items.lightbluestainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.lightbluestainedglasspane.amount", (Object)1);
        shopConfig.set("items.lightbluestainedglasspane.slot", (Object)16);
        shopConfig.set("items.lightbluestainedglasspane.page", (Object)10);
        shopConfig.set("items.lightbluestainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluetainedglasspane.material", (Object)"BLUE_STAINED_GLASS_PANE");
        shopConfig.set("items.bluetainedglasspane.price", (Object)20);
        shopConfig.set("items.bluetainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.bluetainedglasspane.amount", (Object)1);
        shopConfig.set("items.bluetainedglasspane.slot", (Object)19);
        shopConfig.set("items.bluetainedglasspane.page", (Object)10);
        shopConfig.set("items.bluetainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplestaainedglasspane.material", (Object)"PURPLE_STAINED_GLASS_PANE");
        shopConfig.set("items.purplestaainedglasspane.price", (Object)20);
        shopConfig.set("items.purplestaainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.purplestaainedglasspane.amount", (Object)1);
        shopConfig.set("items.purplestaainedglasspane.slot", (Object)21);
        shopConfig.set("items.purplestaainedglasspane.page", (Object)10);
        shopConfig.set("items.purplestaainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentastainedglasspane.material", (Object)"MAGENTA_STAINED_GLASS_PANE");
        shopConfig.set("items.magentastainedglasspane.price", (Object)20);
        shopConfig.set("items.magentastainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.magentastainedglasspane.amount", (Object)1);
        shopConfig.set("items.magentastainedglasspane.slot", (Object)23);
        shopConfig.set("items.magentastainedglasspane.page", (Object)10);
        shopConfig.set("items.magentastainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkstainedglasspane.material", (Object)"PINK_STAINED_GLASS_PANE");
        shopConfig.set("items.pinkstainedglasspane.price", (Object)20);
        shopConfig.set("items.pinkstainedglasspane.sellPrice", (Object)5);
        shopConfig.set("items.pinkstainedglasspane.amount", (Object)1);
        shopConfig.set("items.pinkstainedglasspane.slot", (Object)25);
        shopConfig.set("items.pinkstainedglasspane.page", (Object)10);
        shopConfig.set("items.pinkstainedglasspane.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowcarpet.material", (Object)"YELLOW_CARPET");
        shopConfig.set("items.yellowcarpet.price", (Object)10);
        shopConfig.set("items.yellowcarpet.sellPrice", (Object)2);
        shopConfig.set("items.yellowcarpet.amount", (Object)1);
        shopConfig.set("items.yellowcarpet.slot", (Object)34);
        shopConfig.set("items.yellowcarpet.page", (Object)2);
        shopConfig.set("items.yellowcarpet.category", (Object)"Colored Blocks");
        shopConfig.set("items.whitebed.material", (Object)"WHITE_BED");
        shopConfig.set("items.whitebed.price", (Object)110);
        shopConfig.set("items.whitebed.sellPrice", (Object)35);
        shopConfig.set("items.whitebed.amount", (Object)1);
        shopConfig.set("items.whitebed.slot", (Object)28);
        shopConfig.set("items.whitebed.page", (Object)10);
        shopConfig.set("items.whitebed.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraybed.material", (Object)"LIGHT_GRAY_BED");
        shopConfig.set("items.lightgraybed.price", (Object)110);
        shopConfig.set("items.lightgraybed.sellPrice", (Object)35);
        shopConfig.set("items.lightgraybed.amount", (Object)1);
        shopConfig.set("items.lightgraybed.slot", (Object)30);
        shopConfig.set("items.lightgraybed.page", (Object)10);
        shopConfig.set("items.lightgraybed.category", (Object)"Colored Blocks");
        shopConfig.set("items.graybed.material", (Object)"GRAY_BED");
        shopConfig.set("items.graybed.price", (Object)110);
        shopConfig.set("items.graybed.sellPrice", (Object)35);
        shopConfig.set("items.graybed.amount", (Object)1);
        shopConfig.set("items.graybed.slot", (Object)32);
        shopConfig.set("items.graybed.page", (Object)10);
        shopConfig.set("items.graybed.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackbed.material", (Object)"BLACK_BED");
        shopConfig.set("items.blackbed.price", (Object)110);
        shopConfig.set("items.blackbed.sellPrice", (Object)35);
        shopConfig.set("items.blackbed.amount", (Object)1);
        shopConfig.set("items.blackbed.slot", (Object)34);
        shopConfig.set("items.blackbed.page", (Object)10);
        shopConfig.set("items.blackbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownbed.material", (Object)"BROWN_BED");
        shopConfig.set("items.brownbed.price", (Object)110);
        shopConfig.set("items.brownbed.sellPrice", (Object)35);
        shopConfig.set("items.brownbed.amount", (Object)1);
        shopConfig.set("items.brownbed.slot", (Object)10);
        shopConfig.set("items.brownbed.page", (Object)11);
        shopConfig.set("items.brownbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.redbed.material", (Object)"RED_BED");
        shopConfig.set("items.redbed.price", (Object)110);
        shopConfig.set("items.redbed.sellPrice", (Object)35);
        shopConfig.set("items.redbed.amount", (Object)1);
        shopConfig.set("items.redbed.slot", (Object)12);
        shopConfig.set("items.redbed.page", (Object)11);
        shopConfig.set("items.redbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.ornagebed.material", (Object)"ORANGE_BED");
        shopConfig.set("items.ornagebed.price", (Object)110);
        shopConfig.set("items.ornagebed.sellPrice", (Object)35);
        shopConfig.set("items.ornagebed.amount", (Object)1);
        shopConfig.set("items.ornagebed.slot", (Object)14);
        shopConfig.set("items.ornagebed.page", (Object)11);
        shopConfig.set("items.ornagebed.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowbed.material", (Object)"YELLOW_BED");
        shopConfig.set("items.yellowbed.price", (Object)110);
        shopConfig.set("items.yellowbed.sellPrice", (Object)35);
        shopConfig.set("items.yellowbed.amount", (Object)1);
        shopConfig.set("items.yellowbed.slot", (Object)16);
        shopConfig.set("items.yellowbed.page", (Object)11);
        shopConfig.set("items.yellowbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.limebed.material", (Object)"LIME_BED");
        shopConfig.set("items.limebed.price", (Object)110);
        shopConfig.set("items.limebed.sellPrice", (Object)35);
        shopConfig.set("items.limebed.amount", (Object)1);
        shopConfig.set("items.limebed.slot", (Object)19);
        shopConfig.set("items.limebed.page", (Object)11);
        shopConfig.set("items.limebed.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenbed.material", (Object)"GREEN_BED");
        shopConfig.set("items.greenbed.price", (Object)110);
        shopConfig.set("items.greenbed.sellPrice", (Object)35);
        shopConfig.set("items.greenbed.amount", (Object)1);
        shopConfig.set("items.greenbed.slot", (Object)21);
        shopConfig.set("items.greenbed.page", (Object)11);
        shopConfig.set("items.greenbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanbed.material", (Object)"CYAN_BED");
        shopConfig.set("items.cyanbed.price", (Object)110);
        shopConfig.set("items.cyanbed.sellPrice", (Object)35);
        shopConfig.set("items.cyanbed.amount", (Object)1);
        shopConfig.set("items.cyanbed.slot", (Object)23);
        shopConfig.set("items.cyanbed.page", (Object)11);
        shopConfig.set("items.cyanbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluebed.material", (Object)"LIGHT_BLUE_BED");
        shopConfig.set("items.lightbluebed.price", (Object)110);
        shopConfig.set("items.lightbluebed.sellPrice", (Object)35);
        shopConfig.set("items.lightbluebed.amount", (Object)1);
        shopConfig.set("items.lightbluebed.slot", (Object)25);
        shopConfig.set("items.lightbluebed.page", (Object)11);
        shopConfig.set("items.lightbluebed.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluebed.material", (Object)"BLUE_BED");
        shopConfig.set("items.bluebed.price", (Object)110);
        shopConfig.set("items.bluebed.sellPrice", (Object)35);
        shopConfig.set("items.bluebed.amount", (Object)1);
        shopConfig.set("items.bluebed.slot", (Object)28);
        shopConfig.set("items.bluebed.page", (Object)11);
        shopConfig.set("items.bluebed.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplebed.material", (Object)"PURPLE_BED");
        shopConfig.set("items.purplebed.price", (Object)110);
        shopConfig.set("items.purplebed.sellPrice", (Object)35);
        shopConfig.set("items.purplebed.amount", (Object)1);
        shopConfig.set("items.purplebed.slot", (Object)30);
        shopConfig.set("items.purplebed.page", (Object)11);
        shopConfig.set("items.purplebed.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentabed.material", (Object)"MAGENTA_BED");
        shopConfig.set("items.magentabed.price", (Object)110);
        shopConfig.set("items.magentabed.sellPrice", (Object)35);
        shopConfig.set("items.magentabed.amount", (Object)1);
        shopConfig.set("items.magentabed.slot", (Object)32);
        shopConfig.set("items.magentabed.page", (Object)11);
        shopConfig.set("items.magentabed.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkbed.material", (Object)"PINK_BED");
        shopConfig.set("items.pinkbed.price", (Object)110);
        shopConfig.set("items.pinkbed.sellPrice", (Object)35);
        shopConfig.set("items.pinkbed.amount", (Object)1);
        shopConfig.set("items.pinkbed.slot", (Object)34);
        shopConfig.set("items.pinkbed.page", (Object)11);
        shopConfig.set("items.pinkbed.category", (Object)"Colored Blocks");
        shopConfig.set("items.whitecandle.material", (Object)"WHITE_CANDLE");
        shopConfig.set("items.whitecandle.price", (Object)110);
        shopConfig.set("items.whitecandle.sellPrice", (Object)35);
        shopConfig.set("items.whitecandle.amount", (Object)1);
        shopConfig.set("items.whitecandle.slot", (Object)10);
        shopConfig.set("items.whitecandle.page", (Object)12);
        shopConfig.set("items.whitecandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraycandle.material", (Object)"LIGHT_GRAY_CANDLE");
        shopConfig.set("items.lightgraycandle.price", (Object)110);
        shopConfig.set("items.lightgraycandle.sellPrice", (Object)35);
        shopConfig.set("items.lightgraycandle.amount", (Object)1);
        shopConfig.set("items.lightgraycandle.slot", (Object)12);
        shopConfig.set("items.lightgraycandle.page", (Object)12);
        shopConfig.set("items.lightgraycandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.graycandle.material", (Object)"GRAY_CANDLE");
        shopConfig.set("items.graycandle.price", (Object)110);
        shopConfig.set("items.graycandle.sellPrice", (Object)35);
        shopConfig.set("items.graycandle.amount", (Object)1);
        shopConfig.set("items.graycandle.slot", (Object)14);
        shopConfig.set("items.graycandle.page", (Object)12);
        shopConfig.set("items.graycandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackcandle.material", (Object)"BLACK_CANDLE");
        shopConfig.set("items.blackcandle.price", (Object)110);
        shopConfig.set("items.blackcandle.sellPrice", (Object)35);
        shopConfig.set("items.blackcandle.amount", (Object)1);
        shopConfig.set("items.blackcandle.slot", (Object)16);
        shopConfig.set("items.blackcandle.page", (Object)12);
        shopConfig.set("items.blackcandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.browncandle.material", (Object)"BROWN_CANDLE");
        shopConfig.set("items.browncandle.price", (Object)110);
        shopConfig.set("items.browncandle.sellPrice", (Object)35);
        shopConfig.set("items.browncandle.amount", (Object)1);
        shopConfig.set("items.browncandle.slot", (Object)19);
        shopConfig.set("items.browncandle.page", (Object)12);
        shopConfig.set("items.browncandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.redcandle.material", (Object)"RED_CANDLE");
        shopConfig.set("items.redcandle.price", (Object)110);
        shopConfig.set("items.redcandle.sellPrice", (Object)35);
        shopConfig.set("items.redcandle.amount", (Object)1);
        shopConfig.set("items.redcandle.slot", (Object)21);
        shopConfig.set("items.redcandle.page", (Object)12);
        shopConfig.set("items.redcandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.orangecandle.material", (Object)"ORANGE_CANDLE");
        shopConfig.set("items.orangecandle.price", (Object)110);
        shopConfig.set("items.orangecandle.sellPrice", (Object)35);
        shopConfig.set("items.orangecandle.amount", (Object)1);
        shopConfig.set("items.orangecandle.slot", (Object)23);
        shopConfig.set("items.orangecandle.page", (Object)12);
        shopConfig.set("items.orangecandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowcandle.material", (Object)"YELLOW_CANDLE");
        shopConfig.set("items.yellowcandle.price", (Object)110);
        shopConfig.set("items.yellowcandle.sellPrice", (Object)35);
        shopConfig.set("items.yellowcandle.amount", (Object)1);
        shopConfig.set("items.yellowcandle.slot", (Object)25);
        shopConfig.set("items.yellowcandle.page", (Object)12);
        shopConfig.set("items.yellowcandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.liemcandle.material", (Object)"LIME_CANDLE");
        shopConfig.set("items.liemcandle.price", (Object)110);
        shopConfig.set("items.liemcandle.sellPrice", (Object)35);
        shopConfig.set("items.liemcandle.amount", (Object)1);
        shopConfig.set("items.liemcandle.slot", (Object)28);
        shopConfig.set("items.liemcandle.page", (Object)12);
        shopConfig.set("items.liemcandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.greencandle.material", (Object)"GREEN_CANDLE");
        shopConfig.set("items.greencandle.price", (Object)110);
        shopConfig.set("items.greencandle.sellPrice", (Object)35);
        shopConfig.set("items.greencandle.amount", (Object)1);
        shopConfig.set("items.greencandle.slot", (Object)30);
        shopConfig.set("items.greencandle.page", (Object)12);
        shopConfig.set("items.greencandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyancandle.material", (Object)"CYAN_CANDLE");
        shopConfig.set("items.cyancandle.price", (Object)110);
        shopConfig.set("items.cyancandle.sellPrice", (Object)35);
        shopConfig.set("items.cyancandle.amount", (Object)1);
        shopConfig.set("items.cyancandle.slot", (Object)32);
        shopConfig.set("items.cyancandle.page", (Object)12);
        shopConfig.set("items.cyancandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluecandle.material", (Object)"LIGHT_BLUE_CANDLE");
        shopConfig.set("items.lightbluecandle.price", (Object)110);
        shopConfig.set("items.lightbluecandle.sellPrice", (Object)35);
        shopConfig.set("items.lightbluecandle.amount", (Object)1);
        shopConfig.set("items.lightbluecandle.slot", (Object)34);
        shopConfig.set("items.lightbluecandle.page", (Object)12);
        shopConfig.set("items.lightbluecandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluecandle.material", (Object)"BLUE_CANDLE");
        shopConfig.set("items.bluecandle.price", (Object)110);
        shopConfig.set("items.bluecandle.sellPrice", (Object)35);
        shopConfig.set("items.bluecandle.amount", (Object)1);
        shopConfig.set("items.bluecandle.slot", (Object)10);
        shopConfig.set("items.bluecandle.page", (Object)13);
        shopConfig.set("items.bluecandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplecandle.material", (Object)"PURPLE_CANDLE");
        shopConfig.set("items.purplecandle.price", (Object)110);
        shopConfig.set("items.purplecandle.sellPrice", (Object)35);
        shopConfig.set("items.purplecandle.amount", (Object)1);
        shopConfig.set("items.purplecandle.slot", (Object)12);
        shopConfig.set("items.purplecandle.page", (Object)13);
        shopConfig.set("items.purplecandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.mangentacandle.material", (Object)"MAGENTA_CANDLE");
        shopConfig.set("items.mangentacandle.price", (Object)110);
        shopConfig.set("items.mangentacandle.sellPrice", (Object)35);
        shopConfig.set("items.mangentacandle.amount", (Object)1);
        shopConfig.set("items.mangentacandle.slot", (Object)14);
        shopConfig.set("items.mangentacandle.page", (Object)13);
        shopConfig.set("items.mangentacandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkcandle.material", (Object)"PINK_CANDLE");
        shopConfig.set("items.pinkcandle.price", (Object)110);
        shopConfig.set("items.pinkcandle.sellPrice", (Object)35);
        shopConfig.set("items.pinkcandle.amount", (Object)1);
        shopConfig.set("items.pinkcandle.slot", (Object)16);
        shopConfig.set("items.pinkcandle.page", (Object)13);
        shopConfig.set("items.pinkcandle.category", (Object)"Colored Blocks");
        shopConfig.set("items.whitebanner.material", (Object)"WHITE_BANNER");
        shopConfig.set("items.whitebanner.price", (Object)45);
        shopConfig.set("items.whitebanner.sellPrice", (Object)5);
        shopConfig.set("items.whitebanner.amount", (Object)1);
        shopConfig.set("items.whitebanner.slot", (Object)19);
        shopConfig.set("items.whitebanner.page", (Object)13);
        shopConfig.set("items.whitebanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightgraybanner.material", (Object)"LIGHT_GRAY_BANNER");
        shopConfig.set("items.lightgraybanner.price", (Object)45);
        shopConfig.set("items.lightgraybanner.sellPrice", (Object)5);
        shopConfig.set("items.lightgraybanner.amount", (Object)1);
        shopConfig.set("items.lightgraybanner.slot", (Object)21);
        shopConfig.set("items.lightgraybanner.page", (Object)13);
        shopConfig.set("items.lightgraybanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.graybanner.material", (Object)"GRAY_BANNER");
        shopConfig.set("items.graybanner.price", (Object)45);
        shopConfig.set("items.graybanner.sellPrice", (Object)5);
        shopConfig.set("items.graybanner.amount", (Object)1);
        shopConfig.set("items.graybanner.slot", (Object)23);
        shopConfig.set("items.graybanner.page", (Object)13);
        shopConfig.set("items.graybanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.blackbanner.material", (Object)"BLACK_BANNER");
        shopConfig.set("items.blackbanner.price", (Object)45);
        shopConfig.set("items.blackbanner.sellPrice", (Object)5);
        shopConfig.set("items.blackbanner.amount", (Object)1);
        shopConfig.set("items.blackbanner.slot", (Object)25);
        shopConfig.set("items.blackbanner.page", (Object)13);
        shopConfig.set("items.blackbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.brownbanner.material", (Object)"BROWN_BANNER");
        shopConfig.set("items.brownbanner.price", (Object)45);
        shopConfig.set("items.brownbanner.sellPrice", (Object)5);
        shopConfig.set("items.brownbanner.amount", (Object)1);
        shopConfig.set("items.brownbanner.slot", (Object)28);
        shopConfig.set("items.brownbanner.page", (Object)13);
        shopConfig.set("items.brownbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.redbanner.material", (Object)"RED_BANNER");
        shopConfig.set("items.redbanner.price", (Object)45);
        shopConfig.set("items.redbanner.sellPrice", (Object)5);
        shopConfig.set("items.redbanner.amount", (Object)1);
        shopConfig.set("items.redbanner.slot", (Object)30);
        shopConfig.set("items.redbanner.page", (Object)13);
        shopConfig.set("items.redbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.ornagebanner.material", (Object)"ORANGE_BANNER");
        shopConfig.set("items.ornagebanner.price", (Object)45);
        shopConfig.set("items.ornagebanner.sellPrice", (Object)5);
        shopConfig.set("items.ornagebanner.amount", (Object)1);
        shopConfig.set("items.ornagebanner.slot", (Object)32);
        shopConfig.set("items.ornagebanner.page", (Object)13);
        shopConfig.set("items.ornagebanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.yellowbanner.material", (Object)"YELLOW_BANNER");
        shopConfig.set("items.yellowbanner.price", (Object)45);
        shopConfig.set("items.yellowbanner.sellPrice", (Object)5);
        shopConfig.set("items.yellowbanner.amount", (Object)1);
        shopConfig.set("items.yellowbanner.slot", (Object)34);
        shopConfig.set("items.yellowbanner.page", (Object)13);
        shopConfig.set("items.yellowbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.limebanner.material", (Object)"LIME_BANNER");
        shopConfig.set("items.limebanner.price", (Object)45);
        shopConfig.set("items.limebanner.sellPrice", (Object)5);
        shopConfig.set("items.limebanner.amount", (Object)1);
        shopConfig.set("items.limebanner.slot", (Object)10);
        shopConfig.set("items.limebanner.page", (Object)14);
        shopConfig.set("items.limebanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.greenbanner.material", (Object)"GREEN_BANNER");
        shopConfig.set("items.greenbanner.price", (Object)45);
        shopConfig.set("items.greenbanner.sellPrice", (Object)5);
        shopConfig.set("items.greenbanner.amount", (Object)1);
        shopConfig.set("items.greenbanner.slot", (Object)12);
        shopConfig.set("items.greenbanner.page", (Object)14);
        shopConfig.set("items.greenbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.cyanbanner.material", (Object)"CYAN_BANNER");
        shopConfig.set("items.cyanbanner.price", (Object)45);
        shopConfig.set("items.cyanbanner.sellPrice", (Object)5);
        shopConfig.set("items.cyanbanner.amount", (Object)1);
        shopConfig.set("items.cyanbanner.slot", (Object)14);
        shopConfig.set("items.cyanbanner.page", (Object)14);
        shopConfig.set("items.cyanbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.lightbluebanner.material", (Object)"LIGHT_BLUE_BANNER");
        shopConfig.set("items.lightbluebanner.price", (Object)45);
        shopConfig.set("items.lightbluebanner.sellPrice", (Object)5);
        shopConfig.set("items.lightbluebanner.amount", (Object)1);
        shopConfig.set("items.lightbluebanner.slot", (Object)16);
        shopConfig.set("items.lightbluebanner.page", (Object)14);
        shopConfig.set("items.lightbluebanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.bluebanner.material", (Object)"BLUE_BANNER");
        shopConfig.set("items.bluebanner.price", (Object)45);
        shopConfig.set("items.bluebanner.sellPrice", (Object)5);
        shopConfig.set("items.bluebanner.amount", (Object)1);
        shopConfig.set("items.bluebanner.slot", (Object)19);
        shopConfig.set("items.bluebanner.page", (Object)14);
        shopConfig.set("items.bluebanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.purplebaner.material", (Object)"PURPLE_BANNER");
        shopConfig.set("items.purplebaner.price", (Object)45);
        shopConfig.set("items.purplebaner.sellPrice", (Object)5);
        shopConfig.set("items.purplebaner.amount", (Object)1);
        shopConfig.set("items.purplebaner.slot", (Object)21);
        shopConfig.set("items.purplebaner.page", (Object)14);
        shopConfig.set("items.purplebaner.category", (Object)"Colored Blocks");
        shopConfig.set("items.magentabanner.material", (Object)"MAGENTA_BANNER");
        shopConfig.set("items.magentabanner.price", (Object)45);
        shopConfig.set("items.magentabanner.sellPrice", (Object)5);
        shopConfig.set("items.magentabanner.amount", (Object)1);
        shopConfig.set("items.magentabanner.slot", (Object)23);
        shopConfig.set("items.magentabanner.page", (Object)14);
        shopConfig.set("items.magentabanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.pinkbanner.material", (Object)"PINK_BANNER");
        shopConfig.set("items.pinkbanner.price", (Object)45);
        shopConfig.set("items.pinkbanner.sellPrice", (Object)5);
        shopConfig.set("items.pinkbanner.amount", (Object)1);
        shopConfig.set("items.pinkbanner.slot", (Object)25);
        shopConfig.set("items.pinkbanner.page", (Object)14);
        shopConfig.set("items.pinkbanner.category", (Object)"Colored Blocks");
        shopConfig.set("items.wheatseeds.material", (Object)"WHEAT_SEEDS");
        shopConfig.set("items.wheatseeds.price", (Object)5);
        shopConfig.set("items.wheatseeds.sellPrice", (Object)1.5);
        shopConfig.set("items.wheatseeds.amount", (Object)1);
        shopConfig.set("items.wheatseeds.slot", (Object)10);
        shopConfig.set("items.wheatseeds.page", (Object)1);
        shopConfig.set("items.wheatseeds.category", (Object)"Farming");
        shopConfig.set("items.beetrootseeds.material", (Object)"BEETROOT_SEEDS");
        shopConfig.set("items.beetrootseeds.price", (Object)6);
        shopConfig.set("items.beetrootseeds.sellPrice", (Object)1.75);
        shopConfig.set("items.beetrootseeds.amount", (Object)1);
        shopConfig.set("items.beetrootseeds.slot", (Object)12);
        shopConfig.set("items.beetrootseeds.page", (Object)1);
        shopConfig.set("items.beetrootseeds.category", (Object)"Farming");
        shopConfig.set("items.melonseeds.material", (Object)"MELON_SEEDS");
        shopConfig.set("items.melonseeds.price", (Object)8);
        shopConfig.set("items.melonseeds.sellPrice", (Object)2.5);
        shopConfig.set("items.melonseeds.amount", (Object)1);
        shopConfig.set("items.melonseeds.slot", (Object)14);
        shopConfig.set("items.melonseeds.page", (Object)1);
        shopConfig.set("items.melonseeds.category", (Object)"Farming");
        shopConfig.set("items.pumpkinseeds.material", (Object)"PUMPKIN_SEEDS");
        shopConfig.set("items.pumpkinseeds.price", (Object)8);
        shopConfig.set("items.pumpkinseeds.sellPrice", (Object)2.5);
        shopConfig.set("items.pumpkinseeds.amount", (Object)1);
        shopConfig.set("items.pumpkinseeds.slot", (Object)16);
        shopConfig.set("items.pumpkinseeds.page", (Object)1);
        shopConfig.set("items.pumpkinseeds.category", (Object)"Farming");
        shopConfig.set("items.cocoabeans.material", (Object)"COCOA_BEANS");
        shopConfig.set("items.cocoabeans.price", (Object)10);
        shopConfig.set("items.cocoabeans.sellPrice", (Object)3);
        shopConfig.set("items.cocoabeans.amount", (Object)1);
        shopConfig.set("items.cocoabeans.slot", (Object)19);
        shopConfig.set("items.cocoabeans.page", (Object)1);
        shopConfig.set("items.cocoabeans.category", (Object)"Farming");
        shopConfig.set("items.netherwart.material", (Object)"NETHER_WART");
        shopConfig.set("items.netherwart.price", (Object)15);
        shopConfig.set("items.netherwart.sellPrice", (Object)5);
        shopConfig.set("items.netherwart.amount", (Object)1);
        shopConfig.set("items.netherwart.slot", (Object)21);
        shopConfig.set("items.netherwart.page", (Object)1);
        shopConfig.set("items.netherwart.category", (Object)"Farming");
        shopConfig.set("items.torchflowerseeds.material", (Object)"TORCHFLOWER_SEEDS");
        shopConfig.set("items.torchflowerseeds.price", (Object)100);
        shopConfig.set("items.torchflowerseeds.sellPrice", (Object)25);
        shopConfig.set("items.torchflowerseeds.amount", (Object)1);
        shopConfig.set("items.torchflowerseeds.slot", (Object)23);
        shopConfig.set("items.torchflowerseeds.page", (Object)1);
        shopConfig.set("items.torchflowerseeds.category", (Object)"Farming");
        shopConfig.set("items.pitcherpod.material", (Object)"PITCHER_POD");
        shopConfig.set("items.pitcherpod.price", (Object)100);
        shopConfig.set("items.pitcherpod.sellPrice", (Object)25);
        shopConfig.set("items.pitcherpod.amount", (Object)1);
        shopConfig.set("items.pitcherpod.slot", (Object)25);
        shopConfig.set("items.pitcherpod.page", (Object)1);
        shopConfig.set("items.pitcherpod.category", (Object)"Farming");
        shopConfig.set("items.bamboo.material", (Object)"BAMBOO");
        shopConfig.set("items.bamboo.price", (Object)10);
        shopConfig.set("items.bamboo.sellPrice", (Object)2);
        shopConfig.set("items.bamboo.amount", (Object)1);
        shopConfig.set("items.bamboo.slot", (Object)28);
        shopConfig.set("items.bamboo.page", (Object)1);
        shopConfig.set("items.bamboo.category", (Object)"Farming");
        shopConfig.set("items.sweetberries.material", (Object)"SWEET_BERRIES");
        shopConfig.set("items.sweetberries.price", (Object)8);
        shopConfig.set("items.sweetberries.sellPrice", (Object)2.5);
        shopConfig.set("items.sweetberries.amount", (Object)1);
        shopConfig.set("items.sweetberries.slot", (Object)30);
        shopConfig.set("items.sweetberries.page", (Object)1);
        shopConfig.set("items.sweetberries.category", (Object)"Farming");
        shopConfig.set("items.glowberries.material", (Object)"GLOW_BERRIES");
        shopConfig.set("items.glowberries.price", (Object)8);
        shopConfig.set("items.glowberries.sellPrice", (Object)3.5);
        shopConfig.set("items.glowberries.amount", (Object)1);
        shopConfig.set("items.glowberries.slot", (Object)32);
        shopConfig.set("items.glowberries.page", (Object)1);
        shopConfig.set("items.glowberries.category", (Object)"Farming");
        shopConfig.set("items.kelp.material", (Object)"KELP");
        shopConfig.set("items.kelp.price", (Object)4);
        shopConfig.set("items.kelp.sellPrice", (Object)1);
        shopConfig.set("items.kelp.amount", (Object)1);
        shopConfig.set("items.kelp.slot", (Object)34);
        shopConfig.set("items.kelp.page", (Object)1);
        shopConfig.set("items.kelp.category", (Object)"Farming");
        shopConfig.set("items.wheat.material", (Object)"WHEAT");
        shopConfig.set("items.wheat.price", (Object)12);
        shopConfig.set("items.wheat.sellPrice", (Object)4);
        shopConfig.set("items.wheat.amount", (Object)1);
        shopConfig.set("items.wheat.slot", (Object)10);
        shopConfig.set("items.wheat.page", (Object)2);
        shopConfig.set("items.wheat.category", (Object)"Farming");
        shopConfig.set("items.carrot.material", (Object)"CARROT");
        shopConfig.set("items.carrot.price", (Object)10);
        shopConfig.set("items.carrot.sellPrice", (Object)3);
        shopConfig.set("items.carrot.amount", (Object)1);
        shopConfig.set("items.carrot.slot", (Object)12);
        shopConfig.set("items.carrot.page", (Object)2);
        shopConfig.set("items.carrot.category", (Object)"Farming");
        shopConfig.set("items.potato.material", (Object)"POTATO");
        shopConfig.set("items.potato.price", (Object)10);
        shopConfig.set("items.potato.sellPrice", (Object)3);
        shopConfig.set("items.potato.amount", (Object)1);
        shopConfig.set("items.potato.slot", (Object)14);
        shopConfig.set("items.potato.page", (Object)2);
        shopConfig.set("items.potato.category", (Object)"Farming");
        shopConfig.set("items.beetroot.material", (Object)"BEETROOT");
        shopConfig.set("items.beetroot.price", (Object)10);
        shopConfig.set("items.beetroot.sellPrice", (Object)2.5);
        shopConfig.set("items.beetroot.amount", (Object)1);
        shopConfig.set("items.beetroot.slot", (Object)16);
        shopConfig.set("items.beetroot.page", (Object)2);
        shopConfig.set("items.beetroot.category", (Object)"Farming");
        shopConfig.set("items.melonslice.material", (Object)"MELON_SLICE");
        shopConfig.set("items.melonslice.price", (Object)6);
        shopConfig.set("items.melonslice.sellPrice", (Object)1.75);
        shopConfig.set("items.melonslice.amount", (Object)1);
        shopConfig.set("items.melonslice.slot", (Object)19);
        shopConfig.set("items.melonslice.page", (Object)2);
        shopConfig.set("items.melonslice.category", (Object)"Farming");
        shopConfig.set("items.pumpkin.material", (Object)"PUMPKIN");
        shopConfig.set("items.pumpkin.price", (Object)15);
        shopConfig.set("items.pumpkin.sellPrice", (Object)4);
        shopConfig.set("items.pumpkin.amount", (Object)1);
        shopConfig.set("items.pumpkin.slot", (Object)21);
        shopConfig.set("items.pumpkin.page", (Object)2);
        shopConfig.set("items.pumpkin.category", (Object)"Farming");
        shopConfig.set("items.carvedpumpkin.material", (Object)"CARVED_PUMPKIN");
        shopConfig.set("items.carvedpumpkin.price", (Object)20);
        shopConfig.set("items.carvedpumpkin.sellPrice", (Object)6);
        shopConfig.set("items.carvedpumpkin.amount", (Object)1);
        shopConfig.set("items.carvedpumpkin.slot", (Object)23);
        shopConfig.set("items.carvedpumpkin.page", (Object)2);
        shopConfig.set("items.carvedpumpkin.category", (Object)"Farming");
        shopConfig.set("items.sugarcane.material", (Object)"SUGAR_CANE");
        shopConfig.set("items.sugarcane.price", (Object)8);
        shopConfig.set("items.sugarcane.sellPrice", (Object)2);
        shopConfig.set("items.sugarcane.amount", (Object)1);
        shopConfig.set("items.sugarcane.slot", (Object)25);
        shopConfig.set("items.sugarcane.page", (Object)2);
        shopConfig.set("items.sugarcane.category", (Object)"Farming");
        shopConfig.set("items.cactus.material", (Object)"CACTUS");
        shopConfig.set("items.cactus.price", (Object)10);
        shopConfig.set("items.cactus.sellPrice", (Object)2.5);
        shopConfig.set("items.cactus.amount", (Object)1);
        shopConfig.set("items.cactus.slot", (Object)28);
        shopConfig.set("items.cactus.page", (Object)2);
        shopConfig.set("items.cactus.category", (Object)"Farming");
        shopConfig.set("items.seapickle.material", (Object)"SEA_PICKLE");
        shopConfig.set("items.seapickle.price", (Object)12);
        shopConfig.set("items.seapickle.sellPrice", (Object)3);
        shopConfig.set("items.seapickle.amount", (Object)1);
        shopConfig.set("items.seapickle.slot", (Object)28);
        shopConfig.set("items.seapickle.page", (Object)2);
        shopConfig.set("items.seapickle.category", (Object)"Farming");
        shopConfig.set("items.cookedporckchop.material", (Object)"COOKED_PORKCHOP");
        shopConfig.set("items.cookedporckchop.price", (Object)40);
        shopConfig.set("items.cookedporckchop.sellPrice", (Object)10);
        shopConfig.set("items.cookedporckchop.amount", (Object)1);
        shopConfig.set("items.cookedporckchop.slot", (Object)10);
        shopConfig.set("items.cookedporckchop.page", (Object)1);
        shopConfig.set("items.cookedporckchop.category", (Object)"Food");
        shopConfig.set("items.cookedbeef.material", (Object)"COOKED_BEEF");
        shopConfig.set("items.cookedbeef.price", (Object)45);
        shopConfig.set("items.cookedbeef.sellPrice", (Object)11);
        shopConfig.set("items.cookedbeef.amount", (Object)1);
        shopConfig.set("items.cookedbeef.slot", (Object)12);
        shopConfig.set("items.cookedbeef.page", (Object)1);
        shopConfig.set("items.cookedbeef.category", (Object)"Food");
        shopConfig.set("items.cookedchicken.material", (Object)"COOKED_CHICKEN");
        shopConfig.set("items.cookedchicken.price", (Object)35);
        shopConfig.set("items.cookedchicken.sellPrice", (Object)8);
        shopConfig.set("items.cookedchicken.amount", (Object)1);
        shopConfig.set("items.cookedchicken.slot", (Object)14);
        shopConfig.set("items.cookedchicken.page", (Object)1);
        shopConfig.set("items.cookedchicken.category", (Object)"Food");
        shopConfig.set("items.cookedmutton.material", (Object)"COOKED_MUTTON");
        shopConfig.set("items.cookedmutton.price", (Object)38);
        shopConfig.set("items.cookedmutton.sellPrice", (Object)9);
        shopConfig.set("items.cookedmutton.amount", (Object)1);
        shopConfig.set("items.cookedmutton.slot", (Object)16);
        shopConfig.set("items.cookedmutton.page", (Object)1);
        shopConfig.set("items.cookedmutton.category", (Object)"Food");
        shopConfig.set("items.cookedrabbit.material", (Object)"COOKED_RABBIT");
        shopConfig.set("items.cookedrabbit.price", (Object)30);
        shopConfig.set("items.cookedrabbit.sellPrice", (Object)7.5);
        shopConfig.set("items.cookedrabbit.amount", (Object)1);
        shopConfig.set("items.cookedrabbit.slot", (Object)19);
        shopConfig.set("items.cookedrabbit.page", (Object)1);
        shopConfig.set("items.cookedrabbit.category", (Object)"Food");
        shopConfig.set("items.cookedcod.material", (Object)"COOKED_COD");
        shopConfig.set("items.cookedcod.price", (Object)25);
        shopConfig.set("items.cookedcod.sellPrice", (Object)6);
        shopConfig.set("items.cookedcod.amount", (Object)1);
        shopConfig.set("items.cookedcod.slot", (Object)21);
        shopConfig.set("items.cookedcod.page", (Object)1);
        shopConfig.set("items.cookedcod.category", (Object)"Food");
        shopConfig.set("items.cookedsalmon.material", (Object)"COOKED_SALMON");
        shopConfig.set("items.cookedsalmon.price", (Object)26);
        shopConfig.set("items.cookedsalmon.sellPrice", (Object)7);
        shopConfig.set("items.cookedsalmon.amount", (Object)1);
        shopConfig.set("items.cookedsalmon.slot", (Object)23);
        shopConfig.set("items.cookedsalmon.page", (Object)1);
        shopConfig.set("items.cookedsalmon.category", (Object)"Food");
        shopConfig.set("items.rawporkchop.material", (Object)"PORKCHOP");
        shopConfig.set("items.rawporkchop.price", (Object)20);
        shopConfig.set("items.rawporkchop.sellPrice", (Object)5);
        shopConfig.set("items.rawporkchop.amount", (Object)1);
        shopConfig.set("items.rawporkchop.slot", (Object)25);
        shopConfig.set("items.rawporkchop.page", (Object)1);
        shopConfig.set("items.rawporkchop.category", (Object)"Food");
        shopConfig.set("items.rawbeef.material", (Object)"BEEF");
        shopConfig.set("items.rawbeef.price", (Object)22);
        shopConfig.set("items.rawbeef.sellPrice", (Object)5.5);
        shopConfig.set("items.rawbeef.amount", (Object)1);
        shopConfig.set("items.rawbeef.slot", (Object)28);
        shopConfig.set("items.rawbeef.page", (Object)1);
        shopConfig.set("items.rawbeef.category", (Object)"Food");
        shopConfig.set("items.rawchicken.material", (Object)"CHICKEN");
        shopConfig.set("items.rawchicken.price", (Object)18);
        shopConfig.set("items.rawchicken.sellPrice", (Object)4);
        shopConfig.set("items.rawchicken.amount", (Object)1);
        shopConfig.set("items.rawchicken.slot", (Object)30);
        shopConfig.set("items.rawchicken.page", (Object)1);
        shopConfig.set("items.rawchicken.category", (Object)"Food");
        shopConfig.set("items.rawmutton.material", (Object)"MUTTON");
        shopConfig.set("items.rawmutton.price", (Object)19);
        shopConfig.set("items.rawmutton.sellPrice", (Object)4.5);
        shopConfig.set("items.rawmutton.amount", (Object)1);
        shopConfig.set("items.rawmutton.slot", (Object)32);
        shopConfig.set("items.rawmutton.page", (Object)1);
        shopConfig.set("items.rawmutton.category", (Object)"Food");
        shopConfig.set("items.rawrabbit.material", (Object)"RABBIT");
        shopConfig.set("items.rawrabbit.price", (Object)15);
        shopConfig.set("items.rawrabbit.sellPrice", (Object)3.5);
        shopConfig.set("items.rawrabbit.amount", (Object)1);
        shopConfig.set("items.rawrabbit.slot", (Object)34);
        shopConfig.set("items.rawrabbit.page", (Object)1);
        shopConfig.set("items.rawrabbit.category", (Object)"Food");
        shopConfig.set("items.rawcod.material", (Object)"COD");
        shopConfig.set("items.rawcod.price", (Object)12);
        shopConfig.set("items.rawcod.sellPrice", (Object)3);
        shopConfig.set("items.rawcod.amount", (Object)1);
        shopConfig.set("items.rawcod.slot", (Object)10);
        shopConfig.set("items.rawcod.page", (Object)2);
        shopConfig.set("items.rawcod.category", (Object)"Food");
        shopConfig.set("items.rawsalmon.material", (Object)"SALMON");
        shopConfig.set("items.rawsalmon.price", (Object)14);
        shopConfig.set("items.rawsalmon.sellPrice", (Object)3.5);
        shopConfig.set("items.rawsalmon.amount", (Object)1);
        shopConfig.set("items.rawsalmon.slot", (Object)12);
        shopConfig.set("items.rawsalmon.page", (Object)2);
        shopConfig.set("items.rawsalmon.category", (Object)"Food");
        shopConfig.set("items.bread.material", (Object)"BREAD");
        shopConfig.set("items.bread.price", (Object)15);
        shopConfig.set("items.bread.sellPrice", (Object)3.5);
        shopConfig.set("items.bread.amount", (Object)1);
        shopConfig.set("items.bread.slot", (Object)14);
        shopConfig.set("items.bread.page", (Object)2);
        shopConfig.set("items.bread.category", (Object)"Food");
        shopConfig.set("items.bakedpotato.material", (Object)"BAKED_POTATO");
        shopConfig.set("items.bakedpotato.price", (Object)12);
        shopConfig.set("items.bakedpotato.sellPrice", (Object)3);
        shopConfig.set("items.bakedpotato.amount", (Object)1);
        shopConfig.set("items.bakedpotato.slot", (Object)16);
        shopConfig.set("items.bakedpotato.page", (Object)2);
        shopConfig.set("items.bakedpotato.category", (Object)"Food");
        shopConfig.set("items.carrot1.material", (Object)"CARROT");
        shopConfig.set("items.carrot1.price", (Object)10);
        shopConfig.set("items.carrot1.sellPrice", (Object)2.5);
        shopConfig.set("items.carrot1.amount", (Object)1);
        shopConfig.set("items.carrot1.slot", (Object)19);
        shopConfig.set("items.carrot1.page", (Object)2);
        shopConfig.set("items.carrot1.category", (Object)"Food");
        shopConfig.set("items.potato1.material", (Object)"POTATO");
        shopConfig.set("items.potato1.price", (Object)8);
        shopConfig.set("items.potato1.sellPrice", (Object)2);
        shopConfig.set("items.potato1.amount", (Object)1);
        shopConfig.set("items.potato1.slot", (Object)21);
        shopConfig.set("items.potato1.page", (Object)2);
        shopConfig.set("items.potato1.category", (Object)"Food");
        shopConfig.set("items.beetroot1.material", (Object)"BEETROOT");
        shopConfig.set("items.beetroot1.price", (Object)6);
        shopConfig.set("items.beetroot1.sellPrice", (Object)1.5);
        shopConfig.set("items.beetroot1.amount", (Object)1);
        shopConfig.set("items.beetroot1.slot", (Object)23);
        shopConfig.set("items.beetroot1.page", (Object)2);
        shopConfig.set("items.beetroot1.category", (Object)"Food");
        shopConfig.set("items.melonslic1e.material", (Object)"MELON_SLICE");
        shopConfig.set("items.melonslic1e.price", (Object)5);
        shopConfig.set("items.melonslic1e.sellPrice", (Object)1);
        shopConfig.set("items.melonslic1e.amount", (Object)1);
        shopConfig.set("items.melonslic1e.slot", (Object)25);
        shopConfig.set("items.melonslic1e.page", (Object)2);
        shopConfig.set("items.melonslic1e.category", (Object)"Food");
        shopConfig.set("items.pumpkinpie.material", (Object)"PUMPKIN_PIE");
        shopConfig.set("items.pumpkinpie.price", (Object)20);
        shopConfig.set("items.pumpkinpie.sellPrice", (Object)5);
        shopConfig.set("items.pumpkinpie.amount", (Object)1);
        shopConfig.set("items.pumpkinpie.slot", (Object)28);
        shopConfig.set("items.pumpkinpie.page", (Object)2);
        shopConfig.set("items.pumpkinpie.category", (Object)"Food");
        shopConfig.set("items.apple1.material", (Object)"APPLE");
        shopConfig.set("items.apple1.price", (Object)12);
        shopConfig.set("items.apple1.sellPrice", (Object)3);
        shopConfig.set("items.apple1.amount", (Object)1);
        shopConfig.set("items.apple1.slot", (Object)30);
        shopConfig.set("items.apple1.page", (Object)2);
        shopConfig.set("items.apple1.category", (Object)"Food");
        shopConfig.set("items.sweetberries1.material", (Object)"SWEET_BERRIES");
        shopConfig.set("items.sweetberries1.price", (Object)6);
        shopConfig.set("items.sweetberries1.sellPrice", (Object)1.5);
        shopConfig.set("items.sweetberries1.amount", (Object)1);
        shopConfig.set("items.sweetberries1.slot", (Object)32);
        shopConfig.set("items.sweetberries1.page", (Object)2);
        shopConfig.set("items.sweetberries1.category", (Object)"Food");
        shopConfig.set("items.glowberries1.material", (Object)"GLOW_BERRIES");
        shopConfig.set("items.glowberries1.price", (Object)8);
        shopConfig.set("items.glowberries1.sellPrice", (Object)2);
        shopConfig.set("items.glowberries1.amount", (Object)1);
        shopConfig.set("items.glowberries1.slot", (Object)34);
        shopConfig.set("items.glowberries1.page", (Object)2);
        shopConfig.set("items.glowberries1.category", (Object)"Food");
        shopConfig.set("items.chorusfruit1.material", (Object)"CHORUS_FRUIT");
        shopConfig.set("items.chorusfruit1.price", (Object)10);
        shopConfig.set("items.chorusfruit1.sellPrice", (Object)2.5);
        shopConfig.set("items.chorusfruit1.amount", (Object)1);
        shopConfig.set("items.chorusfruit1.slot", (Object)10);
        shopConfig.set("items.chorusfruit1.page", (Object)3);
        shopConfig.set("items.chorusfruit1.category", (Object)"Food");
        shopConfig.set("items.driedkelp.material", (Object)"DRIED_KELP");
        shopConfig.set("items.driedkelp.price", (Object)4);
        shopConfig.set("items.driedkelp.sellPrice", (Object)1);
        shopConfig.set("items.driedkelp.amount", (Object)1);
        shopConfig.set("items.driedkelp.slot", (Object)12);
        shopConfig.set("items.driedkelp.page", (Object)3);
        shopConfig.set("items.driedkelp.category", (Object)"Food");
        shopConfig.set("items.cake.material", (Object)"CAKE");
        shopConfig.set("items.cake.price", (Object)50);
        shopConfig.set("items.cake.sellPrice", (Object)12);
        shopConfig.set("items.cake.amount", (Object)1);
        shopConfig.set("items.cake.slot", (Object)14);
        shopConfig.set("items.cake.page", (Object)3);
        shopConfig.set("items.cake.category", (Object)"Food");
        shopConfig.set("items.cookie.material", (Object)"COOKIE");
        shopConfig.set("items.cookie.price", (Object)8);
        shopConfig.set("items.cookie.sellPrice", (Object)2);
        shopConfig.set("items.cookie.amount", (Object)1);
        shopConfig.set("items.cookie.slot", (Object)16);
        shopConfig.set("items.cookie.page", (Object)3);
        shopConfig.set("items.cookie.category", (Object)"Food");
        shopConfig.set("items.mushroomstew.material", (Object)"MUSHROOM_STEW");
        shopConfig.set("items.mushroomstew.price", (Object)15);
        shopConfig.set("items.mushroomstew.sellPrice", (Object)3);
        shopConfig.set("items.mushroomstew.amount", (Object)1);
        shopConfig.set("items.mushroomstew.slot", (Object)19);
        shopConfig.set("items.mushroomstew.page", (Object)3);
        shopConfig.set("items.mushroomstew.category", (Object)"Food");
        shopConfig.set("items.beetrootsoupo.material", (Object)"BEETROOT_SOUP");
        shopConfig.set("items.beetrootsoupo.price", (Object)14);
        shopConfig.set("items.beetrootsoupo.sellPrice", (Object)3);
        shopConfig.set("items.beetrootsoupo.amount", (Object)1);
        shopConfig.set("items.beetrootsoupo.slot", (Object)21);
        shopConfig.set("items.beetrootsoupo.page", (Object)3);
        shopConfig.set("items.beetrootsoupo.category", (Object)"Food");
        shopConfig.set("items.rabbitstew.material", (Object)"RABBIT_STEW");
        shopConfig.set("items.rabbitstew.price", (Object)25);
        shopConfig.set("items.rabbitstew.sellPrice", (Object)6);
        shopConfig.set("items.rabbitstew.amount", (Object)1);
        shopConfig.set("items.rabbitstew.slot", (Object)23);
        shopConfig.set("items.rabbitstew.page", (Object)3);
        shopConfig.set("items.rabbitstew.category", (Object)"Food");
        shopConfig.set("items.goldencarrot.material", (Object)"GOLDEN_CARROT");
        shopConfig.set("items.goldencarrot.price", (Object)100);
        shopConfig.set("items.goldencarrot.sellPrice", (Object)20);
        shopConfig.set("items.goldencarrot.amount", (Object)1);
        shopConfig.set("items.goldencarrot.slot", (Object)25);
        shopConfig.set("items.goldencarrot.page", (Object)3);
        shopConfig.set("items.goldencarrot.category", (Object)"Food");
        shopConfig.set("items.goldenapple.material", (Object)"GOLDEN_APPLE");
        shopConfig.set("items.goldenapple.price", (Object)500);
        shopConfig.set("items.goldenapple.sellPrice", (Object)120);
        shopConfig.set("items.goldenapple.amount", (Object)1);
        shopConfig.set("items.goldenapple.slot", (Object)28);
        shopConfig.set("items.goldenapple.page", (Object)3);
        shopConfig.set("items.goldenapple.category", (Object)"Food");
        shopConfig.set("items.enchantedgoldenapple.material", (Object)"ENCHANTED_GOLDEN_APPLE");
        shopConfig.set("items.enchantedgoldenapple.price", (Object)3000);
        shopConfig.set("items.enchantedgoldenapple.sellPrice", (Object)-1);
        shopConfig.set("items.enchantedgoldenapple.amount", (Object)1);
        shopConfig.set("items.enchantedgoldenapple.slot", (Object)30);
        shopConfig.set("items.enchantedgoldenapple.page", (Object)3);
        shopConfig.set("items.enchantedgoldenapple.category", (Object)"Food");
        shopConfig.set("items.honeybottle.material", (Object)"HONEY_BOTTLE");
        shopConfig.set("items.honeybottle.price", (Object)20);
        shopConfig.set("items.honeybottle.sellPrice", (Object)5);
        shopConfig.set("items.honeybottle.amount", (Object)1);
        shopConfig.set("items.honeybottle.slot", (Object)32);
        shopConfig.set("items.honeybottle.page", (Object)3);
        shopConfig.set("items.honeybottle.category", (Object)"Food");
        shopConfig.set("items.pufferfish.material", (Object)"PUFFERFISH");
        shopConfig.set("items.pufferfish.price", (Object)15);
        shopConfig.set("items.pufferfish.sellPrice", (Object)3);
        shopConfig.set("items.pufferfish.amount", (Object)1);
        shopConfig.set("items.pufferfish.slot", (Object)34);
        shopConfig.set("items.pufferfish.page", (Object)3);
        shopConfig.set("items.pufferfish.category", (Object)"Food");
        shopConfig.set("items.redstonedust.material", (Object)"REDSTONE");
        shopConfig.set("items.redstonedust.price", (Object)10);
        shopConfig.set("items.redstonedust.sellPrice", (Object)2);
        shopConfig.set("items.redstonedust.amount", (Object)1);
        shopConfig.set("items.redstonedust.slot", (Object)10);
        shopConfig.set("items.redstonedust.page", (Object)1);
        shopConfig.set("items.redstonedust.category", (Object)"Redstone");
        shopConfig.set("items.redstonetorch.material", (Object)"REDSTONE_TORCH");
        shopConfig.set("items.redstonetorch.price", (Object)12);
        shopConfig.set("items.redstonetorch.sellPrice", (Object)3);
        shopConfig.set("items.redstonetorch.amount", (Object)1);
        shopConfig.set("items.redstonetorch.slot", (Object)12);
        shopConfig.set("items.redstonetorch.page", (Object)1);
        shopConfig.set("items.redstonetorch.category", (Object)"Redstone");
        shopConfig.set("items.redstoneblock.material", (Object)"REDSTONE_BLOCK");
        shopConfig.set("items.redstoneblock.price", (Object)90);
        shopConfig.set("items.redstoneblock.sellPrice", (Object)25);
        shopConfig.set("items.redstoneblock.amount", (Object)1);
        shopConfig.set("items.redstoneblock.slot", (Object)14);
        shopConfig.set("items.redstoneblock.page", (Object)1);
        shopConfig.set("items.redstoneblock.category", (Object)"Redstone");
        shopConfig.set("items.repeater.material", (Object)"REPEATER");
        shopConfig.set("items.repeater.price", (Object)25);
        shopConfig.set("items.repeater.sellPrice", (Object)6);
        shopConfig.set("items.repeater.amount", (Object)1);
        shopConfig.set("items.repeater.slot", (Object)16);
        shopConfig.set("items.repeater.page", (Object)1);
        shopConfig.set("items.repeater.category", (Object)"Redstone");
        shopConfig.set("items.comparator.material", (Object)"COMPARATOR");
        shopConfig.set("items.comparator.price", (Object)30);
        shopConfig.set("items.comparator.sellPrice", (Object)7);
        shopConfig.set("items.comparator.amount", (Object)1);
        shopConfig.set("items.comparator.slot", (Object)19);
        shopConfig.set("items.comparator.page", (Object)1);
        shopConfig.set("items.comparator.category", (Object)"Redstone");
        shopConfig.set("items.piston.material", (Object)"PISTON");
        shopConfig.set("items.piston.price", (Object)20);
        shopConfig.set("items.piston.sellPrice", (Object)5);
        shopConfig.set("items.piston.amount", (Object)1);
        shopConfig.set("items.piston.slot", (Object)21);
        shopConfig.set("items.piston.page", (Object)1);
        shopConfig.set("items.piston.category", (Object)"Redstone");
        shopConfig.set("items.stickypiston.material", (Object)"STICKY_PISTON");
        shopConfig.set("items.stickypiston.price", (Object)30);
        shopConfig.set("items.stickypiston.sellPrice", (Object)7);
        shopConfig.set("items.stickypiston.amount", (Object)1);
        shopConfig.set("items.stickypiston.slot", (Object)23);
        shopConfig.set("items.stickypiston.page", (Object)1);
        shopConfig.set("items.stickypiston.category", (Object)"Redstone");
        shopConfig.set("items.observer.material", (Object)"OBSERVER");
        shopConfig.set("items.observer.price", (Object)35);
        shopConfig.set("items.observer.sellPrice", (Object)8);
        shopConfig.set("items.observer.amount", (Object)1);
        shopConfig.set("items.observer.slot", (Object)25);
        shopConfig.set("items.observer.page", (Object)1);
        shopConfig.set("items.observer.category", (Object)"Redstone");
        shopConfig.set("items.hopper.material", (Object)"HOPPER");
        shopConfig.set("items.hopper.price", (Object)50);
        shopConfig.set("items.hopper.sellPrice", (Object)12);
        shopConfig.set("items.hopper.amount", (Object)1);
        shopConfig.set("items.hopper.slot", (Object)28);
        shopConfig.set("items.hopper.page", (Object)1);
        shopConfig.set("items.hopper.category", (Object)"Redstone");
        shopConfig.set("items.dropper.material", (Object)"DROPPER");
        shopConfig.set("items.dropper.price", (Object)20);
        shopConfig.set("items.dropper.sellPrice", (Object)5);
        shopConfig.set("items.dropper.amount", (Object)1);
        shopConfig.set("items.dropper.slot", (Object)30);
        shopConfig.set("items.dropper.page", (Object)1);
        shopConfig.set("items.dropper.category", (Object)"Redstone");
        shopConfig.set("items.dispenser.material", (Object)"DISPENSER");
        shopConfig.set("items.dispenser.price", (Object)25);
        shopConfig.set("items.dispenser.sellPrice", (Object)6);
        shopConfig.set("items.dispenser.amount", (Object)1);
        shopConfig.set("items.dispenser.slot", (Object)32);
        shopConfig.set("items.dispenser.page", (Object)1);
        shopConfig.set("items.dispenser.category", (Object)"Redstone");
        shopConfig.set("items.tntminecart.material", (Object)"TNT_MINECART");
        shopConfig.set("items.tntminecart.price", (Object)55);
        shopConfig.set("items.tntminecart.sellPrice", (Object)13);
        shopConfig.set("items.tntminecart.amount", (Object)1);
        shopConfig.set("items.tntminecart.slot", (Object)34);
        shopConfig.set("items.tntminecart.page", (Object)1);
        shopConfig.set("items.tntminecart.category", (Object)"Redstone");
        shopConfig.set("items.lever.material", (Object)"LEVER");
        shopConfig.set("items.lever.price", (Object)6);
        shopConfig.set("items.lever.sellPrice", (Object)1.5);
        shopConfig.set("items.lever.amount", (Object)1);
        shopConfig.set("items.lever.slot", (Object)10);
        shopConfig.set("items.lever.page", (Object)2);
        shopConfig.set("items.lever.category", (Object)"Redstone");
        shopConfig.set("items.stonebutton.material", (Object)"STONE_BUTTON");
        shopConfig.set("items.stonebutton.price", (Object)4);
        shopConfig.set("items.stonebutton.sellPrice", (Object)1);
        shopConfig.set("items.stonebutton.amount", (Object)1);
        shopConfig.set("items.stonebutton.slot", (Object)12);
        shopConfig.set("items.stonebutton.page", (Object)2);
        shopConfig.set("items.stonebutton.category", (Object)"Redstone");
        shopConfig.set("items.oakpressureplate.material", (Object)"OAK_PRESSURE_PLATE");
        shopConfig.set("items.oakpressureplate.price", (Object)6);
        shopConfig.set("items.oakpressureplate.sellPrice", (Object)1.5);
        shopConfig.set("items.oakpressureplate.amount", (Object)1);
        shopConfig.set("items.oakpressureplate.slot", (Object)14);
        shopConfig.set("items.oakpressureplate.page", (Object)2);
        shopConfig.set("items.oakpressureplate.category", (Object)"Redstone");
        shopConfig.set("items.tripwirehook.material", (Object)"TRIPWIRE_HOOK");
        shopConfig.set("items.tripwirehook.price", (Object)8);
        shopConfig.set("items.tripwirehook.sellPrice", (Object)2);
        shopConfig.set("items.tripwirehook.amount", (Object)1);
        shopConfig.set("items.tripwirehook.slot", (Object)16);
        shopConfig.set("items.tripwirehook.page", (Object)2);
        shopConfig.set("items.tripwirehook.category", (Object)"Redstone");
        shopConfig.set("items.daylightdetector.material", (Object)"DAYLIGHT_DETECTOR");
        shopConfig.set("items.daylightdetector.price", (Object)30);
        shopConfig.set("items.daylightdetector.sellPrice", (Object)7.5);
        shopConfig.set("items.daylightdetector.amount", (Object)1);
        shopConfig.set("items.daylightdetector.slot", (Object)19);
        shopConfig.set("items.daylightdetector.page", (Object)2);
        shopConfig.set("items.daylightdetector.category", (Object)"Redstone");
        shopConfig.set("items.targetblock.material", (Object)"TARGET");
        shopConfig.set("items.targetblock.price", (Object)18);
        shopConfig.set("items.targetblock.sellPrice", (Object)4.5);
        shopConfig.set("items.targetblock.amount", (Object)1);
        shopConfig.set("items.targetblock.slot", (Object)21);
        shopConfig.set("items.targetblock.page", (Object)2);
        shopConfig.set("items.targetblock.category", (Object)"Redstone");
        shopConfig.set("items.trappedchest.material", (Object)"TRAPPED_CHEST");
        shopConfig.set("items.trappedchest.price", (Object)25);
        shopConfig.set("items.trappedchest.sellPrice", (Object)6.25);
        shopConfig.set("items.trappedchest.amount", (Object)1);
        shopConfig.set("items.trappedchest.slot", (Object)23);
        shopConfig.set("items.trappedchest.page", (Object)2);
        shopConfig.set("items.trappedchest.category", (Object)"Redstone");
        shopConfig.set("items.poweredrail.material", (Object)"POWERED_RAIL");
        shopConfig.set("items.poweredrail.price", (Object)15);
        shopConfig.set("items.poweredrail.sellPrice", (Object)4);
        shopConfig.set("items.poweredrail.amount", (Object)1);
        shopConfig.set("items.poweredrail.slot", (Object)25);
        shopConfig.set("items.poweredrail.page", (Object)2);
        shopConfig.set("items.poweredrail.category", (Object)"Redstone");
        shopConfig.set("items.activatorrail.material", (Object)"ACTIVATOR_RAIL");
        shopConfig.set("items.activatorrail.price", (Object)12);
        shopConfig.set("items.activatorrail.sellPrice", (Object)3);
        shopConfig.set("items.activatorrail.amount", (Object)1);
        shopConfig.set("items.activatorrail.slot", (Object)28);
        shopConfig.set("items.activatorrail.page", (Object)2);
        shopConfig.set("items.activatorrail.category", (Object)"Redstone");
        shopConfig.set("items.detectorrail.material", (Object)"DETECTOR_RAIL");
        shopConfig.set("items.detectorrail.price", (Object)12);
        shopConfig.set("items.detectorrail.sellPrice", (Object)3);
        shopConfig.set("items.detectorrail.amount", (Object)1);
        shopConfig.set("items.detectorrail.slot", (Object)30);
        shopConfig.set("items.detectorrail.page", (Object)2);
        shopConfig.set("items.detectorrail.category", (Object)"Redstone");
        shopConfig.set("items.rail.material", (Object)"RAIL");
        shopConfig.set("items.rail.price", (Object)6);
        shopConfig.set("items.rail.sellPrice", (Object)1.5);
        shopConfig.set("items.rail.amount", (Object)1);
        shopConfig.set("items.rail.slot", (Object)32);
        shopConfig.set("items.rail.page", (Object)2);
        shopConfig.set("items.rail.category", (Object)"Redstone");
        shopConfig.set("items.bell.material", (Object)"BELL");
        shopConfig.set("items.bell.price", (Object)15);
        shopConfig.set("items.bell.sellPrice", (Object)4);
        shopConfig.set("items.bell.amount", (Object)1);
        shopConfig.set("items.bell.slot", (Object)34);
        shopConfig.set("items.bell.page", (Object)2);
        shopConfig.set("items.bell.category", (Object)"Redstone");
        shopConfig.set("items.noteblock.material", (Object)"NOTE_BLOCK");
        shopConfig.set("items.noteblock.price", (Object)20);
        shopConfig.set("items.noteblock.sellPrice", (Object)5);
        shopConfig.set("items.noteblock.amount", (Object)1);
        shopConfig.set("items.noteblock.slot", (Object)10);
        shopConfig.set("items.noteblock.page", (Object)3);
        shopConfig.set("items.noteblock.category", (Object)"Redstone");
        shopConfig.set("items.tnt1.material", (Object)"TNT");
        shopConfig.set("items.tnt1.price", (Object)50);
        shopConfig.set("items.tnt1.sellPrice", (Object)12.5);
        shopConfig.set("items.tnt1.amount", (Object)1);
        shopConfig.set("items.tnt1.slot", (Object)12);
        shopConfig.set("items.tnt1.page", (Object)3);
        shopConfig.set("items.tnt1.category", (Object)"Redstone");
        shopConfig.set("items.lightningrod.material", (Object)"LIGHTNING_ROD");
        shopConfig.set("items.lightningrod.price", (Object)15);
        shopConfig.set("items.lightningrod.sellPrice", (Object)3.5);
        shopConfig.set("items.lightningrod.amount", (Object)1);
        shopConfig.set("items.lightningrod.slot", (Object)14);
        shopConfig.set("items.lightningrod.page", (Object)3);
        shopConfig.set("items.lightningrod.category", (Object)"Redstone");
        shopConfig.set("items.sculksensor.material", (Object)"SCULK_SENSOR");
        shopConfig.set("items.sculksensor.price", (Object)80);
        shopConfig.set("items.sculksensor.sellPrice", (Object)20);
        shopConfig.set("items.sculksensor.amount", (Object)1);
        shopConfig.set("items.sculksensor.slot", (Object)16);
        shopConfig.set("items.sculksensor.page", (Object)3);
        shopConfig.set("items.sculksensor.category", (Object)"Redstone");
        shopConfig.set("items.minecart.material", (Object)"MINECART");
        shopConfig.set("items.minecart.price", (Object)25);
        shopConfig.set("items.minecart.sellPrice", (Object)6);
        shopConfig.set("items.minecart.amount", (Object)1);
        shopConfig.set("items.minecart.slot", (Object)19);
        shopConfig.set("items.minecart.page", (Object)3);
        shopConfig.set("items.minecart.category", (Object)"Redstone");
        shopConfig.set("items.furnaceminecart.material", (Object)"FURNACE_MINECART");
        shopConfig.set("items.furnaceminecart.price", (Object)30);
        shopConfig.set("items.furnaceminecart.sellPrice", (Object)7);
        shopConfig.set("items.furnaceminecart.amount", (Object)1);
        shopConfig.set("items.furnaceminecart.slot", (Object)21);
        shopConfig.set("items.furnaceminecart.page", (Object)3);
        shopConfig.set("items.furnaceminecart.category", (Object)"Redstone");
        shopConfig.set("items.chestminecart.material", (Object)"CHEST_MINECART");
        shopConfig.set("items.chestminecart.price", (Object)32);
        shopConfig.set("items.chestminecart.sellPrice", (Object)8);
        shopConfig.set("items.chestminecart.amount", (Object)1);
        shopConfig.set("items.chestminecart.slot", (Object)23);
        shopConfig.set("items.chestminecart.page", (Object)3);
        shopConfig.set("items.chestminecart.category", (Object)"Redstone");
        shopConfig.set("items.hopperminecart.material", (Object)"HOPPER_MINECART");
        shopConfig.set("items.hopperminecart.price", (Object)45);
        shopConfig.set("items.hopperminecart.sellPrice", (Object)11);
        shopConfig.set("items.hopperminecart.amount", (Object)1);
        shopConfig.set("items.hopperminecart.slot", (Object)25);
        shopConfig.set("items.hopperminecart.page", (Object)3);
        shopConfig.set("items.hopperminecart.category", (Object)"Redstone");
        shopConfig.set("items.oaklog.material", (Object)"OAK_LOG");
        shopConfig.set("items.oaklog.price", (Object)12);
        shopConfig.set("items.oaklog.sellPrice", (Object)3);
        shopConfig.set("items.oaklog.amount", (Object)1);
        shopConfig.set("items.oaklog.slot", (Object)10);
        shopConfig.set("items.oaklog.page", (Object)1);
        shopConfig.set("items.oaklog.category", (Object)"Wood");
        shopConfig.set("items.strippedoaklog.material", (Object)"STRIPPED_OAK_LOG");
        shopConfig.set("items.strippedoaklog.price", (Object)13);
        shopConfig.set("items.strippedoaklog.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedoaklog.amount", (Object)1);
        shopConfig.set("items.strippedoaklog.slot", (Object)12);
        shopConfig.set("items.strippedoaklog.page", (Object)1);
        shopConfig.set("items.strippedoaklog.category", (Object)"Wood");
        shopConfig.set("items.oakwood.material", (Object)"OAK_WOOD");
        shopConfig.set("items.oakwood.price", (Object)12);
        shopConfig.set("items.oakwood.sellPrice", (Object)3);
        shopConfig.set("items.oakwood.amount", (Object)1);
        shopConfig.set("items.oakwood.slot", (Object)14);
        shopConfig.set("items.oakwood.page", (Object)1);
        shopConfig.set("items.oakwood.category", (Object)"Wood");
        shopConfig.set("items.strippedoakwood.material", (Object)"STRIPPED_OAK_WOOD");
        shopConfig.set("items.strippedoakwood.price", (Object)13);
        shopConfig.set("items.strippedoakwood.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedoakwood.amount", (Object)1);
        shopConfig.set("items.strippedoakwood.slot", (Object)16);
        shopConfig.set("items.strippedoakwood.page", (Object)1);
        shopConfig.set("items.strippedoakwood.category", (Object)"Wood");
        shopConfig.set("items.oakplanks.material", (Object)"OAK_PLANKS");
        shopConfig.set("items.oakplanks.price", (Object)4);
        shopConfig.set("items.oakplanks.sellPrice", (Object)1);
        shopConfig.set("items.oakplanks.amount", (Object)1);
        shopConfig.set("items.oakplanks.slot", (Object)19);
        shopConfig.set("items.oakplanks.page", (Object)1);
        shopConfig.set("items.oakplanks.category", (Object)"Wood");
        shopConfig.set("items.oakslab.material", (Object)"OAK_SLAB");
        shopConfig.set("items.oakslab.price", (Object)2);
        shopConfig.set("items.oakslab.sellPrice", (Object)0.5);
        shopConfig.set("items.oakslab.amount", (Object)1);
        shopConfig.set("items.oakslab.slot", (Object)21);
        shopConfig.set("items.oakslab.page", (Object)1);
        shopConfig.set("items.oakslab.category", (Object)"Wood");
        shopConfig.set("items.oakstairs.material", (Object)"OAK_STAIRS");
        shopConfig.set("items.oakstairs.price", (Object)5);
        shopConfig.set("items.oakstairs.sellPrice", (Object)1.25);
        shopConfig.set("items.oakstairs.amount", (Object)1);
        shopConfig.set("items.oakstairs.slot", (Object)23);
        shopConfig.set("items.oakstairs.page", (Object)1);
        shopConfig.set("items.oakstairs.category", (Object)"Wood");
        shopConfig.set("items.oakfence.material", (Object)"OAK_FENCE");
        shopConfig.set("items.oakfence.price", (Object)4);
        shopConfig.set("items.oakfence.sellPrice", (Object)1);
        shopConfig.set("items.oakfence.amount", (Object)1);
        shopConfig.set("items.oakfence.slot", (Object)25);
        shopConfig.set("items.oakfence.page", (Object)1);
        shopConfig.set("items.oakfence.category", (Object)"Wood");
        shopConfig.set("items.oakfencegate.material", (Object)"OAK_FENCE_GATE");
        shopConfig.set("items.oakfencegate.price", (Object)6);
        shopConfig.set("items.oakfencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.oakfencegate.amount", (Object)1);
        shopConfig.set("items.oakfencegate.slot", (Object)28);
        shopConfig.set("items.oakfencegate.page", (Object)1);
        shopConfig.set("items.oakfencegate.category", (Object)"Wood");
        shopConfig.set("items.oakdoor.material", (Object)"OAK_DOOR");
        shopConfig.set("items.oakdoor.price", (Object)5);
        shopConfig.set("items.oakdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.oakdoor.amount", (Object)1);
        shopConfig.set("items.oakdoor.slot", (Object)30);
        shopConfig.set("items.oakdoor.page", (Object)1);
        shopConfig.set("items.oakdoor.category", (Object)"Wood");
        shopConfig.set("items.oaktrapdoor.material", (Object)"OAK_TRAPDOOR");
        shopConfig.set("items.oaktrapdoor.price", (Object)5);
        shopConfig.set("items.oaktrapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.oaktrapdoor.amount", (Object)1);
        shopConfig.set("items.oaktrapdoor.slot", (Object)32);
        shopConfig.set("items.oaktrapdoor.page", (Object)1);
        shopConfig.set("items.oaktrapdoor.category", (Object)"Wood");
        shopConfig.set("items.oakbutton.material", (Object)"OAK_BUTTON");
        shopConfig.set("items.oakbutton.price", (Object)1);
        shopConfig.set("items.oakbutton.sellPrice", (Object)0.25);
        shopConfig.set("items.oakbutton.amount", (Object)1);
        shopConfig.set("items.oakbutton.slot", (Object)34);
        shopConfig.set("items.oakbutton.page", (Object)1);
        shopConfig.set("items.oakbutton.category", (Object)"Wood");
        shopConfig.set("items.sprucelog.material", (Object)"SPRUCE_LOG");
        shopConfig.set("items.sprucelog.price", (Object)12);
        shopConfig.set("items.sprucelog.sellPrice", (Object)3);
        shopConfig.set("items.sprucelog.amount", (Object)1);
        shopConfig.set("items.sprucelog.slot", (Object)10);
        shopConfig.set("items.sprucelog.page", (Object)2);
        shopConfig.set("items.sprucelog.category", (Object)"Wood");
        shopConfig.set("items.strippedsprucelog.material", (Object)"STRIPPED_SPRUCE_LOG");
        shopConfig.set("items.strippedsprucelog.price", (Object)13);
        shopConfig.set("items.strippedsprucelog.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedsprucelog.amount", (Object)1);
        shopConfig.set("items.strippedsprucelog.slot", (Object)12);
        shopConfig.set("items.strippedsprucelog.page", (Object)2);
        shopConfig.set("items.strippedsprucelog.category", (Object)"Wood");
        shopConfig.set("items.sprucewood.material", (Object)"SPRUCE_WOOD");
        shopConfig.set("items.sprucewood.price", (Object)12);
        shopConfig.set("items.sprucewood.sellPrice", (Object)3);
        shopConfig.set("items.sprucewood.amount", (Object)1);
        shopConfig.set("items.sprucewood.slot", (Object)14);
        shopConfig.set("items.sprucewood.page", (Object)2);
        shopConfig.set("items.sprucewood.category", (Object)"Wood");
        shopConfig.set("items.strippedsprucewood.material", (Object)"STRIPPED_SPRUCE_WOOD");
        shopConfig.set("items.strippedsprucewood.price", (Object)13);
        shopConfig.set("items.strippedsprucewood.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedsprucewood.amount", (Object)1);
        shopConfig.set("items.strippedsprucewood.slot", (Object)16);
        shopConfig.set("items.strippedsprucewood.page", (Object)2);
        shopConfig.set("items.strippedsprucewood.category", (Object)"Wood");
        shopConfig.set("items.spruceplanks.material", (Object)"SPRUCE_PLANKS");
        shopConfig.set("items.spruceplanks.price", (Object)4);
        shopConfig.set("items.spruceplanks.sellPrice", (Object)1);
        shopConfig.set("items.spruceplanks.amount", (Object)1);
        shopConfig.set("items.spruceplanks.slot", (Object)19);
        shopConfig.set("items.spruceplanks.page", (Object)2);
        shopConfig.set("items.spruceplanks.category", (Object)"Wood");
        shopConfig.set("items.spruceslab.material", (Object)"SPRUCE_SLAB");
        shopConfig.set("items.spruceslab.price", (Object)2);
        shopConfig.set("items.spruceslab.sellPrice", (Object)0.5);
        shopConfig.set("items.spruceslab.amount", (Object)1);
        shopConfig.set("items.spruceslab.slot", (Object)21);
        shopConfig.set("items.spruceslab.page", (Object)2);
        shopConfig.set("items.spruceslab.category", (Object)"Wood");
        shopConfig.set("items.sprucestairs.material", (Object)"SPRUCE_STAIRS");
        shopConfig.set("items.sprucestairs.price", (Object)5);
        shopConfig.set("items.sprucestairs.sellPrice", (Object)1.25);
        shopConfig.set("items.sprucestairs.amount", (Object)1);
        shopConfig.set("items.sprucestairs.slot", (Object)23);
        shopConfig.set("items.sprucestairs.page", (Object)2);
        shopConfig.set("items.sprucestairs.category", (Object)"Wood");
        shopConfig.set("items.sprucefence.material", (Object)"SPRUCE_FENCE");
        shopConfig.set("items.sprucefence.price", (Object)4);
        shopConfig.set("items.sprucefence.sellPrice", (Object)1);
        shopConfig.set("items.sprucefence.amount", (Object)1);
        shopConfig.set("items.sprucefence.slot", (Object)25);
        shopConfig.set("items.sprucefence.page", (Object)2);
        shopConfig.set("items.sprucefence.category", (Object)"Wood");
        shopConfig.set("items.sprucefencegate.material", (Object)"SPRUCE_FENCE_GATE");
        shopConfig.set("items.sprucefencegate.price", (Object)6);
        shopConfig.set("items.sprucefencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.sprucefencegate.amount", (Object)1);
        shopConfig.set("items.sprucefencegate.slot", (Object)28);
        shopConfig.set("items.sprucefencegate.page", (Object)2);
        shopConfig.set("items.sprucefencegate.category", (Object)"Wood");
        shopConfig.set("items.sprucedoor.material", (Object)"SPRUCE_DOOR");
        shopConfig.set("items.sprucedoor.price", (Object)5);
        shopConfig.set("items.sprucedoor.sellPrice", (Object)1.25);
        shopConfig.set("items.sprucedoor.amount", (Object)1);
        shopConfig.set("items.sprucedoor.slot", (Object)30);
        shopConfig.set("items.sprucedoor.page", (Object)2);
        shopConfig.set("items.sprucedoor.category", (Object)"Wood");
        shopConfig.set("items.sprucetrapdoor.material", (Object)"SPRUCE_TRAPDOOR");
        shopConfig.set("items.sprucetrapdoor.price", (Object)5);
        shopConfig.set("items.sprucetrapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.sprucetrapdoor.amount", (Object)1);
        shopConfig.set("items.sprucetrapdoor.slot", (Object)32);
        shopConfig.set("items.sprucetrapdoor.page", (Object)2);
        shopConfig.set("items.sprucetrapdoor.category", (Object)"Wood");
        shopConfig.set("items.sprucebutton.material", (Object)"SPRUCE_BUTTON");
        shopConfig.set("items.sprucebutton.price", (Object)1);
        shopConfig.set("items.sprucebutton.sellPrice", (Object)0.25);
        shopConfig.set("items.sprucebutton.amount", (Object)1);
        shopConfig.set("items.sprucebutton.slot", (Object)34);
        shopConfig.set("items.sprucebutton.page", (Object)2);
        shopConfig.set("items.sprucebutton.category", (Object)"Wood");
        shopConfig.set("items.birchlog.material", (Object)"BIRCH_LOG");
        shopConfig.set("items.birchlog.price", (Object)12);
        shopConfig.set("items.birchlog.sellPrice", (Object)3);
        shopConfig.set("items.birchlog.amount", (Object)1);
        shopConfig.set("items.birchlog.slot", (Object)10);
        shopConfig.set("items.birchlog.page", (Object)3);
        shopConfig.set("items.birchlog.category", (Object)"Wood");
        shopConfig.set("items.strippedbirchlog.material", (Object)"STRIPPED_BIRCH_LOG");
        shopConfig.set("items.strippedbirchlog.price", (Object)13);
        shopConfig.set("items.strippedbirchlog.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedbirchlog.amount", (Object)1);
        shopConfig.set("items.strippedbirchlog.slot", (Object)12);
        shopConfig.set("items.strippedbirchlog.page", (Object)3);
        shopConfig.set("items.strippedbirchlog.category", (Object)"Wood");
        shopConfig.set("items.birchwood.material", (Object)"BIRCH_WOOD");
        shopConfig.set("items.birchwood.price", (Object)12);
        shopConfig.set("items.birchwood.sellPrice", (Object)3);
        shopConfig.set("items.birchwood.amount", (Object)1);
        shopConfig.set("items.birchwood.slot", (Object)14);
        shopConfig.set("items.birchwood.page", (Object)3);
        shopConfig.set("items.birchwood.category", (Object)"Wood");
        shopConfig.set("items.strippedbirchwood.material", (Object)"STRIPPED_BIRCH_WOOD");
        shopConfig.set("items.strippedbirchwood.price", (Object)13);
        shopConfig.set("items.strippedbirchwood.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedbirchwood.amount", (Object)1);
        shopConfig.set("items.strippedbirchwood.slot", (Object)16);
        shopConfig.set("items.strippedbirchwood.page", (Object)3);
        shopConfig.set("items.strippedbirchwood.category", (Object)"Wood");
        shopConfig.set("items.birchplanks.material", (Object)"BIRCH_PLANKS");
        shopConfig.set("items.birchplanks.price", (Object)4);
        shopConfig.set("items.birchplanks.sellPrice", (Object)1);
        shopConfig.set("items.birchplanks.amount", (Object)1);
        shopConfig.set("items.birchplanks.slot", (Object)19);
        shopConfig.set("items.birchplanks.page", (Object)3);
        shopConfig.set("items.birchplanks.category", (Object)"Wood");
        shopConfig.set("items.birchslab.material", (Object)"BIRCH_SLAB");
        shopConfig.set("items.birchslab.price", (Object)2);
        shopConfig.set("items.birchslab.sellPrice", (Object)0.5);
        shopConfig.set("items.birchslab.amount", (Object)1);
        shopConfig.set("items.birchslab.slot", (Object)21);
        shopConfig.set("items.birchslab.page", (Object)3);
        shopConfig.set("items.birchslab.category", (Object)"Wood");
        shopConfig.set("items.birchstairs.material", (Object)"BIRCH_STAIRS");
        shopConfig.set("items.birchstairs.price", (Object)5);
        shopConfig.set("items.birchstairs.sellPrice", (Object)1.25);
        shopConfig.set("items.birchstairs.amount", (Object)1);
        shopConfig.set("items.birchstairs.slot", (Object)23);
        shopConfig.set("items.birchstairs.page", (Object)3);
        shopConfig.set("items.birchstairs.category", (Object)"Wood");
        shopConfig.set("items.birchfence.material", (Object)"BIRCH_FENCE");
        shopConfig.set("items.birchfence.price", (Object)4);
        shopConfig.set("items.birchfence.sellPrice", (Object)1);
        shopConfig.set("items.birchfence.amount", (Object)1);
        shopConfig.set("items.birchfence.slot", (Object)25);
        shopConfig.set("items.birchfence.page", (Object)3);
        shopConfig.set("items.birchfence.category", (Object)"Wood");
        shopConfig.set("items.birchfencegate.material", (Object)"BIRCH_FENCE_GATE");
        shopConfig.set("items.birchfencegate.price", (Object)6);
        shopConfig.set("items.birchfencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.birchfencegate.amount", (Object)1);
        shopConfig.set("items.birchfencegate.slot", (Object)28);
        shopConfig.set("items.birchfencegate.page", (Object)3);
        shopConfig.set("items.birchfencegate.category", (Object)"Wood");
        shopConfig.set("items.birchdoor.material", (Object)"BIRCH_DOOR");
        shopConfig.set("items.birchdoor.price", (Object)5);
        shopConfig.set("items.birchdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.birchdoor.amount", (Object)1);
        shopConfig.set("items.birchdoor.slot", (Object)30);
        shopConfig.set("items.birchdoor.page", (Object)3);
        shopConfig.set("items.birchdoor.category", (Object)"Wood");
        shopConfig.set("items.birchtrapdoor.material", (Object)"BIRCH_TRAPDOOR");
        shopConfig.set("items.birchtrapdoor.price", (Object)5);
        shopConfig.set("items.birchtrapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.birchtrapdoor.amount", (Object)1);
        shopConfig.set("items.birchtrapdoor.slot", (Object)32);
        shopConfig.set("items.birchtrapdoor.page", (Object)3);
        shopConfig.set("items.birchtrapdoor.category", (Object)"Wood");
        shopConfig.set("items.birchbutton.material", (Object)"BIRCH_BUTTON");
        shopConfig.set("items.birchbutton.price", (Object)1);
        shopConfig.set("items.birchbutton.sellPrice", (Object)0.25);
        shopConfig.set("items.birchbutton.amount", (Object)1);
        shopConfig.set("items.birchbutton.slot", (Object)34);
        shopConfig.set("items.birchbutton.page", (Object)3);
        shopConfig.set("items.birchbutton.category", (Object)"Wood");
        shopConfig.set("items.junglelog.material", (Object)"JUNGLE_LOG");
        shopConfig.set("items.junglelog.price", (Object)12);
        shopConfig.set("items.junglelog.sellPrice", (Object)3);
        shopConfig.set("items.junglelog.amount", (Object)1);
        shopConfig.set("items.junglelog.slot", (Object)10);
        shopConfig.set("items.junglelog.page", (Object)4);
        shopConfig.set("items.junglelog.category", (Object)"Wood");
        shopConfig.set("items.strippedjunglelog.material", (Object)"STRIPPED_JUNGLE_LOG");
        shopConfig.set("items.strippedjunglelog.price", (Object)13);
        shopConfig.set("items.strippedjunglelog.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedjunglelog.amount", (Object)1);
        shopConfig.set("items.strippedjunglelog.slot", (Object)12);
        shopConfig.set("items.strippedjunglelog.page", (Object)4);
        shopConfig.set("items.strippedjunglelog.category", (Object)"Wood");
        shopConfig.set("items.junglewood.material", (Object)"JUNGLE_WOOD");
        shopConfig.set("items.junglewood.price", (Object)12);
        shopConfig.set("items.junglewood.sellPrice", (Object)3);
        shopConfig.set("items.junglewood.amount", (Object)1);
        shopConfig.set("items.junglewood.slot", (Object)14);
        shopConfig.set("items.junglewood.page", (Object)4);
        shopConfig.set("items.junglewood.category", (Object)"Wood");
        shopConfig.set("items.strippedjunglewood.material", (Object)"STRIPPED_JUNGLE_WOOD");
        shopConfig.set("items.strippedjunglewood.price", (Object)13);
        shopConfig.set("items.strippedjunglewood.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedjunglewood.amount", (Object)1);
        shopConfig.set("items.strippedjunglewood.slot", (Object)16);
        shopConfig.set("items.strippedjunglewood.page", (Object)4);
        shopConfig.set("items.strippedjunglewood.category", (Object)"Wood");
        shopConfig.set("items.jungleplanks.material", (Object)"JUNGLE_PLANKS");
        shopConfig.set("items.jungleplanks.price", (Object)4);
        shopConfig.set("items.jungleplanks.sellPrice", (Object)1);
        shopConfig.set("items.jungleplanks.amount", (Object)1);
        shopConfig.set("items.jungleplanks.slot", (Object)19);
        shopConfig.set("items.jungleplanks.page", (Object)4);
        shopConfig.set("items.jungleplanks.category", (Object)"Wood");
        shopConfig.set("items.jungleslab.material", (Object)"JUNGLE_SLAB");
        shopConfig.set("items.jungleslab.price", (Object)2);
        shopConfig.set("items.jungleslab.sellPrice", (Object)0.5);
        shopConfig.set("items.jungleslab.amount", (Object)1);
        shopConfig.set("items.jungleslab.slot", (Object)21);
        shopConfig.set("items.jungleslab.page", (Object)4);
        shopConfig.set("items.jungleslab.category", (Object)"Wood");
        shopConfig.set("items.junglestairs.material", (Object)"JUNGLE_STAIRS");
        shopConfig.set("items.junglestairs.price", (Object)5);
        shopConfig.set("items.junglestairs.sellPrice", (Object)1.25);
        shopConfig.set("items.junglestairs.amount", (Object)1);
        shopConfig.set("items.junglestairs.slot", (Object)23);
        shopConfig.set("items.junglestairs.page", (Object)4);
        shopConfig.set("items.junglestairs.category", (Object)"Wood");
        shopConfig.set("items.junglefence.material", (Object)"JUNGLE_FENCE");
        shopConfig.set("items.junglefence.price", (Object)4);
        shopConfig.set("items.junglefence.sellPrice", (Object)1);
        shopConfig.set("items.junglefence.amount", (Object)1);
        shopConfig.set("items.junglefence.slot", (Object)25);
        shopConfig.set("items.junglefence.page", (Object)4);
        shopConfig.set("items.junglefence.category", (Object)"Wood");
        shopConfig.set("items.junglefencegate.material", (Object)"JUNGLE_FENCE_GATE");
        shopConfig.set("items.junglefencegate.price", (Object)6);
        shopConfig.set("items.junglefencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.junglefencegate.amount", (Object)1);
        shopConfig.set("items.junglefencegate.slot", (Object)28);
        shopConfig.set("items.junglefencegate.page", (Object)4);
        shopConfig.set("items.junglefencegate.category", (Object)"Wood");
        shopConfig.set("items.jungledoor.material", (Object)"JUNGLE_DOOR");
        shopConfig.set("items.jungledoor.price", (Object)5);
        shopConfig.set("items.jungledoor.sellPrice", (Object)1.25);
        shopConfig.set("items.jungledoor.amount", (Object)1);
        shopConfig.set("items.jungledoor.slot", (Object)30);
        shopConfig.set("items.jungledoor.page", (Object)4);
        shopConfig.set("items.jungledoor.category", (Object)"Wood");
        shopConfig.set("items.jungletrapdoor.material", (Object)"JUNGLE_TRAPDOOR");
        shopConfig.set("items.jungletrapdoor.price", (Object)5);
        shopConfig.set("items.jungletrapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.jungletrapdoor.amount", (Object)1);
        shopConfig.set("items.jungletrapdoor.slot", (Object)32);
        shopConfig.set("items.jungletrapdoor.page", (Object)4);
        shopConfig.set("items.jungletrapdoor.category", (Object)"Wood");
        shopConfig.set("items.junglebutton.material", (Object)"JUNGLE_BUTTON");
        shopConfig.set("items.junglebutton.price", (Object)1);
        shopConfig.set("items.junglebutton.sellPrice", (Object)0.25);
        shopConfig.set("items.junglebutton.amount", (Object)1);
        shopConfig.set("items.junglebutton.slot", (Object)34);
        shopConfig.set("items.junglebutton.page", (Object)4);
        shopConfig.set("items.junglebutton.category", (Object)"Wood");
        shopConfig.set("items.acacialog.material", (Object)"ACACIA_LOG");
        shopConfig.set("items.acacialog.price", (Object)12);
        shopConfig.set("items.acacialog.sellPrice", (Object)3);
        shopConfig.set("items.acacialog.amount", (Object)1);
        shopConfig.set("items.acacialog.slot", (Object)10);
        shopConfig.set("items.acacialog.page", (Object)5);
        shopConfig.set("items.acacialog.category", (Object)"Wood");
        shopConfig.set("items.strippedacacialog.material", (Object)"STRIPPED_ACACIA_LOG");
        shopConfig.set("items.strippedacacialog.price", (Object)13);
        shopConfig.set("items.strippedacacialog.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedacacialog.amount", (Object)1);
        shopConfig.set("items.strippedacacialog.slot", (Object)12);
        shopConfig.set("items.strippedacacialog.page", (Object)5);
        shopConfig.set("items.strippedacacialog.category", (Object)"Wood");
        shopConfig.set("items.acaciawood.material", (Object)"ACACIA_WOOD");
        shopConfig.set("items.acaciawood.price", (Object)12);
        shopConfig.set("items.acaciawood.sellPrice", (Object)3);
        shopConfig.set("items.acaciawood.amount", (Object)1);
        shopConfig.set("items.acaciawood.slot", (Object)14);
        shopConfig.set("items.acaciawood.page", (Object)5);
        shopConfig.set("items.acaciawood.category", (Object)"Wood");
        shopConfig.set("items.strippedacaciawood.material", (Object)"STRIPPED_ACACIA_WOOD");
        shopConfig.set("items.strippedacaciawood.price", (Object)13);
        shopConfig.set("items.strippedacaciawood.sellPrice", (Object)3.5);
        shopConfig.set("items.strippedacaciawood.amount", (Object)1);
        shopConfig.set("items.strippedacaciawood.slot", (Object)16);
        shopConfig.set("items.strippedacaciawood.page", (Object)5);
        shopConfig.set("items.strippedacaciawood.category", (Object)"Wood");
        shopConfig.set("items.acaciaplanks.material", (Object)"ACACIA_PLANKS");
        shopConfig.set("items.acaciaplanks.price", (Object)4);
        shopConfig.set("items.acaciaplanks.sellPrice", (Object)1);
        shopConfig.set("items.acaciaplanks.amount", (Object)1);
        shopConfig.set("items.acaciaplanks.slot", (Object)19);
        shopConfig.set("items.acaciaplanks.page", (Object)5);
        shopConfig.set("items.acaciaplanks.category", (Object)"Wood");
        shopConfig.set("items.acaciaslab.material", (Object)"ACACIA_SLAB");
        shopConfig.set("items.acaciaslab.price", (Object)2);
        shopConfig.set("items.acaciaslab.sellPrice", (Object)0.5);
        shopConfig.set("items.acaciaslab.amount", (Object)1);
        shopConfig.set("items.acaciaslab.slot", (Object)21);
        shopConfig.set("items.acaciaslab.page", (Object)5);
        shopConfig.set("items.acaciaslab.category", (Object)"Wood");
        shopConfig.set("items.acaciastairs.material", (Object)"ACACIA_STAIRS");
        shopConfig.set("items.acaciastairs.price", (Object)5);
        shopConfig.set("items.acaciastairs.sellPrice", (Object)1.25);
        shopConfig.set("items.acaciastairs.amount", (Object)1);
        shopConfig.set("items.acaciastairs.slot", (Object)23);
        shopConfig.set("items.acaciastairs.page", (Object)5);
        shopConfig.set("items.acaciastairs.category", (Object)"Wood");
        shopConfig.set("items.acaciafence.material", (Object)"ACACIA_FENCE");
        shopConfig.set("items.acaciafence.price", (Object)4);
        shopConfig.set("items.acaciafence.sellPrice", (Object)1);
        shopConfig.set("items.acaciafence.amount", (Object)1);
        shopConfig.set("items.acaciafence.slot", (Object)25);
        shopConfig.set("items.acaciafence.page", (Object)5);
        shopConfig.set("items.acaciafence.category", (Object)"Wood");
        shopConfig.set("items.acaciafencegate.material", (Object)"ACACIA_FENCE_GATE");
        shopConfig.set("items.acaciafencegate.price", (Object)6);
        shopConfig.set("items.acaciafencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.acaciafencegate.amount", (Object)1);
        shopConfig.set("items.acaciafencegate.slot", (Object)28);
        shopConfig.set("items.acaciafencegate.page", (Object)5);
        shopConfig.set("items.acaciafencegate.category", (Object)"Wood");
        shopConfig.set("items.acaciadoor.material", (Object)"ACACIA_DOOR");
        shopConfig.set("items.acaciadoor.price", (Object)5);
        shopConfig.set("items.acaciadoor.sellPrice", (Object)1.25);
        shopConfig.set("items.acaciadoor.amount", (Object)1);
        shopConfig.set("items.acaciadoor.slot", (Object)30);
        shopConfig.set("items.acaciadoor.page", (Object)5);
        shopConfig.set("items.acaciadoor.category", (Object)"Wood");
        shopConfig.set("items.acaciatrapdoor.material", (Object)"ACACIA_TRAPDOOR");
        shopConfig.set("items.acaciatrapdoor.price", (Object)5);
        shopConfig.set("items.acaciatrapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.acaciatrapdoor.amount", (Object)1);
        shopConfig.set("items.acaciatrapdoor.slot", (Object)32);
        shopConfig.set("items.acaciatrapdoor.page", (Object)5);
        shopConfig.set("items.acaciatrapdoor.category", (Object)"Wood");
        shopConfig.set("items.acaciabutton.material", (Object)"ACACIA_BUTTON");
        shopConfig.set("items.acaciabutton.price", (Object)1);
        shopConfig.set("items.acaciabutton.sellPrice", (Object)0.25);
        shopConfig.set("items.acaciabutton.amount", (Object)1);
        shopConfig.set("items.acaciabutton.slot", (Object)34);
        shopConfig.set("items.acaciabutton.page", (Object)5);
        shopConfig.set("items.acaciabutton.category", (Object)"Wood");
        shopConfig.set("items.darkoaklog.material", (Object)"DARK_OAK_LOG");
        shopConfig.set("items.darkoaklog.price", (Object)12);
        shopConfig.set("items.darkoaklog.sellPrice", (Object)3);
        shopConfig.set("items.darkoaklog.amount", (Object)1);
        shopConfig.set("items.darkoaklog.slot", (Object)10);
        shopConfig.set("items.darkoaklog.page", (Object)6);
        shopConfig.set("items.darkoaklog.category", (Object)"Wood");
        shopConfig.set("items.strippeddarkoaklog.material", (Object)"STRIPPED_DARK_OAK_LOG");
        shopConfig.set("items.strippeddarkoaklog.price", (Object)13);
        shopConfig.set("items.strippeddarkoaklog.sellPrice", (Object)3.5);
        shopConfig.set("items.strippeddarkoaklog.amount", (Object)1);
        shopConfig.set("items.strippeddarkoaklog.slot", (Object)12);
        shopConfig.set("items.strippeddarkoaklog.page", (Object)6);
        shopConfig.set("items.strippeddarkoaklog.category", (Object)"Wood");
        shopConfig.set("items.darkoakwood.material", (Object)"DARK_OAK_WOOD");
        shopConfig.set("items.darkoakwood.price", (Object)12);
        shopConfig.set("items.darkoakwood.sellPrice", (Object)3);
        shopConfig.set("items.darkoakwood.amount", (Object)1);
        shopConfig.set("items.darkoakwood.slot", (Object)14);
        shopConfig.set("items.darkoakwood.page", (Object)6);
        shopConfig.set("items.darkoakwood.category", (Object)"Wood");
        shopConfig.set("items.strippeddarkoakwood.material", (Object)"STRIPPED_DARK_OAK_WOOD");
        shopConfig.set("items.strippeddarkoakwood.price", (Object)13);
        shopConfig.set("items.strippeddarkoakwood.sellPrice", (Object)3.5);
        shopConfig.set("items.strippeddarkoakwood.amount", (Object)1);
        shopConfig.set("items.strippeddarkoakwood.slot", (Object)16);
        shopConfig.set("items.strippeddarkoakwood.page", (Object)6);
        shopConfig.set("items.strippeddarkoakwood.category", (Object)"Wood");
        shopConfig.set("items.darkoakplanks.material", (Object)"DARK_OAK_PLANKS");
        shopConfig.set("items.darkoakplanks.price", (Object)4);
        shopConfig.set("items.darkoakplanks.sellPrice", (Object)1);
        shopConfig.set("items.darkoakplanks.amount", (Object)1);
        shopConfig.set("items.darkoakplanks.slot", (Object)19);
        shopConfig.set("items.darkoakplanks.page", (Object)6);
        shopConfig.set("items.darkoakplanks.category", (Object)"Wood");
        shopConfig.set("items.darkoakslab.material", (Object)"DARK_OAK_SLAB");
        shopConfig.set("items.darkoakslab.price", (Object)2);
        shopConfig.set("items.darkoakslab.sellPrice", (Object)0.5);
        shopConfig.set("items.darkoakslab.amount", (Object)1);
        shopConfig.set("items.darkoakslab.slot", (Object)21);
        shopConfig.set("items.darkoakslab.page", (Object)6);
        shopConfig.set("items.darkoakslab.category", (Object)"Wood");
        shopConfig.set("items.darkoakstairs.material", (Object)"DARK_OAK_STAIRS");
        shopConfig.set("items.darkoakstairs.price", (Object)5);
        shopConfig.set("items.darkoakstairs.sellPrice", (Object)1.25);
        shopConfig.set("items.darkoakstairs.amount", (Object)1);
        shopConfig.set("items.darkoakstairs.slot", (Object)23);
        shopConfig.set("items.darkoakstairs.page", (Object)6);
        shopConfig.set("items.darkoakstairs.category", (Object)"Wood");
        shopConfig.set("items.darkoakfence.material", (Object)"DARK_OAK_FENCE");
        shopConfig.set("items.darkoakfence.price", (Object)4);
        shopConfig.set("items.darkoakfence.sellPrice", (Object)1);
        shopConfig.set("items.darkoakfence.amount", (Object)1);
        shopConfig.set("items.darkoakfence.slot", (Object)25);
        shopConfig.set("items.darkoakfence.page", (Object)6);
        shopConfig.set("items.darkoakfence.category", (Object)"Wood");
        shopConfig.set("items.darkoakfencegate.material", (Object)"DARK_OAK_FENCE_GATE");
        shopConfig.set("items.darkoakfencegate.price", (Object)6);
        shopConfig.set("items.darkoakfencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.darkoakfencegate.amount", (Object)1);
        shopConfig.set("items.darkoakfencegate.slot", (Object)28);
        shopConfig.set("items.darkoakfencegate.page", (Object)6);
        shopConfig.set("items.darkoakfencegate.category", (Object)"Wood");
        shopConfig.set("items.darkoakdoor.material", (Object)"DARK_OAK_DOOR");
        shopConfig.set("items.darkoakdoor.price", (Object)5);
        shopConfig.set("items.darkoakdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.darkoakdoor.amount", (Object)1);
        shopConfig.set("items.darkoakdoor.slot", (Object)30);
        shopConfig.set("items.darkoakdoor.page", (Object)6);
        shopConfig.set("items.darkoakdoor.category", (Object)"Wood");
        shopConfig.set("items.darkoaktrapdoor.material", (Object)"DARK_OAK_TRAPDOOR");
        shopConfig.set("items.darkoaktrapdoor.price", (Object)5);
        shopConfig.set("items.darkoaktrapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.darkoaktrapdoor.amount", (Object)1);
        shopConfig.set("items.darkoaktrapdoor.slot", (Object)32);
        shopConfig.set("items.darkoaktrapdoor.page", (Object)6);
        shopConfig.set("items.darkoaktrapdoor.category", (Object)"Wood");
        shopConfig.set("items.darkoakbutton.material", (Object)"DARK_OAK_BUTTON");
        shopConfig.set("items.darkoakbutton.price", (Object)1);
        shopConfig.set("items.darkoakbutton.sellPrice", (Object)0.25);
        shopConfig.set("items.darkoakbutton.amount", (Object)1);
        shopConfig.set("items.darkoakbutton.slot", (Object)34);
        shopConfig.set("items.darkoakbutton.page", (Object)6);
        shopConfig.set("items.darkoakbutton.category", (Object)"Wood");
        shopConfig.set("items.mangrovelog.material", (Object)"MANGROVE_LOG");
        shopConfig.set("items.mangrovelog.price", (Object)14);
        shopConfig.set("items.mangrovelog.sellPrice", (Object)3.5);
        shopConfig.set("items.mangrovelog.amount", (Object)1);
        shopConfig.set("items.mangrovelog.slot", (Object)10);
        shopConfig.set("items.mangrovelog.page", (Object)7);
        shopConfig.set("items.mangrovelog.category", (Object)"Wood");
        shopConfig.set("items.strippedmangrovelog.material", (Object)"STRIPPED_MANGROVE_LOG");
        shopConfig.set("items.strippedmangrovelog.price", (Object)15);
        shopConfig.set("items.strippedmangrovelog.sellPrice", (Object)4);
        shopConfig.set("items.strippedmangrovelog.amount", (Object)1);
        shopConfig.set("items.strippedmangrovelog.slot", (Object)12);
        shopConfig.set("items.strippedmangrovelog.page", (Object)7);
        shopConfig.set("items.strippedmangrovelog.category", (Object)"Wood");
        shopConfig.set("items.mangrovewood.material", (Object)"MANGROVE_WOOD");
        shopConfig.set("items.mangrovewood.price", (Object)14);
        shopConfig.set("items.mangrovewood.sellPrice", (Object)3.5);
        shopConfig.set("items.mangrovewood.amount", (Object)1);
        shopConfig.set("items.mangrovewood.slot", (Object)14);
        shopConfig.set("items.mangrovewood.page", (Object)7);
        shopConfig.set("items.mangrovewood.category", (Object)"Wood");
        shopConfig.set("items.strippedmangrovewood.material", (Object)"STRIPPED_MANGROVE_WOOD");
        shopConfig.set("items.strippedmangrovewood.price", (Object)15);
        shopConfig.set("items.strippedmangrovewood.sellPrice", (Object)4);
        shopConfig.set("items.strippedmangrovewood.amount", (Object)1);
        shopConfig.set("items.strippedmangrovewood.slot", (Object)16);
        shopConfig.set("items.strippedmangrovewood.page", (Object)7);
        shopConfig.set("items.strippedmangrovewood.category", (Object)"Wood");
        shopConfig.set("items.mangroveplanks.material", (Object)"MANGROVE_PLANKS");
        shopConfig.set("items.mangroveplanks.price", (Object)5);
        shopConfig.set("items.mangroveplanks.sellPrice", (Object)1.5);
        shopConfig.set("items.mangroveplanks.amount", (Object)1);
        shopConfig.set("items.mangroveplanks.slot", (Object)19);
        shopConfig.set("items.mangroveplanks.page", (Object)7);
        shopConfig.set("items.mangroveplanks.category", (Object)"Wood");
        shopConfig.set("items.mangroveslab.material", (Object)"MANGROVE_SLAB");
        shopConfig.set("items.mangroveslab.price", (Object)3);
        shopConfig.set("items.mangroveslab.sellPrice", (Object)0.75);
        shopConfig.set("items.mangroveslab.amount", (Object)1);
        shopConfig.set("items.mangroveslab.slot", (Object)21);
        shopConfig.set("items.mangroveslab.page", (Object)7);
        shopConfig.set("items.mangroveslab.category", (Object)"Wood");
        shopConfig.set("items.mangrovestairs.material", (Object)"MANGROVE_STAIRS");
        shopConfig.set("items.mangrovestairs.price", (Object)6);
        shopConfig.set("items.mangrovestairs.sellPrice", (Object)1.5);
        shopConfig.set("items.mangrovestairs.amount", (Object)1);
        shopConfig.set("items.mangrovestairs.slot", (Object)23);
        shopConfig.set("items.mangrovestairs.page", (Object)7);
        shopConfig.set("items.mangrovestairs.category", (Object)"Wood");
        shopConfig.set("items.mangrovefence.material", (Object)"MANGROVE_FENCE");
        shopConfig.set("items.mangrovefence.price", (Object)5);
        shopConfig.set("items.mangrovefence.sellPrice", (Object)1.25);
        shopConfig.set("items.mangrovefence.amount", (Object)1);
        shopConfig.set("items.mangrovefence.slot", (Object)25);
        shopConfig.set("items.mangrovefence.page", (Object)7);
        shopConfig.set("items.mangrovefence.category", (Object)"Wood");
        shopConfig.set("items.mangrovefencegate.material", (Object)"MANGROVE_FENCE_GATE");
        shopConfig.set("items.mangrovefencegate.price", (Object)7);
        shopConfig.set("items.mangrovefencegate.sellPrice", (Object)1.75);
        shopConfig.set("items.mangrovefencegate.amount", (Object)1);
        shopConfig.set("items.mangrovefencegate.slot", (Object)28);
        shopConfig.set("items.mangrovefencegate.page", (Object)7);
        shopConfig.set("items.mangrovefencegate.category", (Object)"Wood");
        shopConfig.set("items.mangrovedoor.material", (Object)"MANGROVE_DOOR");
        shopConfig.set("items.mangrovedoor.price", (Object)6);
        shopConfig.set("items.mangrovedoor.sellPrice", (Object)1.5);
        shopConfig.set("items.mangrovedoor.amount", (Object)1);
        shopConfig.set("items.mangrovedoor.slot", (Object)30);
        shopConfig.set("items.mangrovedoor.page", (Object)7);
        shopConfig.set("items.mangrovedoor.category", (Object)"Wood");
        shopConfig.set("items.mangrovetrapdoor.material", (Object)"MANGROVE_TRAPDOOR");
        shopConfig.set("items.mangrovetrapdoor.price", (Object)6);
        shopConfig.set("items.mangrovetrapdoor.sellPrice", (Object)1.5);
        shopConfig.set("items.mangrovetrapdoor.amount", (Object)1);
        shopConfig.set("items.mangrovetrapdoor.slot", (Object)32);
        shopConfig.set("items.mangrovetrapdoor.page", (Object)7);
        shopConfig.set("items.mangrovetrapdoor.category", (Object)"Wood");
        shopConfig.set("items.mangrovebutton.material", (Object)"MANGROVE_BUTTON");
        shopConfig.set("items.mangrovebutton.price", (Object)2);
        shopConfig.set("items.mangrovebutton.sellPrice", (Object)0.5);
        shopConfig.set("items.mangrovebutton.amount", (Object)1);
        shopConfig.set("items.mangrovebutton.slot", (Object)34);
        shopConfig.set("items.mangrovebutton.page", (Object)7);
        shopConfig.set("items.mangrovebutton.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.log.material", (Object)"CHERRY_LOG");
        shopConfig.set("items.cherrytree.log.price", (Object)16);
        shopConfig.set("items.cherrytree.log.sellPrice", (Object)4);
        shopConfig.set("items.cherrytree.log.amount", (Object)1);
        shopConfig.set("items.cherrytree.log.slot", (Object)10);
        shopConfig.set("items.cherrytree.log.page", (Object)8);
        shopConfig.set("items.cherrytree.log.category", (Object)"Wood");
        shopConfig.set("items.strippedcherrytree.log.material", (Object)"STRIPPED_CHERRY_LOG");
        shopConfig.set("items.strippedcherrytree.log.price", (Object)17);
        shopConfig.set("items.strippedcherrytree.log.sellPrice", (Object)4.25);
        shopConfig.set("items.strippedcherrytree.log.amount", (Object)1);
        shopConfig.set("items.strippedcherrytree.log.slot", (Object)12);
        shopConfig.set("items.strippedcherrytree.log.page", (Object)8);
        shopConfig.set("items.strippedcherrytree.log.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.wood.material", (Object)"CHERRY_WOOD");
        shopConfig.set("items.cherrytree.wood.price", (Object)16);
        shopConfig.set("items.cherrytree.wood.sellPrice", (Object)4);
        shopConfig.set("items.cherrytree.wood.amount", (Object)1);
        shopConfig.set("items.cherrytree.wood.slot", (Object)14);
        shopConfig.set("items.cherrytree.wood.page", (Object)8);
        shopConfig.set("items.cherrytree.wood.category", (Object)"Wood");
        shopConfig.set("items.strippedcherrytree.wood.material", (Object)"STRIPPED_CHERRY_WOOD");
        shopConfig.set("items.strippedcherrytree.wood.price", (Object)17);
        shopConfig.set("items.strippedcherrytree.wood.sellPrice", (Object)4.25);
        shopConfig.set("items.strippedcherrytree.wood.amount", (Object)1);
        shopConfig.set("items.strippedcherrytree.wood.slot", (Object)16);
        shopConfig.set("items.strippedcherrytree.wood.page", (Object)8);
        shopConfig.set("items.strippedcherrytree.wood.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.planks.material", (Object)"CHERRY_PLANKS");
        shopConfig.set("items.cherrytree.planks.price", (Object)6);
        shopConfig.set("items.cherrytree.planks.sellPrice", (Object)1.5);
        shopConfig.set("items.cherrytree.planks.amount", (Object)1);
        shopConfig.set("items.cherrytree.planks.slot", (Object)19);
        shopConfig.set("items.cherrytree.planks.page", (Object)8);
        shopConfig.set("items.cherrytree.planks.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.slab.material", (Object)"CHERRY_SLAB");
        shopConfig.set("items.cherrytree.slab.price", (Object)4);
        shopConfig.set("items.cherrytree.slab.sellPrice", (Object)1);
        shopConfig.set("items.cherrytree.slab.amount", (Object)1);
        shopConfig.set("items.cherrytree.slab.slot", (Object)21);
        shopConfig.set("items.cherrytree.slab.page", (Object)8);
        shopConfig.set("items.cherrytree.slab.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.stairs.material", (Object)"CHERRY_STAIRS");
        shopConfig.set("items.cherrytree.stairs.price", (Object)7);
        shopConfig.set("items.cherrytree.stairs.sellPrice", (Object)1.75);
        shopConfig.set("items.cherrytree.stairs.amount", (Object)1);
        shopConfig.set("items.cherrytree.stairs.slot", (Object)23);
        shopConfig.set("items.cherrytree.stairs.page", (Object)8);
        shopConfig.set("items.cherrytree.stairs.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.fence.material", (Object)"CHERRY_FENCE");
        shopConfig.set("items.cherrytree.fence.price", (Object)6);
        shopConfig.set("items.cherrytree.fence.sellPrice", (Object)1.5);
        shopConfig.set("items.cherrytree.fence.amount", (Object)1);
        shopConfig.set("items.cherrytree.fence.slot", (Object)25);
        shopConfig.set("items.cherrytree.fence.page", (Object)8);
        shopConfig.set("items.cherrytree.fence.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.fencegate.material", (Object)"CHERRY_FENCE_GATE");
        shopConfig.set("items.cherrytree.fencegate.price", (Object)8);
        shopConfig.set("items.cherrytree.fencegate.sellPrice", (Object)2);
        shopConfig.set("items.cherrytree.fencegate.amount", (Object)1);
        shopConfig.set("items.cherrytree.fencegate.slot", (Object)28);
        shopConfig.set("items.cherrytree.fencegate.page", (Object)8);
        shopConfig.set("items.cherrytree.fencegate.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.door.material", (Object)"CHERRY_DOOR");
        shopConfig.set("items.cherrytree.door.price", (Object)7);
        shopConfig.set("items.cherrytree.door.sellPrice", (Object)1.75);
        shopConfig.set("items.cherrytree.door.amount", (Object)1);
        shopConfig.set("items.cherrytree.door.slot", (Object)30);
        shopConfig.set("items.cherrytree.door.page", (Object)8);
        shopConfig.set("items.cherrytree.door.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.trapdoor.material", (Object)"CHERRY_TRAPDOOR");
        shopConfig.set("items.cherrytree.trapdoor.price", (Object)7);
        shopConfig.set("items.cherrytree.trapdoor.sellPrice", (Object)1.75);
        shopConfig.set("items.cherrytree.trapdoor.amount", (Object)1);
        shopConfig.set("items.cherrytree.trapdoor.slot", (Object)32);
        shopConfig.set("items.cherrytree.trapdoor.page", (Object)8);
        shopConfig.set("items.cherrytree.trapdoor.category", (Object)"Wood");
        shopConfig.set("items.cherrytree.button.material", (Object)"CHERRY_BUTTON");
        shopConfig.set("items.cherrytree.button.price", (Object)3);
        shopConfig.set("items.cherrytree.button.sellPrice", (Object)0.75);
        shopConfig.set("items.cherrytree.button.amount", (Object)1);
        shopConfig.set("items.cherrytree.button.slot", (Object)34);
        shopConfig.set("items.cherrytree.button.page", (Object)8);
        shopConfig.set("items.cherrytree.button.category", (Object)"Wood");
        shopConfig.set("items.bamboo.log.material", (Object)"BAMBOO_BLOCK");
        shopConfig.set("items.bamboo.log.price", (Object)8);
        shopConfig.set("items.bamboo.log.sellPrice", (Object)2);
        shopConfig.set("items.bamboo.log.amount", (Object)1);
        shopConfig.set("items.bamboo.log.slot", (Object)10);
        shopConfig.set("items.bamboo.log.page", (Object)9);
        shopConfig.set("items.bamboo.log.category", (Object)"Wood");
        shopConfig.set("items.strippedbamboo.log.material", (Object)"STRIPPED_BAMBOO_BLOCK");
        shopConfig.set("items.strippedbamboo.log.price", (Object)9);
        shopConfig.set("items.strippedbamboo.log.sellPrice", (Object)2.25);
        shopConfig.set("items.strippedbamboo.log.amount", (Object)1);
        shopConfig.set("items.strippedbamboo.log.slot", (Object)12);
        shopConfig.set("items.strippedbamboo.log.page", (Object)9);
        shopConfig.set("items.strippedbamboo.log.category", (Object)"Wood");
        shopConfig.set("items.bamboo.wood.material", (Object)"BAMBOO_PLANKS");
        shopConfig.set("items.bamboo.wood.price", (Object)8);
        shopConfig.set("items.bamboo.wood.sellPrice", (Object)2);
        shopConfig.set("items.bamboo.wood.amount", (Object)1);
        shopConfig.set("items.bamboo.wood.slot", (Object)14);
        shopConfig.set("items.bamboo.wood.page", (Object)9);
        shopConfig.set("items.bamboo.wood.category", (Object)"Wood");
        shopConfig.set("items.strippedbamboo.wood.material", (Object)"STRIPPED_BAMBOO_BLOCK");
        shopConfig.set("items.strippedbamboo.wood.price", (Object)9);
        shopConfig.set("items.strippedbamboo.wood.sellPrice", (Object)2.25);
        shopConfig.set("items.strippedbamboo.wood.amount", (Object)1);
        shopConfig.set("items.strippedbamboo.wood.slot", (Object)16);
        shopConfig.set("items.strippedbamboo.wood.page", (Object)9);
        shopConfig.set("items.strippedbamboo.wood.category", (Object)"Wood");
        shopConfig.set("items.bamboo.planks.material", (Object)"BAMBOO_MOSAIC");
        shopConfig.set("items.bamboo.planks.price", (Object)4);
        shopConfig.set("items.bamboo.planks.sellPrice", (Object)1);
        shopConfig.set("items.bamboo.planks.amount", (Object)1);
        shopConfig.set("items.bamboo.planks.slot", (Object)19);
        shopConfig.set("items.bamboo.planks.page", (Object)9);
        shopConfig.set("items.bamboo.planks.category", (Object)"Wood");
        shopConfig.set("items.bamboo.slab.material", (Object)"BAMBOO_SLAB");
        shopConfig.set("items.bamboo.slab.price", (Object)2);
        shopConfig.set("items.bamboo.slab.sellPrice", (Object)0.5);
        shopConfig.set("items.bamboo.slab.amount", (Object)1);
        shopConfig.set("items.bamboo.slab.slot", (Object)21);
        shopConfig.set("items.bamboo.slab.page", (Object)9);
        shopConfig.set("items.bamboo.slab.category", (Object)"Wood");
        shopConfig.set("items.bamboo.stairs.material", (Object)"BAMBOO_STAIRS");
        shopConfig.set("items.bamboo.stairs.price", (Object)5);
        shopConfig.set("items.bamboo.stairs.sellPrice", (Object)1.25);
        shopConfig.set("items.bamboo.stairs.amount", (Object)1);
        shopConfig.set("items.bamboo.stairs.slot", (Object)23);
        shopConfig.set("items.bamboo.stairs.page", (Object)9);
        shopConfig.set("items.bamboo.stairs.category", (Object)"Wood");
        shopConfig.set("items.bamboo.fence.material", (Object)"BAMBOO_FENCE");
        shopConfig.set("items.bamboo.fence.price", (Object)4);
        shopConfig.set("items.bamboo.fence.sellPrice", (Object)1);
        shopConfig.set("items.bamboo.fence.amount", (Object)1);
        shopConfig.set("items.bamboo.fence.slot", (Object)25);
        shopConfig.set("items.bamboo.fence.page", (Object)9);
        shopConfig.set("items.bamboo.fence.category", (Object)"Wood");
        shopConfig.set("items.bamboo.fencegate.material", (Object)"BAMBOO_FENCE_GATE");
        shopConfig.set("items.bamboo.fencegate.price", (Object)6);
        shopConfig.set("items.bamboo.fencegate.sellPrice", (Object)1.5);
        shopConfig.set("items.bamboo.fencegate.amount", (Object)1);
        shopConfig.set("items.bamboo.fencegate.slot", (Object)28);
        shopConfig.set("items.bamboo.fencegate.page", (Object)9);
        shopConfig.set("items.bamboo.fencegate.category", (Object)"Wood");
        shopConfig.set("items.bamboo.door.material", (Object)"BAMBOO_DOOR");
        shopConfig.set("items.bamboo.door.price", (Object)5);
        shopConfig.set("items.bamboo.door.sellPrice", (Object)1.25);
        shopConfig.set("items.bamboo.door.amount", (Object)1);
        shopConfig.set("items.bamboo.door.slot", (Object)30);
        shopConfig.set("items.bamboo.door.page", (Object)9);
        shopConfig.set("items.bamboo.door.category", (Object)"Wood");
        shopConfig.set("items.bamboo.trapdoor.material", (Object)"BAMBOO_TRAPDOOR");
        shopConfig.set("items.bamboo.trapdoor.price", (Object)5);
        shopConfig.set("items.bamboo.trapdoor.sellPrice", (Object)1.25);
        shopConfig.set("items.bamboo.trapdoor.amount", (Object)1);
        shopConfig.set("items.bamboo.trapdoor.slot", (Object)32);
        shopConfig.set("items.bamboo.trapdoor.page", (Object)9);
        shopConfig.set("items.bamboo.trapdoor.category", (Object)"Wood");
        shopConfig.set("items.bamboo.button.material", (Object)"BAMBOO_BUTTON");
        shopConfig.set("items.bamboo.button.price", (Object)2);
        shopConfig.set("items.bamboo.button.sellPrice", (Object)0.5);
        shopConfig.set("items.bamboo.button.amount", (Object)1);
        shopConfig.set("items.bamboo.button.slot", (Object)34);
        shopConfig.set("items.bamboo.button.page", (Object)9);
        shopConfig.set("items.bamboo.button.category", (Object)"Wood");
        shopConfig.set("items.blaze_powder.material", (Object)"BLAZE_POWDER");
        shopConfig.set("items.blaze_powder.price", (Object)5);
        shopConfig.set("items.blaze_powder.sellPrice", (Object)1.25);
        shopConfig.set("items.blaze_powder.amount", (Object)1);
        shopConfig.set("items.blaze_powder.slot", (Object)10);
        shopConfig.set("items.blaze_powder.page", (Object)1);
        shopConfig.set("items.blaze_powder.category", (Object)"Brewing");
        shopConfig.set("items.ghast_tear.material", (Object)"GHAST_TEAR");
        shopConfig.set("items.ghast_tear.price", (Object)7);
        shopConfig.set("items.ghast_tear.sellPrice", (Object)1.75);
        shopConfig.set("items.ghast_tear.amount", (Object)1);
        shopConfig.set("items.ghast_tear.slot", (Object)12);
        shopConfig.set("items.ghast_tear.page", (Object)1);
        shopConfig.set("items.ghast_tear.category", (Object)"Brewing");
        shopConfig.set("items.magma_cream.material", (Object)"MAGMA_CREAM");
        shopConfig.set("items.magma_cream.price", (Object)6);
        shopConfig.set("items.magma_cream.sellPrice", (Object)1.5);
        shopConfig.set("items.magma_cream.amount", (Object)1);
        shopConfig.set("items.magma_cream.slot", (Object)14);
        shopConfig.set("items.magma_cream.page", (Object)1);
        shopConfig.set("items.magma_cream.category", (Object)"Brewing");
        shopConfig.set("items.spider_eye.material", (Object)"SPIDER_EYE");
        shopConfig.set("items.spider_eye.price", (Object)3);
        shopConfig.set("items.spider_eye.sellPrice", (Object)0.75);
        shopConfig.set("items.spider_eye.amount", (Object)1);
        shopConfig.set("items.spider_eye.slot", (Object)16);
        shopConfig.set("items.spider_eye.page", (Object)1);
        shopConfig.set("items.spider_eye.category", (Object)"Brewing");
        shopConfig.set("items.potion.material", (Object)"POTION");
        shopConfig.set("items.potion.price", (Object)20);
        shopConfig.set("items.potion.sellPrice", (Object)5);
        shopConfig.set("items.potion.amount", (Object)1);
        shopConfig.set("items.potion.slot", (Object)19);
        shopConfig.set("items.potion.page", (Object)1);
        shopConfig.set("items.potion.category", (Object)"Brewing");
        shopConfig.set("items.waterbottle1.material", (Object)"WATER_BOTTLE");
        shopConfig.set("items.waterbottle1.price", (Object)1);
        shopConfig.set("items.waterbottle1.sellPrice", (Object)0.25);
        shopConfig.set("items.waterbottle1.amount", (Object)1);
        shopConfig.set("items.waterbottle1.slot", (Object)21);
        shopConfig.set("items.waterbottle1.page", (Object)1);
        shopConfig.set("items.waterbottle1.category", (Object)"Brewing");
        shopConfig.set("items.fermented_spider_eye.material", (Object)"FERMENTED_SPIDER_EYE");
        shopConfig.set("items.fermented_spider_eye.price", (Object)4);
        shopConfig.set("items.fermented_spider_eye.sellPrice", (Object)1);
        shopConfig.set("items.fermented_spider_eye.amount", (Object)1);
        shopConfig.set("items.fermented_spider_eye.slot", (Object)23);
        shopConfig.set("items.fermented_spider_eye.page", (Object)1);
        shopConfig.set("items.fermented_spider_eye.category", (Object)"Brewing");
        shopConfig.set("items.splash_potion.material", (Object)"SPLASH_POTION");
        shopConfig.set("items.splash_potion.price", (Object)25);
        shopConfig.set("items.splash_potion.sellPrice", (Object)6.25);
        shopConfig.set("items.splash_potion.amount", (Object)1);
        shopConfig.set("items.splash_potion.slot", (Object)25);
        shopConfig.set("items.splash_potion.page", (Object)1);
        shopConfig.set("items.splash_potion.category", (Object)"Brewing");
        shopConfig.set("items.lingering_potion.material", (Object)"LINGERING_POTION");
        shopConfig.set("items.lingering_potion.price", (Object)30);
        shopConfig.set("items.lingering_potion.sellPrice", (Object)7.5);
        shopConfig.set("items.lingering_potion.amount", (Object)1);
        shopConfig.set("items.lingering_potion.slot", (Object)28);
        shopConfig.set("items.lingering_potion.page", (Object)1);
        shopConfig.set("items.lingering_potion.category", (Object)"Brewing");
        shopConfig.set("items.glass_bottle.material", (Object)"GLASS_BOTTLE");
        shopConfig.set("items.glass_bottle.price", (Object)1);
        shopConfig.set("items.glass_bottle.sellPrice", (Object)0.25);
        shopConfig.set("items.glass_bottle.amount", (Object)1);
        shopConfig.set("items.glass_bottle.slot", (Object)30);
        shopConfig.set("items.glass_bottle.page", (Object)1);
        shopConfig.set("items.glass_bottle.category", (Object)"Brewing");
        shopConfig.set("items.blaze_rod.material", (Object)"BLAZE_ROD");
        shopConfig.set("items.blaze_rod.price", (Object)8);
        shopConfig.set("items.blaze_rod.sellPrice", (Object)2);
        shopConfig.set("items.blaze_rod.amount", (Object)1);
        shopConfig.set("items.blaze_rod.slot", (Object)32);
        shopConfig.set("items.blaze_rod.page", (Object)1);
        shopConfig.set("items.blaze_rod.category", (Object)"Brewing");
        shopConfig.set("items.rabbit_foot.material", (Object)"RABBIT_FOOT");
        shopConfig.set("items.rabbit_foot.price", (Object)10);
        shopConfig.set("items.rabbit_foot.sellPrice", (Object)2.5);
        shopConfig.set("items.rabbit_foot.amount", (Object)1);
        shopConfig.set("items.rabbit_foot.slot", (Object)34);
        shopConfig.set("items.rabbit_foot.page", (Object)1);
        shopConfig.set("items.rabbit_foot.category", (Object)"Brewing");
        shopConfig.set("items.sugar.material", (Object)"SUGAR");
        shopConfig.set("items.sugar.price", (Object)2);
        shopConfig.set("items.sugar.sellPrice", (Object)0.5);
        shopConfig.set("items.sugar.amount", (Object)1);
        shopConfig.set("items.sugar.slot", (Object)10);
        shopConfig.set("items.sugar.page", (Object)2);
        shopConfig.set("items.sugar.category", (Object)"Brewing");
        shopConfig.set("items.golden_carrot.material", (Object)"GOLDEN_CARROT");
        shopConfig.set("items.golden_carrot.price", (Object)6);
        shopConfig.set("items.golden_carrot.sellPrice", (Object)1.5);
        shopConfig.set("items.golden_carrot.amount", (Object)1);
        shopConfig.set("items.golden_carrot.slot", (Object)12);
        shopConfig.set("items.golden_carrot.page", (Object)2);
        shopConfig.set("items.golden_carrot.category", (Object)"Brewing");
        shopConfig.set("items.pufferfish.material", (Object)"PUFFERFISH");
        shopConfig.set("items.pufferfish.price", (Object)8);
        shopConfig.set("items.pufferfish.sellPrice", (Object)2);
        shopConfig.set("items.pufferfish.amount", (Object)1);
        shopConfig.set("items.pufferfish.slot", (Object)14);
        shopConfig.set("items.pufferfish.page", (Object)2);
        shopConfig.set("items.pufferfish.category", (Object)"Brewing");
        shopConfig.set("items.torch.material", (Object)"TORCH");
        shopConfig.set("items.torch.price", (Object)8);
        shopConfig.set("items.torch.sellPrice", (Object)2);
        shopConfig.set("items.torch.amount", (Object)1);
        shopConfig.set("items.torch.slot", (Object)10);
        shopConfig.set("items.torch.page", (Object)1);
        shopConfig.set("items.torch.category", (Object)"Decorations");
        shopConfig.set("items.lantern.material", (Object)"LANTERN");
        shopConfig.set("items.lantern.price", (Object)14);
        shopConfig.set("items.lantern.sellPrice", (Object)3);
        shopConfig.set("items.lantern.amount", (Object)1);
        shopConfig.set("items.lantern.slot", (Object)12);
        shopConfig.set("items.lantern.page", (Object)1);
        shopConfig.set("items.lantern.category", (Object)"Decorations");
        shopConfig.set("items.chain.material", (Object)"CHAIN");
        shopConfig.set("items.chain.price", (Object)10);
        shopConfig.set("items.chain.sellPrice", (Object)2);
        shopConfig.set("items.chain.amount", (Object)1);
        shopConfig.set("items.chain.slot", (Object)14);
        shopConfig.set("items.chain.page", (Object)1);
        shopConfig.set("items.chain.category", (Object)"Decorations");
        shopConfig.set("items.redstonelamp1.material", (Object)"REDSTONE_LAMP");
        shopConfig.set("items.redstonelamp1.price", (Object)20);
        shopConfig.set("items.redstonelamp1.sellPrice", (Object)4);
        shopConfig.set("items.redstonelamp1.amount", (Object)1);
        shopConfig.set("items.redstonelamp1.slot", (Object)16);
        shopConfig.set("items.redstonelamp1.page", (Object)1);
        shopConfig.set("items.redstonelamp1.category", (Object)"Decorations");
        shopConfig.set("items.craftingtable.material", (Object)"CRAFTING_TABLE");
        shopConfig.set("items.craftingtable.price", (Object)12);
        shopConfig.set("items.craftingtable.sellPrice", (Object)3);
        shopConfig.set("items.craftingtable.amount", (Object)1);
        shopConfig.set("items.craftingtable.slot", (Object)19);
        shopConfig.set("items.craftingtable.page", (Object)1);
        shopConfig.set("items.craftingtable.category", (Object)"Decorations");
        shopConfig.set("items.stonecutter.material", (Object)"STONECUTTER");
        shopConfig.set("items.stonecutter.price", (Object)30);
        shopConfig.set("items.stonecutter.sellPrice", (Object)6);
        shopConfig.set("items.stonecutter.amount", (Object)1);
        shopConfig.set("items.stonecutter.slot", (Object)21);
        shopConfig.set("items.stonecutter.page", (Object)1);
        shopConfig.set("items.stonecutter.category", (Object)"Decorations");
        shopConfig.set("items.cartographytable.material", (Object)"CARTOGRAPHY_TABLE");
        shopConfig.set("items.cartographytable.price", (Object)40);
        shopConfig.set("items.cartographytable.sellPrice", (Object)10);
        shopConfig.set("items.cartographytable.amount", (Object)1);
        shopConfig.set("items.cartographytable.slot", (Object)23);
        shopConfig.set("items.cartographytable.page", (Object)1);
        shopConfig.set("items.cartographytable.category", (Object)"Decorations");
        shopConfig.set("items.fletchingtable.material", (Object)"FLETCHING_TABLE");
        shopConfig.set("items.fletchingtable.price", (Object)35);
        shopConfig.set("items.fletchingtable.sellPrice", (Object)8);
        shopConfig.set("items.fletchingtable.amount", (Object)1);
        shopConfig.set("items.fletchingtable.slot", (Object)25);
        shopConfig.set("items.fletchingtable.page", (Object)1);
        shopConfig.set("items.fletchingtable.category", (Object)"Decorations");
        shopConfig.set("items.smithingtable.material", (Object)"SMITHING_TABLE");
        shopConfig.set("items.smithingtable.price", (Object)50);
        shopConfig.set("items.smithingtable.sellPrice", (Object)12);
        shopConfig.set("items.smithingtable.amount", (Object)1);
        shopConfig.set("items.smithingtable.slot", (Object)28);
        shopConfig.set("items.smithingtable.page", (Object)1);
        shopConfig.set("items.smithingtable.category", (Object)"Decorations");
        shopConfig.set("items.grindstone.material", (Object)"GRINDSTONE");
        shopConfig.set("items.grindstone.price", (Object)60);
        shopConfig.set("items.grindstone.sellPrice", (Object)15);
        shopConfig.set("items.grindstone.amount", (Object)1);
        shopConfig.set("items.grindstone.slot", (Object)30);
        shopConfig.set("items.grindstone.page", (Object)1);
        shopConfig.set("items.grindstone.category", (Object)"Decorations");
        shopConfig.set("items.loom.material", (Object)"LOOM");
        shopConfig.set("items.loom.price", (Object)60);
        shopConfig.set("items.loom.sellPrice", (Object)15);
        shopConfig.set("items.loom.amount", (Object)1);
        shopConfig.set("items.loom.slot", (Object)32);
        shopConfig.set("items.loom.page", (Object)1);
        shopConfig.set("items.loom.category", (Object)"Decorations");
        shopConfig.set("items.furnace.material", (Object)"FURNACE");
        shopConfig.set("items.furnace.price", (Object)50);
        shopConfig.set("items.furnace.sellPrice", (Object)12);
        shopConfig.set("items.furnace.amount", (Object)1);
        shopConfig.set("items.furnace.slot", (Object)34);
        shopConfig.set("items.furnace.page", (Object)1);
        shopConfig.set("items.furnace.category", (Object)"Decorations");
        shopConfig.set("items.smoker.material", (Object)"SMOKER");
        shopConfig.set("items.smoker.price", (Object)55);
        shopConfig.set("items.smoker.sellPrice", (Object)14);
        shopConfig.set("items.smoker.amount", (Object)1);
        shopConfig.set("items.smoker.slot", (Object)10);
        shopConfig.set("items.smoker.page", (Object)2);
        shopConfig.set("items.smoker.category", (Object)"Decorations");
        shopConfig.set("items.hfdjfsfhskdjff.material", (Object)"BEE_HIVE");
        shopConfig.set("items.hfdjfsfhskdjff.price", (Object)70);
        shopConfig.set("items.hfdjfsfhskdjff.sellPrice", (Object)18);
        shopConfig.set("items.hfdjfsfhskdjff.amount", (Object)1);
        shopConfig.set("items.hfdjfsfhskdjff.slot", (Object)12);
        shopConfig.set("items.hfdjfsfhskdjff.page", (Object)2);
        shopConfig.set("items.hfdjfsfhskdjff.category", (Object)"Decorations");
        shopConfig.set("items.blastfurnace.material", (Object)"BLAST_FURNACE");
        shopConfig.set("items.blastfurnace.price", (Object)65);
        shopConfig.set("items.blastfurnace.sellPrice", (Object)16);
        shopConfig.set("items.blastfurnace.amount", (Object)1);
        shopConfig.set("items.blastfurnace.slot", (Object)14);
        shopConfig.set("items.blastfurnace.page", (Object)2);
        shopConfig.set("items.blastfurnace.category", (Object)"Decorations");
        shopConfig.set("items.campfire.material", (Object)"CAMPFIRE");
        shopConfig.set("items.campfire.price", (Object)40);
        shopConfig.set("items.campfire.sellPrice", (Object)10);
        shopConfig.set("items.campfire.amount", (Object)1);
        shopConfig.set("items.campfire.slot", (Object)16);
        shopConfig.set("items.campfire.page", (Object)2);
        shopConfig.set("items.campfire.category", (Object)"Decorations");
        shopConfig.set("items.noteblock1.material", (Object)"NOTE_BLOCK");
        shopConfig.set("items.noteblock1.price", (Object)50);
        shopConfig.set("items.noteblock1.sellPrice", (Object)12);
        shopConfig.set("items.noteblock1.amount", (Object)1);
        shopConfig.set("items.noteblock1.slot", (Object)19);
        shopConfig.set("items.noteblock1.page", (Object)2);
        shopConfig.set("items.noteblock1.category", (Object)"Decorations");
        shopConfig.set("items.jukebox1.material", (Object)"JUKEBOX");
        shopConfig.set("items.jukebox1.price", (Object)80);
        shopConfig.set("items.jukebox1.sellPrice", (Object)20);
        shopConfig.set("items.jukebox1.amount", (Object)1);
        shopConfig.set("items.jukebox1.slot", (Object)21);
        shopConfig.set("items.jukebox1.page", (Object)2);
        shopConfig.set("items.jukebox1.category", (Object)"Decorations");
        shopConfig.set("items.enchantingtable.material", (Object)"ENCHANTING_TABLE");
        shopConfig.set("items.enchantingtable.price", (Object)100);
        shopConfig.set("items.enchantingtable.sellPrice", (Object)25);
        shopConfig.set("items.enchantingtable.amount", (Object)1);
        shopConfig.set("items.enchantingtable.slot", (Object)23);
        shopConfig.set("items.enchantingtable.page", (Object)2);
        shopConfig.set("items.enchantingtable.category", (Object)"Decorations");
        shopConfig.set("items.cauldron.material", (Object)"CAULDRON");
        shopConfig.set("items.cauldron.price", (Object)65);
        shopConfig.set("items.cauldron.sellPrice", (Object)12);
        shopConfig.set("items.cauldron.amount", (Object)1);
        shopConfig.set("items.cauldron.slot", (Object)25);
        shopConfig.set("items.cauldron.page", (Object)2);
        shopConfig.set("items.cauldron.category", (Object)"Decorations");
        shopConfig.set("items.lodestone.material", (Object)"LODESTONE");
        shopConfig.set("items.lodestone.price", (Object)200);
        shopConfig.set("items.lodestone.sellPrice", (Object)50);
        shopConfig.set("items.lodestone.amount", (Object)1);
        shopConfig.set("items.lodestone.slot", (Object)28);
        shopConfig.set("items.lodestone.page", (Object)2);
        shopConfig.set("items.lodestone.category", (Object)"Decorations");
        shopConfig.set("items.ladder.material", (Object)"LADDER");
        shopConfig.set("items.ladder.price", (Object)20);
        shopConfig.set("items.ladder.sellPrice", (Object)5);
        shopConfig.set("items.ladder.amount", (Object)1);
        shopConfig.set("items.ladder.slot", (Object)30);
        shopConfig.set("items.ladder.page", (Object)2);
        shopConfig.set("items.ladder.category", (Object)"Decorations");
        shopConfig.set("items.flowerpot.material", (Object)"FLOWER_POT");
        shopConfig.set("items.flowerpot.price", (Object)10);
        shopConfig.set("items.flowerpot.sellPrice", (Object)2);
        shopConfig.set("items.flowerpot.amount", (Object)1);
        shopConfig.set("items.flowerpot.slot", (Object)32);
        shopConfig.set("items.flowerpot.page", (Object)2);
        shopConfig.set("items.flowerpot.category", (Object)"Decorations");
        shopConfig.set("items.12121212122.material", (Object)"PLAYER_HEAD");
        shopConfig.set("items.12121212122.price", (Object)1000);
        shopConfig.set("items.12121212122.sellPrice", (Object)200);
        shopConfig.set("items.12121212122.amount", (Object)1);
        shopConfig.set("items.12121212122.slot", (Object)34);
        shopConfig.set("items.12121212122.page", (Object)2);
        shopConfig.set("items.12121212122.category", (Object)"Decorations");
        shopConfig.set("items.decoratedpot.material", (Object)"DECORATED_POT");
        shopConfig.set("items.decoratedpot.price", (Object)25);
        shopConfig.set("items.decoratedpot.sellPrice", (Object)5);
        shopConfig.set("items.decoratedpot.amount", (Object)1);
        shopConfig.set("items.decoratedpot.slot", (Object)10);
        shopConfig.set("items.decoratedpot.page", (Object)3);
        shopConfig.set("items.decoratedpot.category", (Object)"Decorations");
        shopConfig.set("items.trappedchest.material", (Object)"TRAPPED_CHEST");
        shopConfig.set("items.trappedchest.price", (Object)100);
        shopConfig.set("items.trappedchest.sellPrice", (Object)25);
        shopConfig.set("items.trappedchest.amount", (Object)1);
        shopConfig.set("items.trappedchest.slot", (Object)14);
        shopConfig.set("items.trappedchest.page", (Object)3);
        shopConfig.set("items.trappedchest.category", (Object)"Decorations");
        shopConfig.set("items.itemframe.material", (Object)"ITEM_FRAME");
        shopConfig.set("items.itemframe.price", (Object)50);
        shopConfig.set("items.itemframe.sellPrice", (Object)12);
        shopConfig.set("items.itemframe.amount", (Object)1);
        shopConfig.set("items.itemframe.slot", (Object)16);
        shopConfig.set("items.itemframe.page", (Object)3);
        shopConfig.set("items.itemframe.category", (Object)"Decorations");
        shopConfig.set("items.glowitemframe.material", (Object)"GLOW_ITEM_FRAME");
        shopConfig.set("items.glowitemframe.price", (Object)60);
        shopConfig.set("items.glowitemframe.sellPrice", (Object)15);
        shopConfig.set("items.glowitemframe.amount", (Object)1);
        shopConfig.set("items.glowitemframe.slot", (Object)19);
        shopConfig.set("items.glowitemframe.page", (Object)3);
        shopConfig.set("items.glowitemframe.category", (Object)"Decorations");
        shopConfig.set("items.bookshelf.material", (Object)"BOOKSHELF");
        shopConfig.set("items.bookshelf.price", (Object)120);
        shopConfig.set("items.bookshelf.sellPrice", (Object)30);
        shopConfig.set("items.bookshelf.amount", (Object)1);
        shopConfig.set("items.bookshelf.slot", (Object)21);
        shopConfig.set("items.bookshelf.page", (Object)3);
        shopConfig.set("items.bookshelf.category", (Object)"Decorations");
        shopConfig.set("items.lectern.material", (Object)"LECTERN");
        shopConfig.set("items.lectern.price", (Object)110);
        shopConfig.set("items.lectern.sellPrice", (Object)25);
        shopConfig.set("items.lectern.amount", (Object)1);
        shopConfig.set("items.lectern.slot", (Object)23);
        shopConfig.set("items.lectern.page", (Object)3);
        shopConfig.set("items.lectern.category", (Object)"Decorations");
        shopConfig.set("items.redbed.material", (Object)"RED_BED");
        shopConfig.set("items.redbed.price", (Object)50);
        shopConfig.set("items.redbed.sellPrice", (Object)10);
        shopConfig.set("items.redbed.amount", (Object)1);
        shopConfig.set("items.redbed.slot", (Object)25);
        shopConfig.set("items.redbed.page", (Object)3);
        shopConfig.set("items.redbed.category", (Object)"Decorations");
        shopConfig.set("items.candle.material", (Object)"CANDLE");
        shopConfig.set("items.candle.price", (Object)12);
        shopConfig.set("items.candle.sellPrice", (Object)3);
        shopConfig.set("items.candle.amount", (Object)1);
        shopConfig.set("items.candle.slot", (Object)28);
        shopConfig.set("items.candle.page", (Object)3);
        shopConfig.set("items.candle.category", (Object)"Decorations");
        shopConfig.set("items.glass.material", (Object)"GLASS");
        shopConfig.set("items.glass.price", (Object)20);
        shopConfig.set("items.glass.sellPrice", (Object)5);
        shopConfig.set("items.glass.amount", (Object)1);
        shopConfig.set("items.glass.slot", (Object)30);
        shopConfig.set("items.glass.page", (Object)3);
        shopConfig.set("items.glass.category", (Object)"Decorations");
        shopConfig.set("items.chest1.material", (Object)"CHEST");
        shopConfig.set("items.chest1.price", (Object)45);
        shopConfig.set("items.chest1.sellPrice", (Object)14);
        shopConfig.set("items.chest1.amount", (Object)1);
        shopConfig.set("items.chest1.slot", (Object)32);
        shopConfig.set("items.chest1.page", (Object)3);
        shopConfig.set("items.chest1.category", (Object)"Decorations");
        shopConfig.set("items.enderchest1.material", (Object)"ENDER_CHEST");
        shopConfig.set("items.enderchest1.price", (Object)200);
        shopConfig.set("items.enderchest1.sellPrice", (Object)50);
        shopConfig.set("items.enderchest1.amount", (Object)1);
        shopConfig.set("items.enderchest1.slot", (Object)34);
        shopConfig.set("items.enderchest1.page", (Object)3);
        shopConfig.set("items.enderchest1.category", (Object)"Decorations");
        shopConfig.set("items.netherrack.material", (Object)"NETHERRACK");
        shopConfig.set("items.netherrack.price", (Object)2);
        shopConfig.set("items.netherrack.sellPrice", (Object)0.5);
        shopConfig.set("items.netherrack.amount", (Object)1);
        shopConfig.set("items.netherrack.slot", (Object)10);
        shopConfig.set("items.netherrack.page", (Object)1);
        shopConfig.set("items.netherrack.category", (Object)"Nether");
        shopConfig.set("items.soulsoil.material", (Object)"SOUL_SOIL");
        shopConfig.set("items.soulsoil.price", (Object)12);
        shopConfig.set("items.soulsoil.sellPrice", (Object)3);
        shopConfig.set("items.soulsoil.amount", (Object)1);
        shopConfig.set("items.soulsoil.slot", (Object)12);
        shopConfig.set("items.soulsoil.page", (Object)1);
        shopConfig.set("items.soulsoil.category", (Object)"Nether");
        shopConfig.set("items.soulsand.material", (Object)"SOUL_SAND");
        shopConfig.set("items.soulsand.price", (Object)10);
        shopConfig.set("items.soulsand.sellPrice", (Object)2);
        shopConfig.set("items.soulsand.amount", (Object)1);
        shopConfig.set("items.soulsand.slot", (Object)14);
        shopConfig.set("items.soulsand.page", (Object)1);
        shopConfig.set("items.soulsand.category", (Object)"Nether");
        shopConfig.set("items.magmablock.material", (Object)"MAGMA_BLOCK");
        shopConfig.set("items.magmablock.price", (Object)15);
        shopConfig.set("items.magmablock.sellPrice", (Object)4);
        shopConfig.set("items.magmablock.amount", (Object)1);
        shopConfig.set("items.magmablock.slot", (Object)16);
        shopConfig.set("items.magmablock.page", (Object)1);
        shopConfig.set("items.magmablock.category", (Object)"Nether");
        shopConfig.set("items.netherwartblock.material", (Object)"NETHER_WART_BLOCK");
        shopConfig.set("items.netherwartblock.price", (Object)30);
        shopConfig.set("items.netherwartblock.sellPrice", (Object)8);
        shopConfig.set("items.netherwartblock.amount", (Object)1);
        shopConfig.set("items.netherwartblock.slot", (Object)19);
        shopConfig.set("items.netherwartblock.page", (Object)1);
        shopConfig.set("items.netherwartblock.category", (Object)"Nether");
        shopConfig.set("items.blackstone.material", (Object)"BLACKSTONE");
        shopConfig.set("items.blackstone.price", (Object)30);
        shopConfig.set("items.blackstone.sellPrice", (Object)8);
        shopConfig.set("items.blackstone.amount", (Object)1);
        shopConfig.set("items.blackstone.slot", (Object)21);
        shopConfig.set("items.blackstone.page", (Object)1);
        shopConfig.set("items.blackstone.category", (Object)"Nether");
        shopConfig.set("items.gildedblackstone.material", (Object)"GILDED_BLACKSTONE");
        shopConfig.set("items.gildedblackstone.price", (Object)100);
        shopConfig.set("items.gildedblackstone.sellPrice", (Object)25);
        shopConfig.set("items.gildedblackstone.amount", (Object)1);
        shopConfig.set("items.gildedblackstone.slot", (Object)23);
        shopConfig.set("items.gildedblackstone.page", (Object)1);
        shopConfig.set("items.gildedblackstone.category", (Object)"Nether");
        shopConfig.set("items.crimsonstem.material", (Object)"CRIMSON_STEM");
        shopConfig.set("items.crimsonstem.price", (Object)30);
        shopConfig.set("items.crimsonstem.sellPrice", (Object)8);
        shopConfig.set("items.crimsonstem.amount", (Object)1);
        shopConfig.set("items.crimsonstem.slot", (Object)25);
        shopConfig.set("items.crimsonstem.page", (Object)1);
        shopConfig.set("items.crimsonstem.category", (Object)"Nether");
        shopConfig.set("items.netherwart1.material", (Object)"NETHER_WART");
        shopConfig.set("items.netherwart1.price", (Object)20);
        shopConfig.set("items.netherwart1.sellPrice", (Object)5);
        shopConfig.set("items.netherwart1.amount", (Object)1);
        shopConfig.set("items.netherwart1.slot", (Object)28);
        shopConfig.set("items.netherwart1.page", (Object)1);
        shopConfig.set("items.netherwart1.category", (Object)"Nether");
        shopConfig.set("items.warpedfungus.material", (Object)"WARPED_FUNGUS");
        shopConfig.set("items.warpedfungus.price", (Object)15);
        shopConfig.set("items.warpedfungus.sellPrice", (Object)4);
        shopConfig.set("items.warpedfungus.amount", (Object)1);
        shopConfig.set("items.warpedfungus.slot", (Object)30);
        shopConfig.set("items.warpedfungus.page", (Object)1);
        shopConfig.set("items.warpedfungus.category", (Object)"Nether");
        shopConfig.set("items.obsidian1.material", (Object)"OBSIDIAN");
        shopConfig.set("items.obsidian1.price", (Object)100);
        shopConfig.set("items.obsidian1.sellPrice", (Object)25);
        shopConfig.set("items.obsidian1.amount", (Object)1);
        shopConfig.set("items.obsidian1.slot", (Object)32);
        shopConfig.set("items.obsidian1.page", (Object)1);
        shopConfig.set("items.obsidian1.category", (Object)"Nether");
        shopConfig.set("items.ancientdebris1.material", (Object)"ANCIENT_DEBRIS");
        shopConfig.set("items.ancientdebris1.price", (Object)1000);
        shopConfig.set("items.ancientdebris1.sellPrice", (Object)250);
        shopConfig.set("items.ancientdebris1.amount", (Object)1);
        shopConfig.set("items.ancientdebris1.slot", (Object)34);
        shopConfig.set("items.ancientdebris1.page", (Object)1);
        shopConfig.set("items.ancientdebris1.category", (Object)"Nether");
        shopConfig.set("items.soultorch.material", (Object)"SOUL_TORCH");
        shopConfig.set("items.soultorch.price", (Object)10);
        shopConfig.set("items.soultorch.sellPrice", (Object)2);
        shopConfig.set("items.soultorch.amount", (Object)1);
        shopConfig.set("items.soultorch.slot", (Object)10);
        shopConfig.set("items.soultorch.page", (Object)2);
        shopConfig.set("items.soultorch.category", (Object)"Nether");
        shopConfig.set("items.soulcampfire.material", (Object)"SOUL_CAMPFIRE");
        shopConfig.set("items.soulcampfire.price", (Object)100);
        shopConfig.set("items.soulcampfire.sellPrice", (Object)25);
        shopConfig.set("items.soulcampfire.amount", (Object)1);
        shopConfig.set("items.soulcampfire.slot", (Object)12);
        shopConfig.set("items.soulcampfire.page", (Object)2);
        shopConfig.set("items.soulcampfire.category", (Object)"Nether");
        shopConfig.set("items.soullantern.material", (Object)"SOUL_LANTERN");
        shopConfig.set("items.soullantern.price", (Object)15);
        shopConfig.set("items.soullantern.sellPrice", (Object)4);
        shopConfig.set("items.soullantern.amount", (Object)1);
        shopConfig.set("items.soullantern.slot", (Object)14);
        shopConfig.set("items.soullantern.page", (Object)2);
        shopConfig.set("items.soullantern.category", (Object)"Nether");
        shopConfig.set("items.warpednylium.material", (Object)"WARPED_NYLIUM");
        shopConfig.set("items.warpednylium.price", (Object)20);
        shopConfig.set("items.warpednylium.sellPrice", (Object)5);
        shopConfig.set("items.warpednylium.amount", (Object)1);
        shopConfig.set("items.warpednylium.slot", (Object)16);
        shopConfig.set("items.warpednylium.page", (Object)2);
        shopConfig.set("items.warpednylium.category", (Object)"Nether");
        shopConfig.set("items.crimsonnylium.material", (Object)"CRIMSON_NYLIUM");
        shopConfig.set("items.crimsonnylium.price", (Object)20);
        shopConfig.set("items.crimsonnylium.sellPrice", (Object)5);
        shopConfig.set("items.crimsonnylium.amount", (Object)1);
        shopConfig.set("items.crimsonnylium.slot", (Object)19);
        shopConfig.set("items.crimsonnylium.page", (Object)2);
        shopConfig.set("items.crimsonnylium.category", (Object)"Nether");
        shopConfig.set("items.12134123.material", (Object)"WARPED_FUNGUS_ON_A_STICK");
        shopConfig.set("items.12134123.price", (Object)50);
        shopConfig.set("items.12134123.sellPrice", (Object)12);
        shopConfig.set("items.12134123.amount", (Object)1);
        shopConfig.set("items.12134123.slot", (Object)21);
        shopConfig.set("items.12134123.page", (Object)2);
        shopConfig.set("items.12134123.category", (Object)"Nether");
        shopConfig.set("items.quartz.material", (Object)"QUARTZ");
        shopConfig.set("items.quartz.price", (Object)30);
        shopConfig.set("items.quartz.sellPrice", (Object)8);
        shopConfig.set("items.quartz.amount", (Object)1);
        shopConfig.set("items.quartz.slot", (Object)23);
        shopConfig.set("items.quartz.page", (Object)2);
        shopConfig.set("items.quartz.category", (Object)"Nether");
        shopConfig.set("items.ghasttear1.material", (Object)"GHAST_TEAR");
        shopConfig.set("items.ghasttear1.price", (Object)100);
        shopConfig.set("items.ghasttear1.sellPrice", (Object)25);
        shopConfig.set("items.ghasttear1.amount", (Object)1);
        shopConfig.set("items.ghasttear1.slot", (Object)25);
        shopConfig.set("items.ghasttear1.page", (Object)2);
        shopConfig.set("items.ghasttear1.category", (Object)"Nether");
        shopConfig.set("items.blazerod1.material", (Object)"BLAZE_ROD");
        shopConfig.set("items.blazerod1.price", (Object)50);
        shopConfig.set("items.blazerod1.sellPrice", (Object)12);
        shopConfig.set("items.blazerod1.amount", (Object)1);
        shopConfig.set("items.blazerod1.slot", (Object)28);
        shopConfig.set("items.blazerod1.page", (Object)2);
        shopConfig.set("items.blazerod1.category", (Object)"Nether");
        shopConfig.set("items.crimsonfungus.material", (Object)"CRIMSON_FUNGUS");
        shopConfig.set("items.crimsonfungus.price", (Object)15);
        shopConfig.set("items.crimsonfungus.sellPrice", (Object)4);
        shopConfig.set("items.crimsonfungus.amount", (Object)1);
        shopConfig.set("items.crimsonfungus.slot", (Object)30);
        shopConfig.set("items.crimsonfungus.page", (Object)2);
        shopConfig.set("items.crimsonfungus.category", (Object)"Nether");
        shopConfig.set("items.basalt.material", (Object)"BASALT");
        shopConfig.set("items.basalt.price", (Object)15);
        shopConfig.set("items.basalt.sellPrice", (Object)4);
        shopConfig.set("items.basalt.amount", (Object)1);
        shopConfig.set("items.basalt.slot", (Object)32);
        shopConfig.set("items.basalt.page", (Object)2);
        shopConfig.set("items.basalt.category", (Object)"Nether");
        shopConfig.set("items.warpedstem.material", (Object)"WARPED_STEM");
        shopConfig.set("items.warpedstem.price", (Object)30);
        shopConfig.set("items.warpedstem.sellPrice", (Object)8);
        shopConfig.set("items.warpedstem.amount", (Object)1);
        shopConfig.set("items.warpedstem.slot", (Object)34);
        shopConfig.set("items.warpedstem.page", (Object)2);
        shopConfig.set("items.warpedstem.category", (Object)"Nether");
        shopConfig.set("items.cryingobsidian.material", (Object)"CRYING_OBSIDIAN");
        shopConfig.set("items.cryingobsidian.price", (Object)150);
        shopConfig.set("items.cryingobsidian.sellPrice", (Object)35);
        shopConfig.set("items.cryingobsidian.amount", (Object)1);
        shopConfig.set("items.cryingobsidian.slot", (Object)10);
        shopConfig.set("items.cryingobsidian.page", (Object)3);
        shopConfig.set("items.cryingobsidian.category", (Object)"Nether");
        shopConfig.set("items.shroomlight.material", (Object)"SHROOMLIGHT");
        shopConfig.set("items.shroomlight.price", (Object)120);
        shopConfig.set("items.shroomlight.sellPrice", (Object)30);
        shopConfig.set("items.shroomlight.amount", (Object)1);
        shopConfig.set("items.shroomlight.slot", (Object)12);
        shopConfig.set("items.shroomlight.page", (Object)3);
        shopConfig.set("items.shroomlight.category", (Object)"Nether");
        shopConfig.set("items.witherrose.material", (Object)"WITHER_ROSE");
        shopConfig.set("items.witherrose.price", (Object)100);
        shopConfig.set("items.witherrose.sellPrice", (Object)25);
        shopConfig.set("items.witherrose.amount", (Object)1);
        shopConfig.set("items.witherrose.slot", (Object)14);
        shopConfig.set("items.witherrose.page", (Object)3);
        shopConfig.set("items.witherrose.category", (Object)"Nether");
        shopConfig.set("items.witherskull1.material", (Object)"WITHER_SKELETON_SKULL");
        shopConfig.set("items.witherskull1.price", (Object)1500);
        shopConfig.set("items.witherskull1.sellPrice", (Object)375);
        shopConfig.set("items.witherskull1.amount", (Object)1);
        shopConfig.set("items.witherskull1.slot", (Object)16);
        shopConfig.set("items.witherskull1.page", (Object)3);
        shopConfig.set("items.witherskull1.category", (Object)"Nether");
        shopConfig.set("items.netherstar.material", (Object)"NETHER_STAR");
        shopConfig.set("items.netherstar.price", (Object)3000);
        shopConfig.set("items.netherstar.sellPrice", (Object)750);
        shopConfig.set("items.netherstar.amount", (Object)1);
        shopConfig.set("items.netherstar.slot", (Object)19);
        shopConfig.set("items.netherstar.page", (Object)3);
        shopConfig.set("items.netherstar.category", (Object)"Nether");
        shopConfig.set("items.pigstepdisc.material", (Object)"MUSIC_DISC_PIGSTEP");
        shopConfig.set("items.pigstepdisc.price", (Object)1000);
        shopConfig.set("items.pigstepdisc.sellPrice", (Object)250);
        shopConfig.set("items.pigstepdisc.amount", (Object)1);
        shopConfig.set("items.pigstepdisc.slot", (Object)21);
        shopConfig.set("items.pigstepdisc.page", (Object)3);
        shopConfig.set("items.pigstepdisc.category", (Object)"Nether");
        shopConfig.set("items.goldnugget.material", (Object)"GOLD_NUGGET");
        shopConfig.set("items.goldnugget.price", (Object)8);
        shopConfig.set("items.goldnugget.sellPrice", (Object)2);
        shopConfig.set("items.goldnugget.amount", (Object)1);
        shopConfig.set("items.goldnugget.slot", (Object)23);
        shopConfig.set("items.goldnugget.page", (Object)3);
        shopConfig.set("items.goldnugget.category", (Object)"Nether");
        shopConfig.set("items.goldingot1.material", (Object)"GOLD_INGOT");
        shopConfig.set("items.goldingot1.price", (Object)80);
        shopConfig.set("items.goldingot1.sellPrice", (Object)20);
        shopConfig.set("items.goldingot1.amount", (Object)1);
        shopConfig.set("items.goldingot1.slot", (Object)25);
        shopConfig.set("items.goldingot1.page", (Object)3);
        shopConfig.set("items.goldingot1.category", (Object)"Nether");
        shopConfig.set("items.enderpearl1.material", (Object)"ENDER_PEARL");
        shopConfig.set("items.enderpearl1.price", (Object)100);
        shopConfig.set("items.enderpearl1.sellPrice", (Object)25);
        shopConfig.set("items.enderpearl1.amount", (Object)1);
        shopConfig.set("items.enderpearl1.slot", (Object)28);
        shopConfig.set("items.enderpearl1.page", (Object)3);
        shopConfig.set("items.enderpearl1.category", (Object)"Nether");
        shopConfig.set("items.lavabucket.material", (Object)"LAVA_BUCKET");
        shopConfig.set("items.lavabucket.price", (Object)40);
        shopConfig.set("items.lavabucket.sellPrice", (Object)10);
        shopConfig.set("items.lavabucket.amount", (Object)1);
        shopConfig.set("items.lavabucket.slot", (Object)30);
        shopConfig.set("items.lavabucket.page", (Object)3);
        shopConfig.set("items.lavabucket.category", (Object)"Nether");
        shopConfig.set("items.glowstonedust.material", (Object)"GLOWSTONE_DUST");
        shopConfig.set("items.glowstonedust.price", (Object)20);
        shopConfig.set("items.glowstonedust.sellPrice", (Object)5);
        shopConfig.set("items.glowstonedust.amount", (Object)1);
        shopConfig.set("items.glowstonedust.slot", (Object)32);
        shopConfig.set("items.glowstonedust.page", (Object)3);
        shopConfig.set("items.glowstonedust.category", (Object)"Nether");
        try {
            shopConfig.save(shopFile);
            Bukkit.getLogger().info("[ServerEssentials] Generated default shopitems.yml with Pre-Coded Items for all sections.");
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("[ServerEssentials] Could not save default shopitems.yml: " + e.getMessage());
        }
    }

    public static void saveShopItems() {
        if (shopConfig == null) {
            shopConfig = YamlConfiguration.loadConfiguration((File)shopFile);
        }
        for (String section : ShopManager.getSections()) {
            for (ShopItem shopItem : ShopManager.getItems(section)) {
                String key = shopItem.getItem().getType().toString().toLowerCase();
                String path = "items." + key;
                shopConfig.set(path + ".material", (Object)shopItem.getItem().getType().toString());
                shopConfig.set(path + ".price", (Object)shopItem.getBuyPrice());
                shopConfig.set(path + ".sellPrice", (Object)shopItem.getSellPrice());
                shopConfig.set(path + ".amount", (Object)shopItem.getItem().getAmount());
                shopConfig.set(path + ".slot", (Object)shopItem.getSlot());
                shopConfig.set(path + ".page", (Object)shopItem.getPage());
                shopConfig.set(path + ".category", (Object)shopItem.getSection());
            }
        }
        try {
            shopConfig.save(shopFile);
            Bukkit.getLogger().info("[ServerEssentials] Saved shop items to shopitems.yml!");
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("[ServerEssentials] Could not save shopitems.yml: " + e.getMessage());
        }
    }

    public static void reloadShopConfig() {
        if (shopFile == null) {
            shopFile = new File(Bukkit.getServer().getPluginManager().getPlugin("ServerEssentials").getDataFolder(), "shopitems.yml");
        }
        shopConfig = YamlConfiguration.loadConfiguration((File)shopFile);
        ShopConfigManager.loadShopItems();
    }
}

