/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.EconomyManager;
import serveressentials.serveressentials.ShopItem;
import serveressentials.serveressentials.ShopManager;

public class ShopGUIListener
implements Listener {
    public static void openSectionSelector(Player player, int page) {
        Inventory sectionGUI = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.DARK_GRAY) + "Shop Sections (Page " + page + ")"));
        String[] sectionNames = new String[]{"Misc", "Tools", "Combat", "Nether", "Farming", "Redstone", "Brewing", "Wood", "Mob Drops", "Decorations", "Ores", "Food", "End", "Colored Blocks"};
        String[] sectionDescriptions = new String[]{"Various useful items", "Pickaxes, shovels, and more", "Weapons and armor", "Nether-related blocks and items", "Seeds, crops, and farming tools", "Redstone components and circuits", "Potions and brewing items", "Logs and wood-related blocks", "Drops from mobs", "Decorative blocks and furniture", "Ores and minerals", "Food and consumables", "End dimension blocks", "Colored wool and blocks"};
        Material[] icons = new Material[]{Material.BOOK, Material.IRON_PICKAXE, Material.IRON_SWORD, Material.NETHERRACK, Material.WHEAT, Material.REDSTONE, Material.BREWING_STAND, Material.OAK_LOG, Material.ROTTEN_FLESH, Material.FLOWER_POT, Material.DIAMOND, Material.COOKED_BEEF, Material.END_STONE, Material.LIME_WOOL};
        int itemsPerPage = 7;
        int start = (page - 1) * itemsPerPage;
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16};
        for (int i = 0; i < itemsPerPage && start + i < sectionNames.length; ++i) {
            ItemStack item = new ItemStack(icons[start + i]);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + sectionNames[start + i]);
                meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + sectionDescriptions[start + i], "", String.valueOf(ChatColor.GREEN) + "Click to open"));
                item.setItemMeta(meta);
            }
            sectionGUI.setItem(slots[i], item);
        }
        if (page > 1) {
            sectionGUI.setItem(18, ShopGUIListener.createNavItem(Material.ARROW, String.valueOf(ChatColor.GREEN) + "Previous Page"));
        }
        if (start + itemsPerPage < sectionNames.length) {
            sectionGUI.setItem(26, ShopGUIListener.createNavItem(Material.ARROW, String.valueOf(ChatColor.GREEN) + "Next Page"));
        }
        sectionGUI.setItem(22, ShopGUIListener.createNavItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close"));
        player.openInventory(sectionGUI);
    }

    public static void openShopGUI(Player player, String section, int page) {
        List<ShopItem> items = ShopManager.getItems(section);
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GREEN) + "Shop: " + section + " (Page " + page + ")"));
        for (ShopItem item : items) {
            if (item.getPage() != page) continue;
            ItemStack display = item.getItem().clone();
            ItemMeta meta = display.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + ShopGUIListener.capitalizeWords(display.getType().name().replace("_", " ")));
                meta.setLore(Arrays.asList(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Price:", String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "  Buy: $" + item.getBuyPrice(), String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "  Sell: $" + item.getSellPrice(), "", String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Usage:", String.valueOf(ChatColor.YELLOW) + "  Left-click to buy", String.valueOf(ChatColor.YELLOW) + "  Right-click to sell"));
                display.setItemMeta(meta);
            }
            gui.setItem(item.getSlot(), display);
        }
        gui.setItem(45, ShopGUIListener.createNavItem(Material.ARROW, String.valueOf(ChatColor.GREEN) + "Previous Page"));
        gui.setItem(49, ShopGUIListener.createNavItem(Material.BARRIER, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Close"));
        gui.setItem(53, ShopGUIListener.createNavItem(Material.ARROW, String.valueOf(ChatColor.GREEN) + "Next Page"));
        player.openInventory(gui);
    }

    private static ItemStack createNavItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static String capitalizeWords(String input) {
        StringBuilder result = new StringBuilder();
        for (String word : input.split(" ")) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR || !clicked.hasItemMeta()) {
            return;
        }
        String title = ChatColor.stripColor((String)event.getView().getTitle());
        String itemName = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        event.setCancelled(true);
        if (title.startsWith("Shop Sections")) {
            int currentPage = this.extractPageNumber(title);
            switch (clicked.getType()) {
                case BARRIER: {
                    player.closeInventory();
                    break;
                }
                case ARROW: {
                    if (itemName.equalsIgnoreCase("Previous Page")) {
                        ShopGUIListener.openSectionSelector(player, currentPage - 1);
                        break;
                    }
                    if (!itemName.equalsIgnoreCase("Next Page")) break;
                    ShopGUIListener.openSectionSelector(player, currentPage + 1);
                    break;
                }
                default: {
                    ShopGUIListener.openShopGUI(player, itemName, 1);
                }
            }
            return;
        }
        if (title.startsWith("Shop: ")) {
            int page;
            String[] parts = title.replace("Shop: ", "").split(" \\(Page ");
            if (parts.length != 2) {
                return;
            }
            String section = parts[0];
            try {
                page = Integer.parseInt(parts[1].replace(")", ""));
            }
            catch (NumberFormatException e) {
                return;
            }
            if (clicked.getType() == Material.BARRIER && itemName.equalsIgnoreCase("Close")) {
                player.closeInventory();
                return;
            }
            if (clicked.getType() == Material.ARROW) {
                if (itemName.equalsIgnoreCase("Next Page")) {
                    ShopGUIListener.openShopGUI(player, section, page + 1);
                } else if (itemName.equalsIgnoreCase("Previous Page") && page > 1) {
                    ShopGUIListener.openShopGUI(player, section, page - 1);
                }
                return;
            }
            for (ShopItem shopItem : ShopManager.getItems(section)) {
                if (shopItem.getPage() != page || shopItem.getSlot() != event.getSlot() || shopItem.getItem().getType() != clicked.getType()) continue;
                if (event.getClick().isLeftClick()) {
                    double price = shopItem.getBuyPrice();
                    if (EconomyManager.getBalance((OfflinePlayer)player) < price) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money to buy this!");
                        return;
                    }
                    EconomyManager.takeBalance((OfflinePlayer)player, price);
                    player.getInventory().addItem(new ItemStack[]{shopItem.getItem().clone()});
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "You bought " + String.valueOf(ChatColor.YELLOW) + shopItem.getItem().getType().name().replace("_", " ") + String.valueOf(ChatColor.GREEN) + " for $" + price);
                } else if (event.getClick().isRightClick()) {
                    ItemStack sellingItem = shopItem.getItem().clone();
                    sellingItem.setAmount(1);
                    if (!player.getInventory().containsAtLeast(sellingItem, 1)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have this item to sell!");
                        return;
                    }
                    player.getInventory().removeItem(new ItemStack[]{sellingItem});
                    EconomyManager.addBalance((OfflinePlayer)player, shopItem.getSellPrice());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "You sold " + String.valueOf(ChatColor.YELLOW) + sellingItem.getType().name().replace("_", " ") + String.valueOf(ChatColor.GREEN) + " for $" + shopItem.getSellPrice());
                }
                return;
            }
        }
    }

    private int extractPageNumber(String title) {
        int page = 1;
        if (title.contains("(Page ")) {
            try {
                page = Integer.parseInt(title.split("\\(Page ")[1].replace(")", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return page;
    }
}

