/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import serveressentials.serveressentials.EconomyManager;
import serveressentials.serveressentials.ShopConfigManager;
import serveressentials.serveressentials.ShopItem;

public class ShopManager {
    private static final Map<String, List<ShopItem>> sections = new HashMap<String, List<ShopItem>>();

    public static void addItem(ShopItem item) {
        sections.computeIfAbsent(item.getSection(), k -> new ArrayList()).add(item);
    }

    public static List<ShopItem> getItems(String section, int page) {
        List all = sections.getOrDefault(section, new ArrayList());
        ArrayList<ShopItem> filtered = new ArrayList<ShopItem>();
        for (ShopItem item : all) {
            if (item.getPage() != page) continue;
            filtered.add(item);
        }
        return filtered;
    }

    public static List<ShopItem> getItems(String section) {
        return sections.getOrDefault(section, new ArrayList());
    }

    public static Set<String> getSections() {
        return sections.keySet();
    }

    public static int getMaxPages(String section) {
        int max = 1;
        for (ShopItem item : ShopManager.getItems(section)) {
            if (item.getPage() <= max) continue;
            max = item.getPage();
        }
        return max;
    }

    public static void loadShopItems() {
        ShopConfigManager.loadShopItems();
    }

    public static void saveShopItems() {
        ShopConfigManager.saveShopItems();
    }

    public static double getSellPrice(Material type) {
        ShopItem item = ShopManager.findItemByType(type);
        return item != null ? item.getSellPrice() : 0.0;
    }

    public static ShopItem findItemByType(Material type) {
        for (List<ShopItem> list : sections.values()) {
            for (ShopItem item : list) {
                if (item.getItem().getType() != type) continue;
                return item;
            }
        }
        return null;
    }

    public static void addShopItem(ShopItem item) {
        ShopManager.addItem(item);
    }

    public static void clearItems() {
        sections.clear();
    }

    public static boolean buyItem(Player player, ShopItem item) {
        double price = item.getBuyPrice();
        double balance = EconomyManager.getBalance((OfflinePlayer)player);
        if (balance >= price) {
            EconomyManager.takeBalance(player.getUniqueId(), price);
            player.getInventory().addItem(new ItemStack[]{item.getItem().clone()});
            player.sendMessage("\u00a7aYou bought " + String.valueOf(item.getItem().getType()) + " for $" + price);
            return true;
        }
        player.sendMessage("\u00a7cYou don't have enough money to buy this item.");
        return false;
    }
}

