/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import serveressentials.serveressentials.ServerEssentials;

public class SimpleScoreboard {
    private final ServerEssentials plugin;
    private FileConfiguration scoreboardConfig;
    private File scoreboardFile;
    private static final Set<UUID> disabledPlayers = new HashSet<UUID>();

    public SimpleScoreboard(ServerEssentials plugin) {
        this.plugin = plugin;
        this.createScoreboardFile();
        this.startUpdater();
    }

    private void createScoreboardFile() {
        this.scoreboardFile = new File(this.plugin.getDataFolder(), "scoreboard.yml");
        if (!this.scoreboardFile.exists()) {
            this.scoreboardFile.getParentFile().mkdirs();
            try {
                this.scoreboardFile.createNewFile();
                this.scoreboardConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardFile);
                this.scoreboardConfig.set("title", (Object)"&f\u00ab &cYour&fServer &f\u00bb");
                this.scoreboardConfig.set("lines", Arrays.asList("&f&m----------------------", "&c| Online: &f%server_online%/%server_max_players%", "&c| Player: &f%player_name%", "&c| Kills: &f%serveressentials_kills%", "&c| Deaths: &f%serveressentials_death%", "&c| Rank: &f%serveressentials_rank%", "&c| Playtime: &f%serveressentials_playtime%", "&c| Ping: &f%player_ping%ms", "&c| Balance: &f%serveressentials_money%", "&7", "&fstore.example.com", "&f&m----------------------"));
                this.scoreboardConfig.save(this.scoreboardFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.scoreboardConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardFile);
        }
    }

    public void reloadScoreboardConfig() {
        this.scoreboardConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardFile);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (SimpleScoreboard.isDisabled(player)) continue;
            SimpleScoreboard.setScoreboard(player);
        }
    }

    public static void setScoreboard(Player player) {
        if (SimpleScoreboard.isDisabled(player)) {
            return;
        }
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            return;
        }
        Scoreboard board = manager.getNewScoreboard();
        SimpleScoreboard instance = ((ServerEssentials)JavaPlugin.getPlugin(ServerEssentials.class)).getScoreboard();
        String rawTitle = instance.scoreboardConfig.getString("title", "&f\u00ab &cYour&fServer &f\u00bb");
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)rawTitle);
        Objective objective = board.registerNewObjective("main", "dummy", title);
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        List lines = instance.scoreboardConfig.getStringList("lines");
        int score = lines.size();
        HashSet<String> usedLines = new HashSet<String>();
        for (String line : lines) {
            Object parsedLine = PlaceholderAPI.setPlaceholders((Player)player, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            if (((String)parsedLine).length() > 40) {
                parsedLine = ((String)parsedLine).substring(0, 40);
            }
            while (usedLines.contains(parsedLine)) {
                parsedLine = (String)parsedLine + String.valueOf(ChatColor.RESET);
            }
            usedLines.add((String)parsedLine);
            objective.getScore((String)parsedLine).setScore(score--);
        }
        player.setScoreboard(board);
    }

    public static void removeScoreboard(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    public static void disable(Player player) {
        disabledPlayers.add(player.getUniqueId());
        SimpleScoreboard.removeScoreboard(player);
    }

    public static void enable(Player player) {
        disabledPlayers.remove(player.getUniqueId());
        SimpleScoreboard.setScoreboard(player);
    }

    public static boolean isDisabled(Player player) {
        return disabledPlayers.contains(player.getUniqueId());
    }

    private void startUpdater() {
        new BukkitRunnable(this){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (SimpleScoreboard.isDisabled(player)) continue;
                    SimpleScoreboard.setScoreboard(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }
}

