/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import serveressentials.serveressentials.BanManager;

public class UnbanCommand
implements CommandExecutor {
    private final BanManager banManager;

    public UnbanCommand(BanManager banManager) {
        this.banManager = banManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("ban.use")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /unban <player>");
            return true;
        }
        String playerName = args[0];
        UUID uuid = this.banManager.getUUIDFromName(playerName);
        if (uuid == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not find banned player with name '" + playerName + "'.");
            return true;
        }
        if (!this.banManager.isBanned(uuid)) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + playerName + " is not currently banned.");
            return true;
        }
        this.banManager.unbanPlayer(uuid);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + playerName + " has been unbanned.");
        return true;
    }
}

