/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultManager
implements Listener {
    private final JavaPlugin plugin;
    private final File vaultsFolder;
    private final Map<UUID, VaultSession> editingVaults = new HashMap<UUID, VaultSession>();

    public VaultManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.vaultsFolder = new File(plugin.getDataFolder(), "vaults");
        if (!this.vaultsFolder.exists()) {
            this.vaultsFolder.mkdirs();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openVault(Player player, int number) {
        if (!this.isValidVaultNumber(number)) {
            player.sendMessage("\u00a7cVault number must be between 1 and 10.");
            return;
        }
        if (!player.hasPermission("serveressentials.vault" + number)) {
            player.sendMessage("\u00a7cYou do not have permission to open vault " + number + ".");
            return;
        }
        Inventory inv = this.loadVault(player.getUniqueId(), number, "Vault " + number);
        player.openInventory(inv);
        player.setMetadata("vault_id", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)number));
    }

    public void openVaultAsAdmin(Player admin, UUID targetUUID, String targetName, int number, boolean previewOnly) {
        if (!this.isValidVaultNumber(number)) {
            admin.sendMessage("\u00a7cVault number must be between 1 and 10.");
            return;
        }
        String title = (previewOnly ? "Viewing " : "Editing ") + targetName + "'s Vault " + number;
        Inventory inv = this.loadVault(targetUUID, number, title);
        admin.openInventory(inv);
        if (!previewOnly) {
            this.editingVaults.put(admin.getUniqueId(), new VaultSession(targetUUID, number));
            admin.setMetadata("editing_vault", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
    }

    private Inventory loadVault(UUID uuid, int number, String title) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)title);
        File file = this.getVaultFile(uuid, number);
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        for (int i = 0; i < 54; ++i) {
            if (!data.contains("slot." + i)) continue;
            inv.setItem(i, data.getItemStack("slot." + i));
        }
        return inv;
    }

    @EventHandler
    public void onVaultClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory inv = event.getInventory();
        if (player.hasMetadata("vault_id")) {
            int vaultId = ((MetadataValue)player.getMetadata("vault_id").get(0)).asInt();
            player.removeMetadata("vault_id", (Plugin)this.plugin);
            this.saveVault(player.getUniqueId(), vaultId, inv);
        } else if (player.hasMetadata("editing_vault")) {
            VaultSession session = this.editingVaults.remove(player.getUniqueId());
            if (session != null) {
                this.saveVault(session.targetUUID, session.vaultNumber, inv);
            }
            player.removeMetadata("editing_vault", (Plugin)this.plugin);
        }
    }

    private void saveVault(UUID uuid, int number, Inventory inv) {
        File file = this.getVaultFile(uuid, number);
        YamlConfiguration data = new YamlConfiguration();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            data.set("slot." + i, (Object)item);
        }
        try {
            data.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save vault " + number + " for UUID " + String.valueOf(uuid) + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void clearVault(UUID uuid, int number) {
        File file = this.getVaultFile(uuid, number);
        if (file.exists()) {
            file.delete();
        }
    }

    public File getVaultFile(UUID uuid, int number) {
        return new File(this.vaultsFolder, String.valueOf(uuid) + "_vault" + number + ".yml");
    }

    private boolean isValidVaultNumber(int number) {
        return number >= 1 && number <= 10;
    }

    private static class VaultSession {
        public final UUID targetUUID;
        public final int vaultNumber;

        public VaultSession(UUID targetUUID, int vaultNumber) {
            this.targetUUID = targetUUID;
            this.vaultNumber = vaultNumber;
        }
    }
}

