/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONArray;
import org.json.JSONObject;
import serveressentials.serveressentials.ServerEssentials;

public class VersionChecker {
    private static final String CURRENT_VERSION = "1.3";
    private static final String MODRINTH_PROJECT_ID = "K7HZMVgx";
    private static String latestVersion = "unknown";

    public static void checkLatestVersion(Plugin plugin) {
        HttpClient client = HttpClient.newHttpClient();
        String url = "https://api.modrinth.com/v2/project/K7HZMVgx/version";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(response -> {
            try {
                JSONObject latest;
                JSONArray versions = new JSONArray(response);
                if (versions.length() > 0 && !CURRENT_VERSION.equalsIgnoreCase(latestVersion = (latest = versions.getJSONObject(0)).getString("version_number"))) {
                    Bukkit.getLogger().warning("[ServerEssentials] A new version is available: v" + latestVersion);
                    Bukkit.getLogger().warning("[ServerEssentials] You are currently running v1.3");
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[ServerEssentials] Failed to parse version data.");
                e.printStackTrace();
            }
        })).exceptionally(e -> {
            Bukkit.getLogger().warning("[ServerEssentials] Could not fetch latest version from Modrinth.");
            e.printStackTrace();
            return null;
        });
    }

    public static void notifyIfOutdated(Player player) {
        String currentVersion = ServerEssentials.getInstance().getDescription().getVersion();
        String latestVersion = VersionChecker.getLatestVersion();
        if (!latestVersion.equals("unknown") && !currentVersion.equals(latestVersion) && (player.hasPermission("serveressentials.version.notify") || player.isOp())) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[ServerEssentials] A new version (" + latestVersion + ") is available!");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Download: " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/plugin/serveressentials");
        }
    }

    public static String getLatestVersion() {
        return latestVersion;
    }

    public static String getCurrentVersion() {
        return CURRENT_VERSION;
    }
}

