/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class WarpManager {
    private static File file;
    private static FileConfiguration config;

    public static void setup() {
        file = new File(Bukkit.getPluginManager().getPlugin("ServerEssentials").getDataFolder(), "warps.yml");
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void setWarp(String name, Location loc) {
        config.set("warps." + name + ".location", (Object)loc);
        config.set("warps." + name + ".enabled", (Object)true);
        WarpManager.save();
    }

    public static Location getWarp(String name) {
        if (!WarpManager.warpExists(name)) {
            return null;
        }
        return config.getLocation("warps." + name + ".location");
    }

    public static boolean warpExists(String name) {
        return config.contains("warps." + name);
    }

    public static boolean isWarpEnabled(String name) {
        return config.getBoolean("warps." + name + ".enabled", false);
    }

    public static void closeWarp(String name) {
        if (WarpManager.warpExists(name)) {
            config.set("warps." + name + ".enabled", (Object)false);
            WarpManager.save();
        }
    }

    public static void reopenWarp(String name) {
        if (WarpManager.warpExists(name)) {
            config.set("warps." + name + ".enabled", (Object)true);
            WarpManager.save();
        }
    }

    public static void deleteWarp(String name) {
        config.set("warps." + name, null);
        WarpManager.save();
    }

    public static Set<String> getWarpNames() {
        if (!config.contains("warps")) {
            return new HashSet<String>();
        }
        return config.getConfigurationSection("warps").getKeys(false);
    }

    public static void renameWarp(String oldName, String newName) {
        Location loc = WarpManager.getWarp(oldName);
        boolean enabled = WarpManager.isWarpEnabled(oldName);
        if (loc != null) {
            WarpManager.setWarp(newName, loc);
            config.set("warps." + newName + ".enabled", (Object)enabled);
            WarpManager.deleteWarp(oldName);
        }
    }

    private static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

