/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InventorySortCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public InventorySortCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("InventorySort.PlayerOnly", "<red>Only players can use this command!");
        messages.addDefault("InventorySort.Success", "<green>Your inventory has been stacked and sorted!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("InventorySort.PlayerOnly", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        ItemStack[] contents = player.getInventory().getContents();
        HashMap<Material, Integer> itemCounts = new HashMap<Material, Integer>();
        for (ItemStack item : contents) {
            if (item == null) continue;
            itemCounts.put(item.getType(), itemCounts.getOrDefault(item.getType(), 0) + item.getAmount());
        }
        player.getInventory().clear();
        ArrayList sortedMaterials = new ArrayList(itemCounts.keySet());
        sortedMaterials.sort(Comparator.comparing(Enum::toString));
        int slot = 0;
        for (Material mat : sortedMaterials) {
            int total = (Integer)itemCounts.get(mat);
            int maxStack = mat.getMaxStackSize();
            while (total > 0) {
                int stackSize = Math.min(total, maxStack);
                player.getInventory().setItem(slot, new ItemStack(mat, stackSize));
                total -= stackSize;
                ++slot;
            }
        }
        Component msg = this.messages.get("InventorySort.Success", new String[0]);
        player.sendMessage(msg);
        return true;
    }
}

