/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.HashSet;
import java.util.Set;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MagnetCommand
implements CommandExecutor {
    private final Set<Player> activeMagnets = new HashSet<Player>();
    private final JavaPlugin plugin;
    private final PlayerMessages messages;

    public MagnetCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        this.messages = ((ServerEssentials)plugin).getPlayerMessages();
        this.startMagnetTask();
    }

    private void startMagnetTask() {
        new BukkitRunnable(){

            public void run() {
                if (MagnetCommand.this.activeMagnets.isEmpty()) {
                    return;
                }
                for (Player player : new HashSet<Player>(MagnetCommand.this.activeMagnets)) {
                    if (!player.isOnline()) {
                        MagnetCommand.this.activeMagnets.remove(player);
                        continue;
                    }
                    player.getWorld().getNearbyEntities(player.getLocation(), 5.0, 5.0, 5.0).stream().filter(entity -> entity instanceof Item).map(entity -> (Item)entity).forEach(item -> {
                        Vector direction = player.getLocation().toVector().subtract(item.getLocation().toVector()).normalize().multiply(0.5);
                        item.setVelocity(direction);
                    });
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Magnet.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (this.activeMagnets.contains(player)) {
            this.activeMagnets.remove(player);
            player.sendMessage(this.messages.get("Magnet.off", new String[0]));
        } else {
            this.activeMagnets.add(player);
            player.sendMessage(this.messages.get("Magnet.on", new String[0]));
        }
        Bukkit.getLogger().info("DEBUG Magnet.on = " + this.messages.getConfig().getString("Magnet.on"));
        return true;
    }
}

