/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MsgToggleCommand
implements CommandExecutor {
    private static final Set<UUID> toggled = new HashSet<UUID>();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final ServerEssentials plugin;
    private final File file;
    private FileConfiguration config;

    public MsgToggleCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "storage/msgtoggle.yml");
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create msgtoggle.yml!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadToggled();
    }

    private void loadToggled() {
        List uuids = this.config.getStringList("toggled");
        for (String s : uuids) {
            try {
                toggled.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void saveToggled() {
        List<String> uuids = toggled.stream().map(UUID::toString).toList();
        this.config.set("toggled", uuids);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save msgtoggle.yml!");
            e.printStackTrace();
        }
    }

    public static boolean hasMessagesDisabled(Player player) {
        return toggled.contains(player.getUniqueId());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text("Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (toggled.contains(player.getUniqueId())) {
            toggled.remove(player.getUniqueId());
            this.saveToggled();
            player.sendMessage(this.miniMessage.deserialize("<green>Private messages enabled!"));
        } else {
            toggled.add(player.getUniqueId());
            this.saveToggled();
            player.sendMessage(this.miniMessage.deserialize("<yellow>Private messages disabled!"));
        }
        return true;
    }

    public void saveOnDisable() {
        this.saveToggled();
    }
}

