/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.ArrayList;
import java.util.List;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PTimeCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerMessages messages;

    public PTimeCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String option;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("PTime.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(this.messages.get("PTime.usage", new String[0]));
            return true;
        }
        switch (option = args[0].toLowerCase()) {
            case "day": {
                if (!player.hasPermission("serveressentials.ptime.day")) {
                    player.sendMessage(this.messages.get("PTime.no-permission", new String[0]));
                    return true;
                }
                player.setPlayerTime(1000L, false);
                break;
            }
            case "night": {
                if (!player.hasPermission("serveressentials.ptime.night")) {
                    player.sendMessage(this.messages.get("PTime.no-permission", new String[0]));
                    return true;
                }
                player.setPlayerTime(13000L, false);
                break;
            }
            case "reset": {
                if (!player.hasPermission("serveressentials.ptime.reset")) {
                    player.sendMessage(this.messages.get("PTime.no-permission", new String[0]));
                    return true;
                }
                player.resetPlayerTime();
                break;
            }
            default: {
                player.sendMessage(this.messages.get("PTime.invalid-option", new String[0]));
                return true;
            }
        }
        player.sendMessage(this.messages.get("PTime.success", "{option}", option.toUpperCase()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (player.hasPermission("serveressentials.ptime.day")) {
                completions.add("day");
            }
            if (player.hasPermission("serveressentials.ptime.night")) {
                completions.add("night");
            }
            if (player.hasPermission("serveressentials.ptime.reset")) {
                completions.add("reset");
            }
        }
        return completions;
    }
}

