/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.java.JavaPlugin;

public class RecipeCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerMessages messages;

    public RecipeCommand(PlayerMessages messages, JavaPlugin plugin) {
        this.messages = messages;
        messages.addDefault("recipe.usage", "<red>Usage: /recipe <recipe>");
        messages.addDefault("recipe.not-found", "<red>Recipe not found!");
        messages.addDefault("recipe.result", "<green>Recipe for: <yellow>{item}");
        messages.addDefault("recipe.shaped-header", "<aqua>Shaped Recipe Ingredients:");
        messages.addDefault("recipe.shapeless-header", "<aqua>Shapeless Recipe Ingredients:");
        messages.addDefault("recipe.ingredient-line", "<yellow>- {char}: {item} x{amount}");
        messages.addDefault("recipe.ingredient-line-shapeless", "<yellow>- {item} x{amount}");
        messages.addDefault("recipe.unknown-type", "<red>Unknown recipe type!");
        plugin.getCommand("recipe").setExecutor((CommandExecutor)this);
        plugin.getCommand("recipe").setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.messages.get("recipe.usage", new String[0]));
            return true;
        }
        NamespacedKey key = NamespacedKey.minecraft((String)args[0].toLowerCase());
        Recipe recipe = Bukkit.getRecipe((NamespacedKey)key);
        if (recipe == null) {
            sender.sendMessage(this.messages.get("recipe.not-found", new String[0]));
            return true;
        }
        ItemStack result = recipe.getResult();
        sender.sendMessage(this.messages.get("recipe.result", "{item}", result.getType().toString()));
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            sender.sendMessage(this.messages.get("recipe.shaped-header", new String[0]));
            shaped.getIngredientMap().forEach((character, itemStack) -> {
                if (itemStack != null) {
                    sender.sendMessage(this.messages.get("recipe.ingredient-line", "{char}", character.toString(), "{item}", itemStack.getType().toString(), "{amount}", String.valueOf(itemStack.getAmount())));
                }
            });
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            sender.sendMessage(this.messages.get("recipe.shapeless-header", new String[0]));
            for (ItemStack ingredient : shapeless.getIngredientList()) {
                if (ingredient == null) continue;
                sender.sendMessage(this.messages.get("recipe.ingredient-line-shapeless", "{item}", ingredient.getType().toString(), "{amount}", String.valueOf(ingredient.getAmount())));
            }
        } else {
            sender.sendMessage(this.messages.get("recipe.unknown-type", new String[0]));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            String current = args[0].toLowerCase();
            ArrayList<String> results = new ArrayList<String>();
            for (Recipe recipe2 : Bukkit.getRecipesFor((ItemStack)new ItemStack(Material.CRAFTING_TABLE))) {
            }
            Bukkit.recipeIterator().forEachRemaining(recipe -> {
                String name;
                if (recipe == null || recipe.getResult() == null) {
                    return;
                }
                NamespacedKey key = null;
                if (recipe instanceof Keyed) {
                    Keyed keyed = (Keyed)recipe;
                    key = keyed.getKey();
                }
                if (key != null && (name = key.getKey()).toLowerCase().startsWith(current)) {
                    results.add(name);
                }
            });
            return results;
        }
        return Collections.emptyList();
    }
}

