/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReplyCommand
implements CommandExecutor {
    private final HashMap<UUID, UUID> lastMessageMap;
    private final PlayerMessages messages;

    public ReplyCommand(HashMap<UUID, UUID> lastMessageMap, PlayerMessages messages) {
        this.lastMessageMap = lastMessageMap;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.messages.get("reply.only-players", new String[0]);
            sender.sendMessage(msg);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(this.messages.get("reply.usage", new String[0]));
            return true;
        }
        if (!this.lastMessageMap.containsKey(player.getUniqueId())) {
            player.sendMessage(this.messages.get("reply.no-reply", new String[0]));
            return true;
        }
        UUID targetUUID = this.lastMessageMap.get(player.getUniqueId());
        Player target = Bukkit.getPlayer((UUID)targetUUID);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.messages.get("reply.target-offline", new String[0]));
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        Component senderMsg = this.messages.get("reply.sender", "<target>", target.getName(), "<message>", message);
        player.sendMessage(senderMsg);
        Component receiverMsg = this.messages.get("reply.receiver", "<sender>", player.getName(), "<message>", message);
        target.sendMessage(receiverMsg);
        this.lastMessageMap.put(target.getUniqueId(), player.getUniqueId());
        return true;
    }
}

