/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ReportCommand
implements CommandExecutor,
TabCompleter {
    private final ServerEssentials plugin;
    private final PlayerMessages messages;
    private File file;
    private FileConfiguration config;

    public ReportCommand(ServerEssentials plugin, PlayerMessages messages) {
        this.plugin = plugin;
        this.messages = messages;
        this.setupFile();
        this.loadDefaults();
    }

    private void setupFile() {
        this.file = new File(this.plugin.getDataFolder(), "storage/reports.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create reports.yml: " + e.getMessage());
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save reports.yml: " + e.getMessage());
        }
    }

    private void loadDefaults() {
        this.messages.addDefault("report.usage", "<red>Usage: /report <player> <reason>");
        this.messages.addDefault("report.invalid-player", "<red>Player <white>{player}</white> not found!");
        this.messages.addDefault("report.submitted", "<green>Report submitted against <yellow>{player}</yellow> for <white>{reason}</white>");
        this.messages.addDefault("report.notify", "<red>[REPORT]</red> <yellow>{reporter}</yellow> reported <gold>{target}</gold> for <gray>{reason}</gray> <dark_gray>(ID: {id})</dark_gray>");
        this.messages.addDefault("report.no-permission", "<red>You don't have permission to do that.");
        this.messages.addDefault("reportclear.usage", "<red>Usage: /reportclear <id>");
        this.messages.addDefault("reportclear.invalid", "<red>Invalid report ID: <white>{id}</white>");
        this.messages.addDefault("reportclear.cleared", "<green>Cleared report ID: <white>{id}</white>");
        this.messages.addDefault("report.pending.header", "<yellow>You have pending reports to review:");
        this.messages.addDefault("report.pending.entry", "<red>[PENDING]</red> <yellow>{reporter}</yellow> \u2192 <gold>{target}</gold>: <gray>{reason}</gray> <dark_gray>(ID: {id})</dark_gray>");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        switch (cmd = command.getName().toLowerCase(Locale.ROOT)) {
            case "report": {
                return this.handleReport(sender, args);
            }
            case "reportclear": {
                return this.handleClear(sender, args);
            }
        }
        return false;
    }

    private boolean handleReport(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            player.sendMessage(this.messages.get("report.usage", new String[0]));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            player.sendMessage(this.messages.get("report.invalid-player", "{player}", args[0]));
            return true;
        }
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String id = UUID.randomUUID().toString().substring(0, 8);
        this.config.set("reports." + id + ".reporter", (Object)player.getUniqueId().toString());
        this.config.set("reports." + id + ".target", (Object)target.getUniqueId().toString());
        this.config.set("reports." + id + ".reason", (Object)reason);
        this.config.set("reports." + id + ".timestamp", (Object)System.currentTimeMillis());
        this.save();
        player.sendMessage(this.messages.get("report.submitted", "{player}", target.getName(), "{reason}", reason));
        Component notify = this.messages.get("report.notify", "{id}", id, "{reporter}", player.getName(), "{target}", target.getName() != null ? target.getName() : "Unknown", "{reason}", reason);
        boolean notified = false;
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("serveressentials.report.admin")) continue;
            admin.sendMessage(notify);
            notified = true;
        }
        if (!notified) {
            this.config.set("pending." + id, (Object)true);
            this.save();
        }
        return true;
    }

    private boolean handleClear(CommandSender sender, String[] args) {
        if (!sender.hasPermission("serveressentials.report.admin")) {
            sender.sendMessage(this.messages.get("report.no-permission", new String[0]));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.messages.get("reportclear.usage", new String[0]));
            return true;
        }
        String id = args[0];
        this.reload();
        if (!this.config.contains("reports." + id)) {
            sender.sendMessage(this.messages.get("reportclear.invalid", "{id}", id));
            return true;
        }
        this.config.set("reports." + id, null);
        this.save();
        sender.sendMessage(this.messages.get("reportclear.cleared", "{id}", id));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        this.reload();
        if (command.getName().equalsIgnoreCase("report") && args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }
        if (command.getName().equalsIgnoreCase("reportclear") && args.length == 1 && this.config.contains("reports")) {
            return new ArrayList<String>(this.config.getConfigurationSection("reports").getKeys(false));
        }
        return Collections.emptyList();
    }

    public void handleJoin(Player player) {
        if (!player.hasPermission("serveressentials.report.admin")) {
            return;
        }
        this.reload();
        if (!this.config.contains("pending")) {
            return;
        }
        player.sendMessage(this.messages.get("report.pending.header", new String[0]));
        for (String id : this.config.getConfigurationSection("pending").getKeys(false)) {
            if (!this.config.contains("reports." + id)) continue;
            String reporterUUID = this.config.getString("reports." + id + ".reporter");
            String targetUUID = this.config.getString("reports." + id + ".target");
            String reason = this.config.getString("reports." + id + ".reason");
            OfflinePlayer reporter = Bukkit.getOfflinePlayer((UUID)UUID.fromString(reporterUUID));
            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(targetUUID));
            player.sendMessage(this.messages.get("report.pending.entry", "{id}", id, "{reporter}", reporter.getName() != null ? reporter.getName() : "Unknown", "{target}", target.getName() != null ? target.getName() : "Unknown", "{reason}", reason));
        }
        this.config.set("pending", null);
        this.save();
    }
}

