/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lunark.io.ServerEssentials;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class ReportManager {
    private final ServerEssentials plugin;
    private final File file;
    private FileConfiguration cfg;

    public ReportManager(ServerEssentials plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "storage" + File.separator + "reports.yml");
        this.ensureFile();
        this.reload();
    }

    private void ensureFile() {
        try {
            File parent = this.file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create reports.yml: " + e.getMessage());
        }
    }

    public synchronized void reload() {
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public synchronized void save() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save reports.yml: " + e.getMessage());
        }
    }

    public synchronized void addReport(String id, UUID reporter, UUID target, String reason, long timestamp) {
        this.cfg.set("reports." + id + ".reporter", (Object)reporter.toString());
        this.cfg.set("reports." + id + ".target", (Object)target.toString());
        this.cfg.set("reports." + id + ".reason", (Object)reason);
        this.cfg.set("reports." + id + ".timestamp", (Object)timestamp);
        this.save();
    }

    public synchronized boolean reportExists(String id) {
        return this.cfg.contains("reports." + id);
    }

    public synchronized void removeReport(String id) {
        if (this.cfg.contains("reports." + id)) {
            this.cfg.set("reports." + id, null);
        }
        if (this.cfg.contains("pending." + id)) {
            this.cfg.set("pending." + id, null);
        }
        this.save();
    }

    public synchronized Map<String, Map<String, Object>> getAllReports() {
        LinkedHashMap<String, Map<String, Object>> out = new LinkedHashMap<String, Map<String, Object>>();
        if (!this.cfg.contains("reports")) {
            return out;
        }
        ConfigurationSection section = this.cfg.getConfigurationSection("reports");
        if (section == null) {
            return out;
        }
        for (String id : section.getKeys(false)) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("reporter", this.cfg.getString("reports." + id + ".reporter"));
            m.put("target", this.cfg.getString("reports." + id + ".target"));
            m.put("reason", this.cfg.getString("reports." + id + ".reason"));
            m.put("timestamp", this.cfg.getLong("reports." + id + ".timestamp", 0L));
            out.put(id, m);
        }
        return out;
    }

    public synchronized void markPending(String id) {
        if (!this.cfg.contains("pending")) {
            this.cfg.createSection("pending");
        }
        this.cfg.set("pending." + id, (Object)true);
        this.save();
    }

    public synchronized List<String> getPendingIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (!this.cfg.contains("pending")) {
            return ids;
        }
        ConfigurationSection sec = this.cfg.getConfigurationSection("pending");
        if (sec == null) {
            return ids;
        }
        ids.addAll(sec.getKeys(false));
        return ids;
    }

    public synchronized void clearPending() {
        if (this.cfg.contains("pending")) {
            this.cfg.set("pending", null);
            this.save();
        }
    }

    public synchronized boolean hasPending() {
        if (!this.cfg.contains("pending")) {
            return false;
        }
        ConfigurationSection sec = this.cfg.getConfigurationSection("pending");
        return sec != null && !sec.getKeys(false).isEmpty();
    }
}

