/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class SeenCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public SeenCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
        this.messages.addDefault("seen.usage", "<yellow>Usage: /seen <player>");
        this.messages.addDefault("seen.player-not-found", "<red>Player not found!");
        this.messages.addDefault("seen.result", "<green>{player} was last seen on <white>{lastSeen}");
        this.messages.addDefault("seen.never-joined", "<yellow>{player} has never joined the server.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String playerName;
        if (args.length == 0) {
            sender.sendMessage(this.messages.get("seen.usage", new String[0]));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayerIfCached((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.messages.get("seen.player-not-found", new String[0]));
            return true;
        }
        String string = playerName = target.getName() != null ? target.getName() : args[0];
        if (target.getLastPlayed() == 0L) {
            sender.sendMessage(this.messages.get("seen.never-joined", "{player}", playerName));
            return true;
        }
        String lastSeen = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(target.getLastPlayed()));
        sender.sendMessage(this.messages.get("seen.result", "{player}", playerName, "{lastSeen}", lastSeen));
        return true;
    }
}

