/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.kyori.adventure.text.Component;
import net.lunark.io.Managers.SessionManager;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SessionCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final SessionManager sessionManager;

    public SessionCommand(PlayerMessages messages, SessionManager sessionManager) {
        this.messages = messages;
        this.sessionManager = sessionManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("session.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        long current = this.sessionManager.getCurrentSession(player);
        if (current == 0L) {
            sender.sendMessage(this.messages.get("session.not-tracked", new String[0]));
            return true;
        }
        long longest = this.sessionManager.getLongestSession(player);
        String currentStr = this.formatDuration(current);
        String longestStr = this.formatDuration(longest);
        Component msg = this.messages.get("session.info", "<current>", currentStr, "<longest>", longestStr);
        player.sendMessage(msg);
        return true;
    }

    private String formatDuration(long millis) {
        long seconds = millis / 1000L % 60L;
        long minutes = millis / 60000L % 60L;
        long hours = millis / 3600000L;
        return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
    }
}

